--
-- self
-- for all self
--
-- @author by landwirtschaftssimulator-2009.de
-- @date  08/06/09
--
-- Copyright (C) 

Ursus = {};

function Ursus.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Ursus:load(xmlFile)
      
    self.numWorklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    self.worklights = {};
    for i=1, self.numWorklights do
        local worklightnamei = string.format("vehicle.worklights.worklight" .. "%d", i);
        self.worklights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.worklights[i], false);
    end;	
	
	self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;
	self.brakelightsActive = false;
    self.braking = false;
	
	local radioSound = getXMLString(xmlFile, "vehicle.radioSound#file");
    if  radioSound ~= nil and  radioSound ~= "" then
        radioSound = Utils.getFilename( radioSound, self.baseDirectory); 
        self.radioSound = createSample(" radioSound");
        self.radioSoundPlaying = false;
        loadSample(self. radioSound, radioSound, false);
        self.radioSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.radioSound#volume"),1);
    end;
	
    self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;
	
	self.numFrontlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.frontlights#count"), 0);
    self.frontlights = {};
    for i=1, self.numFrontlights do
        local frontlightnamei = string.format("vehicle.frontlights.frontlight" .. "%d", i);
        self.frontlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, frontlightnamei .. "#index"));
        setVisibility(self.frontlights[i], false);
    end;	
 

	 self.numFarlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.farlights#count"), 0);
    self.farlights = {};
    for i=1, self.numFarlights do
        local farlightnamei = string.format("vehicle.farlights.farlight" .. "%d", i);
        self.farlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, farlightnamei .. "#index"));
        setVisibility(self.farlights[i], false);
    end;	
   
	
	local rotationPartNodebackwindow = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.backwindow#index"));
    if rotationPartNodebackwindow ~= nil then
        self.rotationPartbackwindow = {};
        self.rotationPartbackwindow.node = rotationPartNodebackwindow;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartbackwindow#minRot"));
        self.rotationPartbackwindow.minRot = {};
        self.rotationPartbackwindow.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbackwindow.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbackwindow.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.backwindow#maxRot"));
        self.rotationPartbackwindow.maxRot = {};
        self.rotationPartbackwindow.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbackwindow.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbackwindow.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartbackwindow.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.backwindow#rotTime"), 2)*1000;
        self.rotationPartbackwindow.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.backwindow#touchRotLimit"), 10));
    end;
	local rotationPartNodehubdach = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hubdach#index"));
    if rotationPartNodehubdach ~= nil then
        self.rotationParthubdach = {};
        self.rotationParthubdach.node = rotationPartNodehubdach;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParthubdach#minRot"));
        self.rotationParthubdach.minRot = {};
        self.rotationParthubdach.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthubdach.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthubdach.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hubdach#maxRot"));
        self.rotationParthubdach.maxRot = {};
        self.rotationParthubdach.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthubdach.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthubdach.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationParthubdach.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.hubdach#rotTime"), 2)*1000;
        self.rotationParthubdach.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.hubdach#touchRotLimit"), 10));
    end;

     local rotationPartNoderightdoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rightdoor#index"));
    if rotationPartNoderightdoor ~= nil then
        self.rotationPartrightdoor = {};
        self.rotationPartrightdoor.node = rotationPartNoderightdoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartrightdoor#minRot"));
        self.rotationPartrightdoor.minRot = {};
        self.rotationPartrightdoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightdoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightdoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightdoor#maxRot"));
        self.rotationPartrightdoor.maxRot = {};
        self.rotationPartrightdoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightdoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightdoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartrightdoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightdoor#rotTime"), 2)*1000;
        self.rotationPartrightdoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightdoor#touchRotLimit"), 10));
    end;
	
	 local rotationPartNodeleftDoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.leftDoor#index"));
    if rotationPartNodeleftDoor ~= nil then
        self.rotationPartleftDoor = {};
        self.rotationPartleftDoor.node = rotationPartNodeleftDoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartleftDoor#minRot"));
        self.rotationPartleftDoor.minRot = {};
        self.rotationPartleftDoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftDoor#maxRot"));
        self.rotationPartleftDoor.maxRot = {};
        self.rotationPartleftDoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartleftDoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor#rotTime"), 2)*1000;
        self.rotationPartleftDoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor#touchRotLimit"), 10));
    end;
	local rotationPartNodeteto = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.teto#index"));
    if rotationPartNodeteto ~= nil then
        self.rotationPartteto = {};
        self.rotationPartteto.node = rotationPartNodeteto;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartteto#minRot"));
        self.rotationPartteto.minRot = {};
        self.rotationPartteto.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartteto.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartteto.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.teto#maxRot"));
        self.rotationPartteto.maxRot = {};
        self.rotationPartteto.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartteto.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartteto.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartteto.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.teto#rotTime"), 2)*1000;
        self.rotationPartteto.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.teto#touchRotLimit"), 10));
    end;
	local rotationPartNodeabl1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.abl1#index"));
    if rotationPartNodeabl1 ~= nil then
        self.rotationPartabl1 = {};
        self.rotationPartabl1.node = rotationPartNodeabl1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartabl1#minRot"));
        self.rotationPartabl1.minRot = {};
        self.rotationPartabl1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl1#maxRot"));
        self.rotationPartabl1.maxRot = {};
        self.rotationPartabl1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartabl1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl1#rotTime"), 2)*1000;
        self.rotationPartabl1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl1#touchRotLimit"), 10));
    end;
    local rotationPartNodeabl2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.abl2#index"));
    if rotationPartNodeabl2 ~= nil then
        self.rotationPartabl2 = {};
        self.rotationPartabl2.node = rotationPartNodeabl2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartabl2#minRot"));
        self.rotationPartabl2.minRot = {};
        self.rotationPartabl2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl2#maxRot"));
        self.rotationPartabl2.maxRot = {};
        self.rotationPartabl2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartabl2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl2#rotTime"), 2)*1000;
        self.rotationPartabl2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl2#touchRotLimit"), 10));
    end;
    local rotationPartNodehidra1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hidra1#index"));
    if rotationPartNodehidra1 ~= nil then
        self.rotationParthidra1 = {};
        self.rotationParthidra1.node = rotationPartNodehidra1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParthidra1#minRot"));
        self.rotationParthidra1.minRot = {};
        self.rotationParthidra1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hidra1#maxRot"));
        self.rotationParthidra1.maxRot = {};
        self.rotationParthidra1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationParthidra1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra1#rotTime"), 2)*1000;
        self.rotationParthidra1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra1#touchRotLimit"), 10));
    end;
        local rotationPartNodehidra2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hidra2#index"));
    if rotationPartNodehidra2 ~= nil then
        self.rotationParthidra2 = {};
        self.rotationParthidra2.node = rotationPartNodehidra2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParthidra2#minRot"));
        self.rotationParthidra2.minRot = {};
        self.rotationParthidra2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hidra2#maxRot"));
        self.rotationParthidra2.maxRot = {};
        self.rotationParthidra2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationParthidra2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra2#rotTime"), 2)*1000;
        self.rotationParthidra2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra2#touchRotLimit"), 10));
    end;
      local rotationPartNodehidra3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hidra3#index"));
    if rotationPartNodehidra3 ~= nil then
        self.rotationParthidra3 = {};
        self.rotationParthidra3.node = rotationPartNodehidra3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParthidra3#minRot"));
        self.rotationParthidra3.minRot = {};
        self.rotationParthidra3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hidra3#maxRot"));
        self.rotationParthidra3.maxRot = {};
        self.rotationParthidra3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationParthidra3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra3#rotTime"), 2)*1000;
        self.rotationParthidra3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra3#touchRotLimit"), 10));
    end;
    self.motorStopSoundVolume2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSound#volume"), 1.0);
    hornSoundFile = Utils.getFilename("horn.wav", self.baseDirectory);
    self.hornSoundId = createSample("HupenSound");
    loadSample(self.hornSoundId, hornSoundFile, false);
    
    local motorMaxRpmStr = getXMLString(xmlFile, "vehicle.motor#maxRpm");
    local motorMaxRpm1, motorMaxRpm2, motorMaxRpm3 = Utils.getVectorFromString(motorMaxRpmStr);
    motorMaxRpm1 = Utils.getNoNil(motorMaxRpm1, 400);
    motorMaxRpm2 = Utils.getNoNil(motorMaxRpm2, 1300);
    motorMaxRpm3 = Utils.getNoNil(motorMaxRpm3, 2200);
    local motorMaxRpm = {motorMaxRpm1, motorMaxRpm2, motorMaxRpm3};
    self.motorMaxRpmLimit = motorMaxRpm;
    
	--[[Blinker start]]------------------------------------------------------------	
	turn1SoundFile = Utils.getFilename("turn1.wav", self.baseDirectory);
    self.turn1 = createSample("turn1");
    loadSample(self.turn1, turn1SoundFile, false);
	turn2SoundFile = Utils.getFilename("turn2.wav", self.baseDirectory);
    self.turn2 = createSample("turn2");
    loadSample(self.turn2, turn2SoundFile, false);	
	
    self.numTurnlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights#count"), 0);
    self.turnlights = {};
    for i=1, self.numTurnlights do
        local turnlightnamei = string.format("vehicle.turnlights.turnlight" .. "%d", i);
        self.turnlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei .. "#index"));
        setVisibility(self.turnlights[i], false);
    end;	
	self.turnlightsActive = false;
	
    self.numTurnlights2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights2#count"), 0);
    self.turnlights2 = {};
    for i=1, self.numTurnlights2 do
        local turnlightnamei2 = string.format("vehicle.turnlights2.turnlight" .. "%d", i);
        self.turnlights2[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei2 .. "#index"));
        setVisibility(self.turnlights2[i], false);
    end;	
	self.turnlightsActive2 = false;
--[[Blinker ende]]------------------------------------------------------------	

    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;
	
	self.frontlights.outs = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.frontlights.frontlight#src"));
	
	self.farlightsActive = false;
    self.frontlightsActive = false;
	self.worklightsActive = false;
    self.hornPlaying = false;

    

end;

function Ursus:keyEvent(unicode, sym, modifier, isDown)

    if isDown and sym == self.keys.rundumleuchte then
      self.rundumleuchtenAn = not self.rundumleuchtenAn;
      for i=1, self.rundumleuchtenAnz do
        setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
      end;
    end;
    if isDown and sym == Input.KEY_l then
		self.worklightsActive = not self.worklightsActive;
		self.farlightsActive = false;
		self.frontlightsActive = false;
	end;
    if isDown and sym == Input.KEY_7 then
	    self.frontlightsActive = not self.frontlightsActive;
	    self.farlightsActive = false;
		self.worklightsActive = false;
	end;
	if isDown and sym == Input.KEY_8 then
		self.farlightsActive = not self.farlightsActive;
		self.frontlightsActive = false;
		self.worklightsActive = false;
	end;
    if isDown and sym == Input.KEY_0 then
		self.helpPanel = not self.helpPanel;
	end;
    if isDown and sym == Input.KEY_KP_5 then 
		self.rotationMaxbackwindow = not self.rotationMaxbackwindow;
	end;
	if isDown and sym == Input.KEY_KP_8 then 
		self.rotationMaxhubdach = not self.rotationMaxhubdach;
	end; 
     if isDown and sym == Input.KEY_KP_4 then 
		self.rotationMaxrightdoor = not self.rotationMaxrightdoor;
	end; 
	 if isDown and sym == Input.KEY_KP_6 then 
		self.rotationMaxleftDoor = not self.rotationMaxleftDoor;
	end; 
	if isDown and sym == Input.KEY_z then 
		self.rotationMaxteto = not self.rotationMaxteto;
	end;
	if isDown and sym == Input.KEY_KP_7 then 
		self.rotationMaxabl1 = not self.rotationMaxabl1;
	end;
	if isDown and sym == Input.KEY_KP_9 then 
		self.rotationMaxabl2 = not self.rotationMaxabl2;
	end;
	if isDown and sym == Input.KEY_v then 
		self.rotationMaxhidra1 = not self.rotationMaxhidra1;
	end;
	if isDown and sym == Input.KEY_v then 
		self.rotationMaxhidra2 = not self.rotationMaxhidra2;
	end;
        	if isDown and sym == Input.KEY_KP_0 then 
		self.rotationMaxhidra3 = not self.rotationMaxhidra3;
        end;
	if isDown and sym == Input.KEY_q then 
		self.rotationMaxhidra1 = not self.rotationMaxhidra1;
	end;
	if isDown and sym == Input.KEY_q then 
		self.rotationMaxhidra2 = not self.rotationMaxhidra2;
	end;
	--[[Blinker start]]------------------------------------------------------------	
--[[Blinker Rechts]]-----------------------------------------------------------
	if isDown and sym == Input.KEY_KP_3 then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashlightsRightActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsRight2Active = false;
		self.turnlightsActive2 = false;
		self.flashWarner = false;
	end;
--[[Warnblinker]]------------------------------------------------------------	
	if isDown and sym == Input.KEY_KP_2 then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
		self.flashWarner = not self.flashWarner;
	end;
--[[Blinker Links]]-----------------------------------------------------------
	if isDown and sym == Input.KEY_KP_1 then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashlightsLeftActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsLeft2Active = false;
		self.turnlightsActive = false;
		self.flashWarner = false;
	end;	
--[[Blinker ende]]------------------------------------------------------------

end;


function Ursus:update(dt)
    if self.isEntered then
	
	    if self.rotationPartbackwindow ~= nil then
		   local x, y, z = getRotation(self.rotationPartbackwindow.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbackwindow.maxRot, self.rotationPartbackwindow.minRot, 3, self.rotationPartbackwindow.rotTime, dt, not self.rotationMaxbackwindow);
		   setRotation(self.rotationPartbackwindow.node, unpack(newRot));
        end;
		
		if self.rotationParthubdach ~= nil then
		   local x, y, z = getRotation(self.rotationParthubdach.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationParthubdach.maxRot, self.rotationParthubdach.minRot, 3, self.rotationParthubdach.rotTime, dt, not self.rotationMaxhubdach);
		   setRotation(self.rotationParthubdach.node, unpack(newRot));
        end;

        if self.rotationPartleftDoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartleftDoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartleftDoor.maxRot, self.rotationPartleftDoor.minRot, 3, self.rotationPartleftDoor.rotTime, dt, not self.rotationMaxleftDoor);
		   setRotation(self.rotationPartleftDoor.node, unpack(newRot));
        end;
    
       if self.rotationPartteto ~= nil then
		   local x, y, z = getRotation(self.rotationPartteto.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartteto.maxRot, self.rotationPartteto.minRot, 3, self.rotationPartteto.rotTime, dt, not self.rotationMaxteto);
		   setRotation(self.rotationPartteto.node, unpack(newRot));
        end;
        
	    if self.rotationPartrightdoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartrightdoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartrightdoor.maxRot, self.rotationPartrightdoor.minRot, 3, self.rotationPartrightdoor.rotTime, dt, not self.rotationMaxrightdoor);
		   setRotation(self.rotationPartrightdoor.node, unpack(newRot));
        end;
		if self.rotationPartabl1 ~= nil then
		   local x, y, z = getRotation(self.rotationPartabl1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartabl1.maxRot, self.rotationPartabl1.minRot, 3, self.rotationPartabl1.rotTime, dt, not self.rotationMaxabl1);
		   setRotation(self.rotationPartabl1.node, unpack(newRot));
        end;
        if self.rotationPartabl2 ~= nil then
		   local x, y, z = getRotation(self.rotationPartabl2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartabl2.maxRot, self.rotationPartabl2.minRot, 3, self.rotationPartabl2.rotTime, dt, not self.rotationMaxabl2);
		   setRotation(self.rotationPartabl2.node, unpack(newRot));
        end;
        if self.rotationParthidra1 ~= nil then
		   local x, y, z = getRotation(self.rotationParthidra1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationParthidra1.maxRot, self.rotationParthidra1.minRot, 3, self.rotationParthidra1.rotTime, dt, not self.rotationMaxhidra1);
		   setRotation(self.rotationParthidra1.node, unpack(newRot));
        end;
        if self.rotationParthidra2 ~= nil then
		   local x, y, z = getRotation(self.rotationParthidra2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationParthidra2.maxRot, self.rotationParthidra2.minRot, 3, self.rotationParthidra2.rotTime, dt, not self.rotationMaxhidra2);
		   setRotation(self.rotationParthidra2.node, unpack(newRot));
        end;
        if self.rotationParthidra3 ~= nil then
		   local x, y, z = getRotation(self.rotationParthidra3.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationParthidra3.maxRot, self.rotationParthidra3.minRot, 3, self.rotationParthidra3.rotTime, dt, not self.rotationMaxhidra3);
		   setRotation(self.rotationParthidra3.node, unpack(newRot));
        end;
	
	
	    if self.isEntered then
        if self.worklightsActive then
		   for i=1, self.numWorklights do
		   local worklight = self.worklights[i];
		   setVisibility(worklight, self.worklightsActive);
		end;
	else
		for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive, false);
		end;
	end;
	end;
	    
		if self.isEntered then
		  if self.frontlightsActive then
		   for i=1, self.numFrontlights do
		   local frontlight = self.frontlights[i];
		   setVisibility(frontlight, self.frontlightsActive);
		end;
	else
		for i=1, self.numFrontlights do
			local frontlight = self.frontlights[i];
			setVisibility(frontlight, self.frontlightsActive, false);
			setVisibility(self.frontlights.outs, true);
		end;
	end;
	end;
	end;
	
		if self.isEntered then
        if self.farlightsActive then
		   for i=1, self.numFarlights do
		   local farlight = self.farlights[i];
		   setVisibility(farlight, self.farlightsActive);
		end;
	else 
	    if not self.farlightsActive then
		for i=1, self.numFarlights do
			local farlight = self.farlights[i];
			setVisibility(farlight, self.farlightsActive, false);
		end;
	end;
 end;
 
        if self.isEntered then
          if self.frontlightsActive then
            setVisibility(self.frontlights.outs, false);
          else
            setVisibility(self.frontlights.outs, true);
          end;
        end;
		
         if self:getIsActiveForInput() and self:getIsActiveForSound() and InputBinding.hasEvent(InputBinding.RADIO) then
             if not self.radioSoundPlaying then 
               playSample(self. radioSound, 0, self. radioSoundVolume, 0); 
               self.radioSoundPlaying = true; 
           else 
                stopSample(self. radioSound); 
                self.radioSoundPlaying = false; 
             end;  
          end;

        inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);

        if InputBinding.isAxisZero(inputAxisY) then
        inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
        end;
			
		if self.isEntered ~= nil then
		if self.brakelightsActive then
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive);
			end;
		else
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive, false);
			end;
		end;
		if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then		
			self.brakelightsActive = true;
			self.braking = true;
		else
			self.brakelightsActive = false;
			self.braking = false;
		end;
    end;
		  
		if self:getIsActiveForInput() and self:getIsActiveForSound() and InputBinding.isPressed(InputBinding.HUPE) then
        if not self.hornPlaying then
            playSample(self.hornSoundId, 0, 1, 0);
            self.hornPlaying = true;
        end;
    else
        if self.hornPlaying then
            stopSample(self.hornSoundId);
            self.hornPlaying = false;
        end;
    end;

        if self.rundumleuchtenAn then
          for i=1, self.rundumleuchtenAnz do
            rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
          end;
        end;
        
		if g_currentMission.environment ~= nil and g_currentMission.environment.dayNightCycle and
              (g_currentMission.environment.dayTime > (20.5*1000*60*60) or g_currentMission.environment.dayTime < (5.5*1000*60*60)) and
              not self.lightsActive and self.isHired and not self.steeringEnabled then
		self.lightsActive = true;
	end;

	if not self.isHired and self.lightsActive and not self.isEntered or not g_currentMission.environment.dayNightCycle then
		self.lightsActive = false;
	end;


    for k, light in pairs(self.lights) do
        setVisibility(light, self.lightsActive);
    end; 
    
 

end;
    if self.isMotorStarted and self:getIsActiveForInput() and self.isEntered then
	
	    if self.motor.speedLevel ~= 0 then
			
            if InputBinding.isPressed(InputBinding.ACCELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] + 10;
			    end;
		    elseif InputBinding.isPressed(InputBinding.DECELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] >= 10 then
			        self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] - 10;
			    end;
	    	end;
				
		else
			
            if InputBinding.isPressed(InputBinding.ACCELERATE) then
		        if self.motor.maxRpm[3] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[3] = self.motor.maxRpm[3] + 10;
			    end;
		    elseif InputBinding.isPressed(InputBinding.DECELERATE) then
		        if self.motor.maxRpm[3] >= 10 then
			            self.motor.maxRpm[3] = self.motor.maxRpm[3] - 10;
			    end;
	    	end;
		end;
	end;
	
	
--[[Blinker start]]------------------------------------------------------------
	    if self.flash then
		    if self.delayOn >= 0 then
			    self.delayOn = self.delayOn -dt;
		    end;
		    if not self.flashlightsRightActive then
			    if self.delayOn < 0 then
				    self.delayOff = 500;
				    self.flashlightsRightActive = true;
				    self.flashlightsLeftActive = true;
			    	self.flashlightsWarnerActive = true;
				    self.turnlightsActive2 = true;
			    	self.turnlightsActive = true;
				    playSample(self.turn1, 1, 0.7, 0);
			    end;
		    end;
		if self.delayOff >= 0 then
			self.delayOff = self.delayOff -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOff < 0 then
				self.delayOn = 500;
				self.flashlightsLeftActive = false;
				self.flashlightsRightActive = false;
				self.flashlightsWarnerActive = false;
				self.turnlightsActive2 = false;
				self.turnlightsActive = false;
				playSample(self.turn2, 1, 0.7, 0);
			end;
		end;
	  end;

	    if self.flashRight then
		    if self.delayOnRight >= 0 then
			    self.delayOnRight = self.delayOnRight -dt;
		    end;
		    if not self.flashlightsRightActive then
			    if self.delayOnRight < 0 then
				    self.delayOffRight = 500;
				    self.flashlightsRightActive = true;
				    self.turnlightsActive2 = true;
				    playSample(self.turn1,1,0.7,0);
			    end;
		    end;
		    if self.delayOffRight >= 0 then
			   self.delayOffRight = self.delayOffRight -dt;
		    end;
		    if self.flashlightsRightActive then
			    if self.delayOffRight < 0 then
				    self.delayOnRight = 500;
				    self.flashlightsRightActive = false;
				    self.turnlightsActive2 = false;
				    playSample(self.turn2,1,0.7,0);
			    end;
		    end;
	    else
		    if not self.flashWarner then
			    self.turnlightsActive2 = false;
		    end;
	    end;

		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashlightsLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashlightsLeftActive = true;
					self.turnlightsActive = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashlightsLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashlightsLeftActive = false;
					self.turnlightsActive = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.turnlightsActive = false;
			end;
		end;

		if self.turnlightsActive then
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive);
			end;
		else
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive, false);
			end;
		end;
    	if self.turnlightsActive2 then
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2);
			end;
		else
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2, false);
			end;
		end;
	
--[[Blinker ende]]------------------------------------------------------------

end;

function Ursus:draw()

    if self.isEntered then
		if not self.helpPanel then
			renderText(0.8335, 0.25, 0.02, "Wcisnij 0: Info Ursus");
		else
			renderText(0.8335, 0.25, 0.02, "Wcisnij 0: Info Ursus");
		end;
		if self.helpPanel then
			renderText(0.72, 0.84, 0.025, "- Ursus 1004 by SS1004  -");
			renderText(0.72, 0.815, 0.02, "kliknij 5: zapal ciagnik");
                                                      renderText(0.72, 0.8, 0.02, "kliknij KP5: szyba");			
			renderText(0.72, 0.785, 0.02, "kliknij KP4: prawe  drzwi");
			renderText(0.72, 0.77, 0.02, "kliknij KP6: lewe drzwi");
			renderText(0.72, 0.755, 0.02, "kliknij KP8: dach");
			renderText(0.72, 0.74, 0.02, "kliknij KP1 - kier. lewy");
			renderText(0.72, 0.725, 0.02, "kliknij KP2 - awaryjne");
			renderText(0.72, 0.71, 0.02, "kliknij KP3 - kier. prawy");
			renderText(0.72, 0.695, 0.02, "kliknij 8 - swiatla robocze przod i tyl");
                                                      renderText(0.72, 0.68, 0.02, "kliknij 9: wlacz przedni naped");
                                                      renderText(0.72, 0.665, 0.02, "kliknij L: swiatla robocze tyl");

		end;
	end;
	
    if not self.isMotorStarted and not self.automaticStart then	

	end;
	if self.isMotorStarted then	
        if self.motor.speedLevel ~= 0 then
            g_currentMission:addExtraPrintText("Taste NUM +/-:   "..string.format("%d RPM",self.motor.maxRpm[self.motor.speedLevel]).."");
	    else
            g_currentMission:addExtraPrintText("Taste NUM +/-:   "..string.format("%d RPM",self.motor.maxRpm[3]).."");
	    end;
	end;
end;

function Ursus:onEnter()
    Utils.setEmittingState(self.exhaustParticleLow, false);
end;

function Ursus:onLeave()
    self.rundumleuchtenAn = false;
    for i=1, self.rundumleuchtenAnz do
       setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
    end;
    self.worklightsActive = false;
	
	if self.radioSound ~= nil then
        stopSample(self.radioSound);
    end;
	

end;

function Ursus:delete()
    delete(self.hornSoundId);
	delete(self.radioSound);
   
end;


function Ursus:mouseEvent(posX, posY, isDown, isUp, button)
end;

function key_convert(key)
    if key ~= nil then 
	    local keyname = "";
	    if key > 32 and key < 123 then
	    	keyname = string.upper(string.char(key));
	    elseif key > 255 and key < 266 then
	    	keyname = "NUM "..string.char(key-208);
	    else 
	    	keyname = "";
	    end;
	    return(keyname);
	  end;
end;
