SetPickupStateEvent = {};
SetPickupStateEvent_mt = Class(SetPickupStateEvent, Event);

InitEventClass(SetPickupStateEvent, "SetPickupStateEvent");

function SetPickupStateEvent:emptyNew()
    local self = Event:new(SetPickupStateEvent_mt);
    self.className="SetPickupStateEvent";
    return self;
end;

function SetPickupStateEvent:new(vehicle, pickupState)
    local self = SetPickupStateEvent:emptyNew()
    self.vehicle = vehicle;
	self.pickupState = pickupState;
    return self;
end;

function SetPickupStateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.pickupState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetPickupStateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.pickupState);
end;

function SetPickupStateEvent:run(connection)   
	self.vehicle:setPickup(self.pickupState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetPickupStateEvent:new(self.vehicle, self.pickupState), nil, connection, self.vehicle);
    end;
end;

function SetPickupStateEvent.sendEvent(vehicle, pickupState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetPickupStateEvent:new(vehicle, pickupState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetPickupStateEvent:new(vehicle, pickupState));
		end;
	end;
end;