--[[
XML
	<wheelAreas count="4">
       <wheelArea1 pointIndex="0|2" width="0.15" height="0.25"/>
       <wheelArea2 pointIndex="1|2" width="0.15" height="0.25"/>
       <wheelArea3 pointIndex="2|0" width="0.15" height="0.25"/>
       <wheelArea4 pointIndex="3|0" width="0.15" height="0.25"/>
    </wheelAreas> 
]]--



wheelextra = {};

function wheelextra.prerequisitesPresent(specializations)
    return true;
end;

function wheelextra:load(xmlFile)

	self.on = true;

	local numWheelAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.wheelAreas#count"), 0);
    self.wheelAreas = {}
    for i=1, numWheelAreas do
        self.wheelAreas[i] = {4};
        local areanamei = string.format("vehicle.wheelAreas.wheelArea%d", i);
        self.wheelAreas[i].point = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#pointIndex"));
        self.wheelAreas[i].width = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#width"), 0.5)
        self.wheelAreas[i].height = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#height"), 0.25)
    end;
	
end;

function wheelextra:delete()
end;

function wheelextra:mouseEvent(posX, posY, isDown, isUp, button)
end;

function wheelextra:keyEvent(unicode, sym, modifier, isDown)
end;

function wheelextra:update(dt)

if self.on then
	for k, wheelArea in pairs(self.wheelAreas) do
        local x,y,z = getWorldTranslation(wheelArea.point);
        local w = wheelArea.width;
        local h = wheelArea.height;
		local x1 = x + h/2
		local x2 = x - h/2
		local z1 = z + w/2
		local z2 = z - w/2
		
		
		Utils.cutFruitArea( 1, x1, z2, x1, z1, x2, z2);
		Utils.cutFruitArea( 2, x1, z2, x1, z1, x2, z2);
		Utils.cutFruitArea( 3, x1, z2, x1, z1, x2, z2);
		Utils.cutFruitArea( 4, x1, z2, x1, z1, x2, z2);
		Utils.cutFruitArea( 9, x1, z2, x1, z1, x2, z2);
		Utils.updateMeadowArea(x1, z2, x1, z1, x2, z2);
		Utils.updateCuttedMeadowArea(x1, z2, x1, z1, x2, z2);
	end;
end;

end;

function wheelextra:draw()
end;

