manualStart_MP = {};
function manualStart_MP.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;
function manualStart_MP:load(xmlFile)
-- Configure New Functions
	self.ignitionState = SpecializationUtil.callSpecializationsFunction("ignitionState");
-- Configure Outside Engine Start Sound
	local engineStartSound3d  = getXMLString(xmlFile, "vehicle.engineStartSound3d#file");
	if engineStartSound3d  ~= nil and engineStartSound3d  ~= "" then
		engineStartSound3d  = Utils.getFilename(engineStartSound3d, self.baseDirectory);
		self.engineStartSound3dRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineStartSound3d#radius"), 35);
		self.engineStartSound3dInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineStartSound3d#innerRadius"), 10);
		self.engineStartSound3dVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineStartSound3d#volume"), 1);
		self.engineStartSound3d = createAudioSource("engineStartSound3d", engineStartSound3d, self.engineStartSound3dRadius, self.engineStartSound3dInnerRadius, self.engineStartSound3dVolume, 1);
		link(self.components[1].node, self.engineStartSound3d);
	end;
	setVisibility(self.engineStartSound3d, false);
-- Configure Outside Engine Stop Sound
	local engineStopSound3d  = getXMLString(xmlFile, "vehicle.engineStopSound3d#file");
	if engineStopSound3d  ~= nil and engineStopSound3d  ~= "" then
		engineStopSound3d  = Utils.getFilename(engineStopSound3d, self.baseDirectory);
		self.engineStopSound3dRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineStopSound3d#radius"), 35);
		self.engineStopSound3dInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineStopSound3d#innerRadius"), 10);
		self.engineStopSound3dVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineStopSound3d#volume"), 1);
		self.engineStopSound3d = createAudioSource("engineStopSound3d", engineStopSound3d, self.engineStopSound3dRadius, self.engineStopSound3dInnerRadius, self.engineStopSound3dVolume, 1);
		link(self.components[1].node, self.engineStopSound3d);
	end;
	setVisibility(self.engineStopSound3d, false);
-- Configure Outside Engine Running Sound
	local engineRunningSound3d  = getXMLString(xmlFile, "vehicle.aiMotorSound#file");
	if engineRunningSound3d  ~= nil and engineRunningSound3d  ~= "" then
		engineRunningSound3d  = Utils.getFilename(engineRunningSound3d, self.baseDirectory);
		self.engineRunningSound3dRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.aiMotorSound#radius"), 35);
		self.engineRunningSound3dInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.aiMotorSound#innerRadius"), 10);
		self.engineRunningSound3dVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.aiMotorSound#volume"), 1);
		self.engineRunningSound3d = createAudioSource("aiMotorSound", engineRunningSound3d, self.engineRunningSound3dRadius, self.engineRunningSound3dInnerRadius, self.engineRunningSound3dVolume, 0);
		link(self.components[1].node, self.engineRunningSound3d);
	end;
	setVisibility(self.engineBrakeSound3d, false);
-- Configure Outside Engine Brake Sound
	local engineBrakeSound3d  = getXMLString(xmlFile, "vehicle.engineBrakeSound3d#file");
	if engineBrakeSound3d  ~= nil and engineBrakeSound3d  ~= "" then
		engineBrakeSound3d  = Utils.getFilename(engineBrakeSound3d, self.baseDirectory);
		self.engineBrakeSound3dRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineBrakeSound3d#radius"), 35);
		self.engineBrakeSound3dInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineBrakeSound3d#innerRadius"), 10);
		self.engineBrakeSound3dVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineBrakeSound3d#volume"), 1);
		self.engineBrakeSound3d = createAudioSource("engineBrakeSound3d", engineBrakeSound3d, self.engineBrakeSound3dRadius, self.engineBrakeSound3dInnerRadius, self.engineBrakeSound3dVolume, 0);
		link(self.components[1].node, self.engineBrakeSound3d);
	end;
	setVisibility(self.engineBrakeSound3d, false);
-- Configure Inside Engine Start Sound
	local engineStartSound = getXMLString(xmlFile, "vehicle.engineStartSound#file");
	if engineStartSound ~= nil and engineStartSound ~= "" then
		engineStartSound = Utils.getFilename(engineStartSound, self.baseDirectory);
		self.engineStartSound = createSample("engineStartSound");
		loadSample(self.engineStartSound, engineStartSound, false);
		self.engineStartSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineStartSound#pitchOffset"), 0);
		self.engineStartSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineStartSound#volume"), 1.0);
		self.engineStartSoundDuration = getSampleDuration(self.engineStartSound);
	end;
-- Configure Inside Engine Stop Sound
	local engineStopSound = getXMLString(xmlFile, "vehicle.engineStopSound#file");
	if engineStopSound ~= nil and engineStopSound ~= "" then
		engineStopSound = Utils.getFilename(engineStopSound, self.baseDirectory);
		self.engineStopSound = createSample("engineStopSound");
		loadSample(self.engineStopSound, engineStopSound, false);
		self.engineStopSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineStopSound#pitchOffset"), 0);
		self.engineStopSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineStopSound#volume"), 1.0);
		self.engineStopSoundDuration = getSampleDuration(self.engineStopSound);
	end;
-- Configure Inside Engine Brake Sound
	local engineBrakeSound = getXMLString(xmlFile, "vehicle.engineBrakeSound#file");
	if engineBrakeSound ~= nil and engineBrakeSound ~= "" then
		engineBrakeSound = Utils.getFilename(engineBrakeSound, self.baseDirectory);
		self.engineBrakeSound = createSample("engineBrakeSound");
		loadSample(self.engineBrakeSound, engineBrakeSound, false);
		self.engineBrakeSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineBrakeSound#pitchOffset"), 0);
		self.engineBrakeSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineBrakeSound#pitchScale"), 0.05);
		self.engineBrakeSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineBrakeSound#pitchMax"), 2.0);
		self.engineBrakeSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineBrakeSound#volume"), 10.0);
		self.engineBrakeSoundEnabled = false;
	end;
-- Configure Inside Engine Turbo Sound
	local engineTurboSound = getXMLString(xmlFile, "vehicle.engineTurboSound#file");
	if engineTurboSound ~= nil and engineTurboSound ~= "" then
		engineTurboSound = Utils.getFilename(engineTurboSound, self.baseDirectory);
		self.engineTurboSound = createSample("engineTurboSound");
		loadSample(self.engineTurboSound, engineTurboSound, false);
		self.engineTurboSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineTurboSound#pitchOffset"), 1); --1
		self.engineTurboSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineTurboSound#pitchScale"), 0.01); --0.01
		self.engineTurboSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineTurboSound#pitchMax"), 2.0); --2.0
		self.engineTurboSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineTurboSound#volume"), 0.005); --0.025
		self.engineTurboSoundVolumeOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineTurboSound#volumeOffset"), 0.005); --1
		self.engineTurboSoundVolumeScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineTurboSound#volumeScale"), 0.001); --0.01
		self.engineTurboSoundVolumeMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.engineTurboSound#volumeMax"), 0.050); --2.0
		self.engineTurboSoundEnabled = false;
	end;
-- Configure Variables
	self.ignitionKey = false;
	self.allowIgnition = true;
	self.engineBrake = false;
end;
function manualStart_MP:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IGNITIONKEY) then
			self.ignitionKey = not self.ignitionKey
			self:ignitionState(self.ignitionKey, self.allowIgnition);
		end;
		if InputBinding.hasEvent(InputBinding.ENGINEBRAKE) then
			self.engineBrake = not self.engineBrake
			--self:engineBrakeState(self.engineBrake, self.engineBrakeSoundEnabled);
		end;
	end;
	if self.ignitionKey then
		self:startMotor(true);
		self.isMotorStarted = true;
		self.steeringEnabled = true;
		if self.isEntered and self.allowIgnition then
			playSample(self.engineStartSound, 1, self.engineStartSoundVolume, 0);
			setSamplePitch(self.engineStartSound, self.engineStartSoundPitchOffset);
		elseif self.allowIgnition then
			setVisibility(self.engineStartSound3d, true);
		end;
		setVisibility(self.engineRunningSound3d, true);
		setVisibility(self.engineStopSound3d, false);
		self.allowIgnition = false;
		if self.isEntered and self.isMotorStarted then
			playSample(self.engineTurboSound, 0, self.turboSoundVolume, 0);
		else
			stopSample(self.engineTurboSound);
		end;
	else
		self.lastAcceleration = 0;
		if self.isServer then
			for k,wheel in pairs(self.wheels) do
				setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
			end;
		end;
		self:stopMotor(true);
		self.isMotorStarted = false;
		self.steeringEnabled = false;
		setVisibility(self.engineStartSound3d, false);
		setVisibility(self.engineRunningSound3d, false);
		stopSample(self.engineTurboSound);
		if self.isEntered and not self.allowIgnition then
			playSample(self.engineStopSound, 1, self.engineStopSoundVolume, 0);
			setSamplePitch(self.engineStopSound, self.engineStopSoundPitchOffset);
		elseif not self.allowIgnition then
			setVisibility(self.engineStopSound3d, true);
		end;
		self.allowIgnition = true;
	end;
-- Set engineTurboSound pitch based on Engine RPM
	local alpha = 0.9;
	local roundPerMinute = self.lastRoundPerMinute*alpha + (1-alpha)*(self.motor.lastMotorRpm-self.motor.minRpm);
	self.lastRoundPerMinute = roundPerMinute;
	local roundPerSecond = roundPerMinute / 60;
	if self.engineTurboSound ~= nil then
		setSampleVolume(self.engineTurboSound, math.min(self.engineTurboSoundVolumeOffset + self.engineTurboSoundVolumeScale*math.abs(roundPerSecond), self.engineTurboSoundVolumeMax));
		setSamplePitch(self.engineTurboSound, math.min(self.engineTurboSoundPitchOffset + self.engineTurboSoundPitchScale*math.abs(roundPerSecond), self.engineTurboSoundPitchMax));
	end;
-- Engine Brake
	if self.engineBrake then
	self.motor.brakeForce = 15;
	-- Set engineBrakeSound pitch based on Engine RPM
		local alpha = 0.9; --0.9
		local roundPerMinute = self.lastRoundPerMinute*alpha + (1-alpha)*(self.motor.lastMotorRpm-self.motor.minRpm);
		self.lastRoundPerMinute = roundPerMinute;
		local roundPerSecond = roundPerMinute / 60;
		if self.engineBrakeSound ~= nil then
			--setSamplePitch(self.engineBrakeSound, math.min(self.engineBrakeSoundPitchOffset + self.engineBrakeSoundPitchScale*math.abs(roundPerSecond), self.engineBrakeSoundPitchMax));
			setSampleVolume(self.engineBrakeSound, math.min(0.5 + 0.1*math.abs(roundPerSecond), 10));
		end;
	--
		local input = 0;
		if self.axisForward ~= nil then
			input = self.axisForward;
		end;
		if self.engineBrakeSound ~= nil then
			local maxRpm = self.motor:getMaxRpm();
			local enoughRpm = false;
			if self.motor.lastMotorRpm > (maxRpm/2.5) then --2
				enoughRpm = true;
			end;
			if self.engineBrakeSoundEnabled and input == -1 then
				stopSample(self.engineBrakeSound)
				self.engineBrakeSoundEnabled = false;
			end;
			if input == -1 and enoughRpm then
				-- if we drive fast enough, we need to run the exhaustbrake the next time we release the throttle
				self.engineBrakeSoundEnabled = false;
			end;
			if input == 0 and not self.engineBrakeSoundEnabled and enoughRpm then
				-- play the exhaustbrake sound if we drive fast enough and release throttle
				if self:getIsActiveForSound() then
					playSample(self.engineBrakeSound, 1, self.engineBrakeSoundVolume, 0);
				end;
				self.engineBrakeSoundEnabled = true;
			end;
		end;
	else
		self.motor.brakeForce = 30;
	end;
end;
function manualStart_MP:draw()
	if self.engineBrake then
		g_currentMission:addHelpButtonText(g_i18n:getText("ENGINEBRAKE_ON"),InputBinding.ENGINEBRAKE);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("ENGINEBRAKE_OFF"),InputBinding.ENGINEBRAKE);
	end;
end;
function manualStart_MP:onEnter()
	if not self.ignitionKey then
		self.isMotorStarted = false;
		self.steeringEnabled = false;
		Utils.setEmittingState(self.exhaustParticleSystems, false)
	end;
end;
function manualStart_MP:ignitionState(ignitionKey, allowIgnition, noEventSend)
	manualStart_MPEvent.sendEvent(self, ignitionKey, allowIgnition, noEventSend);
	if ignitionKey then
		self.ignitionKey = true;
	else
		self.ignitionKey = false;
	end;
	if allowIgnition then
		self.allowIgnition = true;
	else
		self.allowIgnition = false;
	end;
end;
function manualStart_MP:onLeave()
end;
function manualStart_MP:delete()
	if self.engineBrakeSoundEnabled then
		stopSample(self.engineBrakeSound);
	end;
	if self.ignitionKey then
		stopSample(self.engineTurboSound);
	end;

end;
function manualStart_MP:readStream(streamId, connection)
print("Hit on readStream");
	self.ignitionKey = streamReadBool(streamId);
	self.allowIgnition = streamReadBool(streamId);
	self.engineBrakeSoundEnabled = streamReadBool(streamId);
end;
function manualStart_MP:writeStream(streamId, connection)
print("Hit on writeStream");
	streamWriteBool(streamId, self.ignitionKey);
	streamWriteBool(streamId, self.allowIgnition);
	streamWriteBool(streamId, self.engineBrakeSoundEnabled);
end;

function manualStart_MP:mouseEvent(posX, posY, isDown, isUp, button)
end;
function manualStart_MP:keyEvent(unicode, sym, modifier, isDown)
end;

manualStart_MPEvent = {};
manualStart_MPEvent_mt = Class(manualStart_MPEvent, Event);
InitEventClass(manualStart_MPEvent, "manualStart_MPEvent");
function manualStart_MPEvent:emptyNew()
    local self = Event:new(manualStart_MPEvent_mt);
    self.className="manualStart_MPEvent";
    return self;
end;
function manualStart_MPEvent:new(vehicle, ignitionKey, allowIgnition)
    local self = manualStart_MPEvent:emptyNew()
    self.vehicle = vehicle;
	self.ignitionKey = ignitionKey;
	self.allowIgnition = allowIgnition;
    return self;
end;
function manualStart_MPEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.ignitionKey = streamReadBool(streamId);
	self.allowIgnition = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;
function manualStart_MPEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.ignitionKey);
	streamWriteBool(streamId, self.allowIgnition);
end;
function manualStart_MPEvent:run(connection)
	self.vehicle:ignitionState(self.ignitionKey, self.allowIgnition, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(manualStart_MPEvent:new(self.vehicle, self.ignitionKey, self.allowIgnition), nil, connection, self.vehicle);
    end;
end;
function manualStart_MPEvent.sendEvent(vehicle, ignitionKey, allowIgnition, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(manualStart_MPEvent:new(vehicle, ignitionKey, allowIgnition), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(manualStart_MPEvent:new(vehicle, ignitionKey, allowIgnition, isMotorStarted));
		end;
	end;
end;