manualIgnition5830StatsEvent = {};
manualIgnition5830StatsEvent_mt = Class(manualIgnition5830StatsEvent, Event);

InitEventClass(manualIgnition5830StatsEvent, "manualIgnition5830StatsEvent");

function manualIgnition5830StatsEvent:emptyNew()
    local self = Event:new(manualIgnition5830StatsEvent_mt);
    self.className="manualIgnition5830StatsEvent";
    return self;
end;

function manualIgnition5830StatsEvent:new(vehicle)
    local self = manualIgnition5830StatsEvent:emptyNew()
    self.vehicle = vehicle;
    return self;
end;

function manualIgnition5830StatsEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
	self.vehicle.fuelConsumption = streamReadFloat32(streamId);
	self.vehicle.distanceDriven = streamReadFloat32(streamId);
	self.vehicle.fuelUsed = streamReadFloat32(streamId);
	self.vehicle.runningTime = streamReadFloat32(streamId);
	if not connection:getIsServer() then
		g_server:broadcastEvent(manualIgnition5830StatsEvent:new(self.vehicle), nil, connection, self.vehicle);
	end;
end;

function manualIgnition5830StatsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteFloat32(streamId, self.vehicle.fuelConsumption);
	streamWriteFloat32(streamId, self.vehicle.distanceDriven);
	streamWriteFloat32(streamId, self.vehicle.fuelUsed);
	streamWriteFloat32(streamId, self.vehicle.runningTime);
end;

function manualIgnition5830StatsEvent.sendEvent(vehicle, isTransport)
	if g_server ~= nil then
		g_server:broadcastEvent(manualIgnition5830StatsEvent:new(vehicle), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(manualIgnition5830StatsEvent:new(vehicle));
	end;
end;

