SetDoorLeftRotationEvent = {};
SetDoorLeftRotationEvent_mt = Class(SetDoorLeftRotationEvent, Event);
  
InitEventClass(SetDoorLeftRotationEvent, "SetDoorLeftRotationEvent");
  
function SetDoorLeftRotationEvent:emptyNew()
      local self = Event:new(SetDoorLeftRotationEvent_mt);
      self.className="SetDoorLeftRotationEvent";
      return self;
 end;

function SetDoorLeftRotationEvent:new(object, rotationMax12)
      local self = SetDoorLeftRotationEvent:emptyNew()
      self.object = object;
      self.rotationMax12 = rotationMax12;
      return self;
end;
 
function SetDoorLeftRotationEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.rotationMax12 = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetDoorLeftRotationEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.rotationMax12);
end;
 
function SetDoorLeftRotationEvent:run(connection)
      self.object:setRotationMax12(self.rotationMax12, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetDoorLeftRotationEvent:new(self.object, self.rotationMax12), nil, connection, self.object);
      end;
end;