--
-- Henly20 (Ls_uk Modteam)
-- 23.08.2010
--
-- > www.LS-UK.info

Doors2 = {};

function Doors2.prerequisitesPresent(specializations)

    return true;
end;

function Doors2:load(xmlFile)
     self.setRotationMax12 = SpecializationUtil.callSpecializationsFunction("setRotationMax12");
     self.setRotationMax13 = SpecializationUtil.callSpecializationsFunction("setRotationMax13");
	 
	
	local rotationPartNode12 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart12#index"));
    if rotationPartNode12 ~= nil then
        self.rotationPart12 = {};
        self.rotationPart12.node = rotationPartNode12;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart12#minRot"));
        self.rotationPart12.minRot = {};
        self.rotationPart12.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart12.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart12.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart12#maxRot"));
        self.rotationPart12.maxRot = {};
        self.rotationPart12.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart12.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart12.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart12.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart12#rotTime"), 2)*1000;
        self.rotationPart12.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart12#touchRotLimit"), 10));
    end;
	local rotationPartNode13 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart13#index"));
    if rotationPartNode13 ~= nil then
        self.rotationPart13 = {};
        self.rotationPart13.node = rotationPartNode13;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart13#minRot"));
        self.rotationPart13.minRot = {};
        self.rotationPart13.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart13.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart13.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart13#maxRot"));
        self.rotationPart13.maxRot = {};
        self.rotationPart13.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart13.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart13.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart13.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart13#rotTime"), 2)*1000;
        self.rotationPart13.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart13#touchRotLimit"), 10));
    end;

		self.rotationMax12 = false;
		self.rotationMax13 = false;
end;

function Doors2:readStream(streamId, connection)
     self.rotateMax = streamReadBool(streamId);
     if self.rotationPart12 ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
         setRotation(self.rotationPart12.node, x, y, z);
      end;
     if self.rotationPart13 ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
         setRotation(self.rotationPart13.node, x, y, z);
      end;
end;
  
function Doors2:writeStream(streamId, connection)
      streamWriteBool(streamId, self.rotateMax);
		if self.rotationPart12 ~= nil then
          local x, y, z = getRotation(self.rotationPart12.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
		if self.rotationPart13 ~= nil then
          local x, y, z = getRotation(self.rotationPart13.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
end;

function Doors2:delete()

end;

function Doors2:keyEvent(unicode, sym, modifier, isDown)


end;

function Doors2:update(dt)
      if self:getIsActiveForInput() then
          if InputBinding.hasEvent(InputBinding.DOORLEFT2) then
				self:setRotationMax12(not self.rotationMax12);
          end;
          if InputBinding.hasEvent(InputBinding.DOORRIGHT2) then
				self:setRotationMax13(not self.rotationMax13);
          end;
		  
     end;
end;

function Doors2:updateTick(dt)
	if self:getIsActive() and self.isClient then
			if self.rotationPart12 ~= nil then
				local x, y, z = getRotation(self.rotationPart12.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart12.maxRot, self.rotationPart12.minRot, 3, self.rotationPart12.rotTime, dt, not self.rotationMax12);
				setRotation(self.rotationPart12.node, unpack(newRot));
			end;
			if self.rotationPart13 ~= nil then
				local x, y, z = getRotation(self.rotationPart13.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart13.maxRot, self.rotationPart13.minRot, 3, self.rotationPart13.rotTime, dt, not self.rotationMax13);
				setRotation(self.rotationPart13.node, unpack(newRot));
			end;
		
	end;		
end;

function Doors2:draw()

g_currentMission:addExtraPrintText(g_i18n:getText("arcone"));
  
end;


function Doors2:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Doors2:setRotationMax12(rotationMax12, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
              g_server:broadcastEvent(SetDoorLeftRotationEvent:new(self, rotationMax12), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetDoorLeftRotationEvent:new(self, rotationMax12));
          end;
      end;
      self.rotationMax12 = rotationMax12;
end;

function Doors2:setRotationMax13(rotationMax13, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
			  g_server:broadcastEvent(SetDoorRightRotationEvent:new(self, rotationMax13), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetDoorRightRotationEvent:new(self, rotationMax13));
          end;
      end;
      self.rotationMax13 = rotationMax13;
end;