--
--   TimeScaleMapTrigger
--
-- @author  Decker    (ls-uk.info, Decker_MMIV)
-- @date    2012-07-07
-- 
-- @comment Found problems or bugs? Please post them in the www.ls-uk.info support-thread for this mod. Thank you.
--          This mod is placed in the section 'Other', which at time of writing is; http://www.ls-uk.info/downloads/6
--
-- @history v0.1(beta)  - Private/closed-beta testing.
--          v0.2(beta)  - Multiplayer support, where server-host can increase/decrease time, and clients gets that information.
--



TimeScaleMapTrigger = {}

addModEventListener(TimeScaleMapTrigger);

-- For debugging
function TimeScaleMapTrigger:log(txt)
  --print(string.format("%7ums ", g_currentMission.time) .. txt);
end;
--

function TimeScaleMapTrigger:loadMap(name)
  --TimeScaleMapTrigger:log("TimeScaleMapTrigger:loadMap("..name..")");
end;

function TimeScaleMapTrigger:deleteMap()
  --TimeScaleMapTrigger:log("TimeScaleMapTrigger:deleteMap()");
end;

function TimeScaleMapTrigger:load(xmlFile)
  --TimeScaleMapTrigger:log("TimeScaleMapTrigger:load("..xmlFile..")");
end;

function TimeScaleMapTrigger:delete()
  --TimeScaleMapTrigger:log("TimeScaleMapTrigger:delete()");
end;

function TimeScaleMapTrigger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TimeScaleMapTrigger:keyEvent(unicode, sym, modifier, isDown)
  --TimeScaleMapTrigger:log(string.format("TimeScaleMapTrigger:keyEvent(%s,%s,%s,%s)", tostring(unicode), tostring(sym), tostring(modifier), tostring(isDown)));
end;

function TimeScaleMapTrigger:update(dt)
    -- Only allow server-host when OnFoot to play with the time-scale
    if g_currentMission.controlledVehicle == nil and g_currentMission:getIsServer() then
        local changeTimeScale = 0;
        if      InputBinding.hasEvent(InputBinding.TIMESCALE_INC) then changeTimeScale = 2;
        elseif  InputBinding.hasEvent(InputBinding.TIMESCALE_DEC) then changeTimeScale = 1;
        end;
        --
        if changeTimeScale ~= 0 then
            -- Array of time-scales, and their possible previous/next scale values.
            local timeScales = {ts1={nil,4}, ts4={1,16}, ts16={4,32}, ts32={16,60}, ts60={32,300}, ts300={60,900}, ts900={300,nil}};
            
            local curTimeScale = timeScales["ts"..tostring(g_currentMission.missionStats.timeScale)];
            if curTimeScale ~= nil and curTimeScale[changeTimeScale] ~= nil then
                TimeScaleMapTrigger:setTimeScaleAndCurrTime(curTimeScale[changeTimeScale], nil);
            else
                TimeScaleMapTrigger:log("Unable to change TimeScale, from current: "..tostring(g_currentMission.missionStats.timeScale));
            end;
        end;
    end;
end;

--[[
function TimeScaleMapTrigger:updateTick(dt)
end;
]]
--[[
function TimeScaleMapTrigger:postUpdateTick(dt)
end;
]]

function TimeScaleMapTrigger:draw()
    if self.drawTimeScale ~= nil then
        if (self.drawTimeScale > g_currentMission.time) then
            -- Hide weatherforecast icon.
            g_currentMission.showWeatherForecast = false;
            -- Draw time-scale
            setTextColor(1,1,1,0.8);
            setTextBold(true);
            setTextAlignment(RenderText.ALIGN_CENTER);
            renderText(0.940, 0.92, 0.04, string.format("x%d", g_currentMission.missionStats.timeScale));
            
            -- Reset text-modifiers, because some other draw functions do not always remember to setup their own correctly.
            setTextBold(false);
            setTextAlignment(RenderText.ALIGN_LEFT);
        else
            -- Restore weatherforecast icon.
            g_currentMission.showWeatherForecast = true;
            self.drawTimeScale = nil;
        end;
    end;

    -- Only server-host and OnFoot can play with time-scale
    if g_currentMission.showHelpText and g_currentMission.controlledVehicle == nil and g_currentMission:getIsServer() then
        g_currentMission:addHelpButtonText(g_i18n:getText("TIMESCALE_DEC"), InputBinding.TIMESCALE_DEC);
        g_currentMission:addHelpButtonText(g_i18n:getText("TIMESCALE_INC"), InputBinding.TIMESCALE_INC);
    end
end;

--[[
function TimeScaleMapTrigger:writeStream(streamId, connection)
  -- Server function. 'connection' is <client>.
  -- Called when a player joins game-session
end;

function TimeScaleMapTrigger:readStream(streamId, connection)
  -- Client function. 'connection' is <server>
  -- Called when a player joins game-session
end;
]]
--[[
function TimeScaleMapTrigger:writeUpdateStream(streamId, connection, dirtyMask)
  -- Check Cylindered.LUA or Fillable.LUA for inspiration
end;

function TimeScaleMapTrigger:readUpdateStream(streamId, timestamp, connection)
  -- Check Cylindered.LUA or Fillable.LUA for inspiration
end;
]]

function TimeScaleMapTrigger:setTimeScaleAndCurrTime(newTimeScale, currDayTime, noEventSend)
    currDayTime = Utils.getNoNil(currDayTime, g_currentMission.environment.dayTime);
    TimeScaleMapTriggerEvent.sendEvent(newTimeScale, currDayTime, noEventSend);
    --
    if (not g_currentMission:getIsServer()) then
        -- There is probably no need to sync dayTime on client, but I'm doing it anyway.
        TimeScaleMapTrigger:log(string.format("setting g_currentMission.environment.dayTime(%s): %s", tostring(g_currentMission.environment.dayTime),  tostring(currDayTime)));
        g_currentMission.environment.dayTime = currDayTime;
    end;
    g_currentMission.missionStats.timeScale = newTimeScale;
    TimeScaleMapTrigger:log("New TimeScale set: "..tostring(g_currentMission.missionStats.timeScale));
    -- Draw the new time-scale for 5 seconds.
    self.drawTimeScale = g_currentMission.time + 5000;
end;


------

TimeScaleMapTriggerEvent = {};
TimeScaleMapTriggerEvent_mt = Class(TimeScaleMapTriggerEvent, Event);

InitEventClass(TimeScaleMapTriggerEvent, "TimeScaleMapTriggerEvent");

function TimeScaleMapTriggerEvent.sendEvent(newTimeScale, currTime, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            TimeScaleMapTrigger:log(string.format("TimeScaleMapTriggerEvent.sendEvent() - g_server:broadcastEvent()"));
            g_server:broadcastEvent(TimeScaleMapTriggerEvent:new(newTimeScale, currTime), nil, nil, nil);
        else
            TimeScaleMapTrigger:log(string.format("TimeScaleMapTriggerEvent.sendEvent() - g_client:getServerConnection():sendEvent()"));
            g_client:getServerConnection():sendEvent(TimeScaleMapTriggerEvent:new(newTimeScale, currTime));
        end;
    end;
end;

function TimeScaleMapTriggerEvent:emptyNew()
    local self = Event:new(TimeScaleMapTriggerEvent_mt);
    self.className = "TimeScaleMapTriggerEvent";
    return self;
end;

function TimeScaleMapTriggerEvent:new(newTimeScale, currTime)
    local self = TimeScaleMapTriggerEvent:emptyNew()
    self.newTimeScale = newTimeScale;
    self.currTime     = currTime;
    return self;
end;

function TimeScaleMapTriggerEvent:writeStream(streamId, connection)
    TimeScaleMapTrigger:log(string.format("TimeScaleMapTriggerEvent:writeStream(%s,%s)", tostring(streamId), tostring(connection)));
    streamWriteUInt16(streamId, self.newTimeScale);
    streamWriteFloat32(streamId,  self.currTime);
end;

function TimeScaleMapTriggerEvent:readStream(streamId, connection)
    TimeScaleMapTrigger:log(string.format("TimeScaleMapTriggerEvent:readStream(%s,%s)", tostring(streamId), tostring(connection)));
    self.newTimeScale  = streamReadUInt16(streamId);
    self.currTime      = streamReadFloat32(streamId);
    self:run(connection);
end;

function TimeScaleMapTriggerEvent:run(connection)
    TimeScaleMapTrigger:setTimeScaleAndCurrTime(self.newTimeScale, self.currTime, true);
    if not connection:getIsServer() then
        TimeScaleMapTrigger:log("TimeScaleMapTriggerEvent:run(connection) - not connection:getIsServer()!!!");
        g_server:broadcastEvent(TimeScaleMapTriggerEvent:new(self.newTimeScale, self.currTime), nil, connection, nil);
    end;    
end;

------

print("Script loaded: TimeScaleMapTrigger.LUA (v0.2b)");
