-- If you make changes to this script please keep the authors and add you name to the list
-- windmill
-- Specialization for windmill
--
-- Author of windmill edit Timbertaz
-- Edit Date 2012-08-03
--
--
-- Original box mod author Felix "Outlaw" Sorge
-- original date  20/05/09
-- 
--
-- 
--

windmill = {};

function windmill.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function windmill:load(xmlFile)
 print("------Windmill : By Timbertaz Loaded -----------");
 --self.electricityPrice = 2;
 --self.electricitypower = 250;
 self.money = 0;
 self.yesterDayMoney = 0;
 self.lastDay = g_currentMission.environment.currentDay;
    
self.drumNodeRotary = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotary#index"));
self.drumRotationScale2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.rotary#rotationScale"), 1);



	self.farmerInRange = SpecializationUtil.callSpecializationsFunction("farmerInRange");
	

	self.connectCollisions = SpecializationUtil.callSpecializationsFunction("connectCollisions");
	self.anim = SpecializationUtil.callSpecializationsFunction("anim");
	self.Go = {}; 
	self.Done = {};
	self.charId = {};
	self.clipIndex = {};
	self.CheckDone = {};
	self.moveColli = {}; 
    self.animParts = {}
	self.collisionArm = {}; 
	local count = getXMLInt(xmlFile, "vehicle.animParts#count");
	local part = self.animParts;
    for i=1, count do
		part[i] = {};
        local partname = string.format("vehicle.animParts.part".."%d", i);
	    local nameR = getXMLString(xmlFile, partname.."#name");
		self.charId[nameR] = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#rootNode"));
		self.clipIndex[nameR] = getXMLString(xmlFile, partname.."#animationClip");
		self.CheckDone[nameR] = false;
		self.moveColli[nameR] = getXMLString(xmlFile, partname.."#moveColli");
		if self.moveColli[nameR] ~= nil then
			local Collision = {};
			Collision.collision = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#collision"));
			Collision.collisionAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#collsionAttacher"));
			Collision.armAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.. "#armAttacher"));
			Collision.index = 0;
			self.collisionArm[nameR] = Collision;
			self:connectCollisions(nameR);
		end; 
	end; 
			
	
	
	
	self.comp1Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.comp1Node#index"));
	self.comp0Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.comp0Node#index"));
	self.palletNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.palletNode#index"));
	self.buildNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.buildNode#index"));
	self.compLink = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.compLink#index"));
	self.rotorNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotorNode#index"));
	self.modus = 0; 
	self.keyType = InputBinding.getKeyNamesOfDigitalAction;
	self.keyName = "Taste"; 
	
	
	
end;

function windmill:update(dt)


 self.electricityPrice = math.random(1,5);
 self.power = math.random(30,150);
     
 rotate(self.drumNodeRotary,0 ,0 , self.drumRotationScale2 * 0.0001 +dt  *  0.001);

 self.money = self.money + (self.electricityPrice*self.power)*((dt*g_currentMission.environment.timeScale)/(1000*60*60)); 
-- 1h=1000*60*60


if g_currentMission.environment.currentDay ~= self.lastDay then
print("------Windmill has produced today ------------------------------------------------------");
print("Electricity price: ",self.electricityPrice," Power: ",self.power," Money: ",self.money);
print("----------------------------------------------------------------------------------------");			
                        g_currentMission:addSharedMoney(self.money);
			self.yesterDayMoney = self.money;
			self.money = 0;
			self.lastDay = g_currentMission.environment.currentDay;

		end;	
      
	
	if self.modus == 0 then
	-- nur palette / only palett
	
		setVisibility(self.comp1Node, false);
		setVisibility(self.buildNode, false);
		setVisibility(self.palletNode, true);
                setVisibility(self.rotorNode, false);
		setCollisionMask(self.comp1Node, 0)
		setRigidBodyType(self.comp1Node, "None");
		link(self.compLink, self.comp1Node);
		setTranslation(self.comp1Node, 0,0,0)
		setRotation(self.comp1Node, 0,0,0)
			
	elseif self.modus == 1 then		
	-- platte weg und bauansicht / without palett only buildplan
		setVisibility(self.buildNode, true);
		setVisibility(self.palletNode, true);
		
		
	elseif self.modus == 2 then
	-- aufbau / buliding...			
		setCollisionMask(self.comp1Node, 2102)
		setRigidBodyType(self.comp1Node, "Kinematic");
		setCollisionMask(self.comp0Node, 0)
		setRigidBodyType(self.comp0Node, "None");
			setVisibility(self.comp1Node, true);
		if not self.Go.build then
			self.Go.build = not self.Go.build; 
			self.Done.build = true; 
		end; 
		
	elseif self.modus == 3 then
	-- trigger ist aufgebaut mit fuellfunktion / build done - fill works
		if not self.firstRun then
			self.firstRun = true; 
		
			setVisibility(self.buildNode, false);
			setVisibility(self.comp1Node, true);
			setVisibility(self.palletNode, false);
                        setVisibility(self.rotorNode, true);
			setCollisionMask(self.comp1Node, 0)
			setRigidBodyType(self.comp1Node, "None");
            link(self.compLink, self.comp1Node);
			setTranslation(self.comp1Node, 0,0,0)
			setRotation(self.comp1Node, 0,0,0)
			setCollisionMask(self.comp1Node, 2102)
			setRigidBodyType(self.comp1Node, "Kinematic");
			setCollisionMask(self.comp0Node, 0)
			setRigidBodyType(self.comp0Node, "None");
			
		end;
		
		

	elseif self.modus == 4 then
		-- wieder einpacken, wurde schon ausgefhrt  / rebuild 
		setVisibility(self.buildNode, true);
		g_currentMission:addExtraPrintText(g_i18n:getText("WINDMILL_6"));
		
	end; 	
	
	
		
	if self.CheckDone.build then
		-- aufbau fertig / build done
		self.modus = 3; 
		setVisibility(self.buildNode, false);
		setVisibility(self.comp1Node, true);
                setVisibility(self.rotorNode, true);
               

	end; 
		
	if self.Go.build ~= nil and self.Done.build ~= false then
		self:anim("build", false); 
	end; 
	
	

	
          

	self:farmerInRange(); 
			
end;





function windmill:farmerInRange(dt)
    local nearestDistance = 12.0;
	local px, py, pz = getWorldTranslation(self.rootNode);
	local vx, vy, vz = getWorldTranslation(getCamera());
	if vx ~= nil and  vy ~= nil and vz ~= nil then
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		
	if distance < nearestDistance then
        
		if self.modus == 0 then
			-- trigger bauansicht
			g_currentMission:addHelpButtonText(g_i18n:getText("WINDMILL_1"), InputBinding.LOWER_IMPLEMENT);
			if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
				self.modus = 1; 
			end; 
			
		elseif self.modus == 1 then
			-- trigger aufbauen
			g_currentMission:addHelpButtonText(g_i18n:getText("WINDMILL_2"), InputBinding.IMPLEMENT_EXTRA);
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
				self.modus = 2; 
			end; 
			
		elseif self.modus == 3 then
			-- trigger einpacken

 
			--g_currentMission:addHelpButtonText(g_i18n:getText("WINDMILL_5"), InputBinding.IMPLEMENT_EXTRA);
			if InputBinding.isPressed(InputBinding.IMPLEMENT_EXTRA) then
				self.modus = 4; 
			end;
           end;
		end;

	end;
	

end;




function windmill:delete()
	link(self.comp1Node, self.comp1Node);
end;

function windmill:anim(varName, loopCheck)
	if self.moveColli[varName] ~= nil then
		local Collision = self.collisionArm[varName];
		setJointFrame(Collision.index, 0, Collision.armAttacher);
	end;
	if self.Go[varName] == true and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, 1);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) and loopCheck == false then
			disableAnimTrack(charId, 0);	
			self.Done[varName] = false;	
			self.CheckDone[varName] = true;	
		end; 
	elseif self.Go[varName] == false and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		if loopCheck == true then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
		end; 	
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, -1);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) <= 0 then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
			self.CheckDone[varName] = false;
		end;
	end;
end; 

function windmill:connectCollisions(varName)
	local Collision = self.collisionArm[varName];
	local constr = JointConstructor:new();
	constr:setActors(self.rootNode, Collision.collision);
	constr:setJointTransforms(Collision.armAttacher, Collision.collisionAttacher);
	for i=1, 3 do		            
		constr:setRotationLimit(i-1, 0, 0, 0);
		constr:setTranslationLimit(i-1, true, 0, 0);
	end;
	Collision.index = constr:finalize();
end;

function windmill:mouseEvent(posX, posY, isDown, isUp, button)
end;

function windmill:keyEvent(unicode, sym, modifier, isDown)
end;

function windmill:draw()



end;

function windmill:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if resetVehicles then
		self.modus = 0;
	else
		self.modus = Utils.getNoNil(getXMLFloat(xmlFile, key.."#modus"), 0);
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function windmill:getSaveAttributesAndNodes(nodeIdent)
	if self.modus == 4 then
		self.modus = 0;
	end; 	
	local attributes = 'modus="'..tonumber(self.modus)..'"';
	return attributes, nil;
end;