--
-- TheGreatPlainsUSA
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

TheGreatPlainsUSA = {}

local TheGreatPlainsUSA_mt = Class(TheGreatPlainsUSA, Mission00);

function TheGreatPlainsUSA:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = TheGreatPlainsUSA_mt;
    end;
    local self = TheGreatPlainsUSA:superClass():new(baseDirectory, mt);
    return self;
end;

function TheGreatPlainsUSA:delete()
    TheGreatPlainsUSA:superClass().delete(self);
end;

function TheGreatPlainsUSA:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    
    -- load paths for AI traffic vehicles
    self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
    
    -- load paths for AI pedestrians
    self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("$data/maps/missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
    TheGreatPlainsUSA:superClass().load(self);
end
function TheGreatPlainsUSA:loadFinished()
    TheGreatPlainsUSA:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function TheGreatPlainsUSA:mouseEvent(posX, posY, isDown, isUp, button)
    TheGreatPlainsUSA:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function TheGreatPlainsUSA:keyEvent(unicode, sym, modifier, isDown)
    TheGreatPlainsUSA:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function TheGreatPlainsUSA:update(dt)
    TheGreatPlainsUSA:superClass().update(self, dt);
end;

function TheGreatPlainsUSA:draw()
    TheGreatPlainsUSA:superClass().draw(self);
end;
