--BISO SWW
--hz888

BISO = {}

function BISO.prerequisitesPresent(specializations)
		Vehicle.registerJointType("cutter");
	return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function BISO:load(xmlFile)

    self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    if self.numbrakelights ~= nil then
    	for i=1, self.numbrakelights do
        	local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        	self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        	setVisibility(self.brakelights[i], false);
    	end;
    end;
    self.brakelightsActive = false;
	
end;

function BISO:delete()
end;

function BISO:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BISO:keyEvent(unicode, sym, modifier, isDown)
end;

function BISO:update(dt)

    if self:getIsActive() then

        self.input = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);

        if InputBinding.isAxisZero(self.input) then
        	self.input = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
        end;
	if self.numbrakelights ~= nil then
		if self.brakelightsActive then
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive);
			end;
		else
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive, false);
			end;
		end;
	end;


	if self.attacherVehicle.reverse then
		if -self.input > 0.001 and self.movingDirection > 0 then
			self.brakelightsActive = true;
		elseif -self.input < -0.001 and self.movingDirection <= 0 then
    			self.brakelightsActive = true;
		elseif self.attacherVehicle.handbrake then
    			self.brakelightsActive = true;
		else
			self.brakelightsActive = false;
		end;
	else
		if -self.input < -0.001 and self.movingDirection >= 0 then
			self.brakelightsActive = true;
		elseif -self.input > 0.001 and self.movingDirection < 0 then
    			self.brakelightsActive = true;
		elseif self.attacherVehicle.handbrake then
    			self.brakelightsActive = true;
		else
			self.brakelightsActive = false;
		end;
	end;

   end;

end;

function BISO:draw()

	g_currentMission:addExtraPrintText(g_i18n:getText("BISO_1"));

end;

function BISO:onDetach()

    for i=table.getn(self.attachedImplements), 1, -1 do
	self:detachImplement(1);
    end;
    self.brakelightsActive = false;
    if self.numbrakelights ~= nil then
	for i=1, self.numbrakelights do
		local brakelight = self.brakelights[i];
		setVisibility(brakelight, self.brakelightsActive, false);
	end;
    end;

end;