--
-- dynamicPlane
-- Class for dynamic Plane
--
-- @author  Stefan Maurus, www.stefanmaurus.de
-- @date  05.07.2012
--
 
dynamicPlane = {};
  
function dynamicPlane.prerequisitesPresent(specializations)
      return true;
end;

function dynamicPlane:load(xmlFile)
	self.IsLoading = false;
	
    self.mesh = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dynamicPlane#mesh"));
	link(getRootNode(),self.mesh);
	setTranslation(self.mesh,0,0,0);
	setRotation(self.mesh,0,0,0);	
	
	self.stats = {};	
	self.stats.startLoading = Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.dynamicPlane#startLoading"),0);	
	self.stats.loadingDuration = Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.dynamicPlane#loadingDuration"),10000);		
	self.stats.startUnloading = Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.dynamicPlane#startUnloading"),11000);	
	self.stats.unloadingDuration = Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.dynamicPlane#unloadingDuration"),10000);	

    self.dynamicPlaneAnimation = {};
    self.dynamicPlaneAnimation.animCharSet = 0;
    self.dynamicPlaneAnimationEnabled = false;
  
    local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dynamicPlane#rootNode"));
  
    if rootNode ~= nil then
        self.dynamicPlaneAnimation.animCharSet = getAnimCharacterSet(rootNode);
        if self.dynamicPlaneAnimation.animCharSet ~= 0 then
            self.dynamicPlaneAnimation.clip = getAnimClipIndex(self.dynamicPlaneAnimation.animCharSet, getXMLString(xmlFile, "vehicle.dynamicPlane#animationClip"));
            if self.dynamicPlaneAnimation.clip >= 0 then
                assignAnimTrackClip(self.dynamicPlaneAnimation.animCharSet, 0, self.dynamicPlaneAnimation.clip);
                setAnimTrackSpeedScale(self.dynamicPlaneAnimation.animCharSet, self.dynamicPlaneAnimation.clip, 0);
                setAnimTrackLoopState(self.dynamicPlaneAnimation.animCharSet, 0, false);
            end;
        end;
    end;	
end;

function dynamicPlane:delete()
    delete(self.mesh);
end;

function dynamicPlane:readStream(streamId, connection)
end;

function dynamicPlane:writeStream(streamId, connection)
end;

function dynamicPlane:mouseEvent(posX, posY, isDown, isUp, button)
end;
 
function dynamicPlane:keyEvent(unicode, sym, modifier, isDown)
end;
 
function dynamicPlane:update(dt)	
	local fillLevelNew = self.fillLevel / self.capacity * 100;
	local fillLevelFaktor = fillLevelNew / 100;
	
	if not self.dynamicPlaneAnimationEnabled then
        enableAnimTrack(self.dynamicPlaneAnimation.animCharSet, 0);
		self.dynamicPlaneAnimationEnabled = true;
	end;
	
	if self.fillLevel > 0 then
		if self.IsLoading then
			setAnimTrackTime(self.dynamicPlaneAnimation.animCharSet, 0, fillLevelFaktor*self.stats.loadingDuration, true);
		else
			local faktorNew = 1 - fillLevelFaktor;
			local Duration1 = faktorNew * self.stats.unloadingDuration;
			local Duration2 = Duration1 + self.stats.startUnloading ;
			setAnimTrackTime(self.dynamicPlaneAnimation.animCharSet, 0, Duration2, true);	
		end;
	else
		setAnimTrackTime(self.dynamicPlaneAnimation.animCharSet, 0, 0, true);
	end;
	
	if self.dynamicPlaneAnimationEnabled then
        disableAnimTrack(self.dynamicPlaneAnimation.animCharSet, 0);
		self.dynamicPlaneAnimationEnabled = false;
	end;
end;

function dynamicPlane:updateTick(dt)
    if self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN then
		self.IsLoading = false;
	else
		self.IsLoading = true;
    end;	
end;
 
function dynamicPlane:draw()
end;
 
function dynamicPlane:onDetach()
end;

function dynamicPlane:onLeave()
end;
 
function dynamicPlane:onDeactivate()
end;
  
function dynamicPlane:onDeactivateSounds()
end;