--
-- SpreaderUnloading
-- specialization for TebbeHS 180 
--
-- @author	FIAT80-90DT
-- @date  	10.11.2011
--
-- #### (C) - www.modding-stage.com_-: FIAT80-90DT ####
 
SpreaderUnloading = {};
  
function SpreaderUnloading.prerequisitesPresent(specializations)
      return SpecializationUtil.hasSpecialization(Sprayer, specializations) and SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function SpreaderUnloading:load(xmlFile)
	self.changePlane = SpecializationUtil.callSpecializationsFunction("changePlane");
	self.setFillLevel = Fillable.setFillLevel
	
	self.planes = {};
	str = string.format("vehicle.fillPlanes.steps")
	
	self.planes.unloading = {};
	self.planes.unloading.index = Utils.indexToObject(self.components, getXMLString(xmlFile, str.. ".unloading#index"));

	self.planes.loading = {};
	self.planes.loading.index = Utils.indexToObject(self.components, getXMLString(xmlFile, str.. ".loading#index"));
	
	self.loading = true;
	self:changePlane(self.loading);
	
	self.fillLevelBackup = self.fillLevel
end;

function SpreaderUnloading:delete()
end;

function SpreaderUnloading:readStream(streamId, connection)
	self:changePlane(streamReadBool(streamId), true);
end;
 
function SpreaderUnloading:writeStream(streamId, connection)
	streamWriteBool(streamId, self.loading);
end;
 
function SpreaderUnloading:mouseEvent(posX, posY, isDown, isUp, button)
end;
 
function SpreaderUnloading:keyEvent(unicode, sym, modifier, isDown)
end;

function SpreaderUnloading:changePlane(bool, noEventSend)
	local loading = self.planes.loading;
	local unloading = self.planes.unloading;
	--self.fillLevelBackup = self.fillLevel;
	
	-- support a regulated exchange -- 
	if bool ~= nil then	
		if bool then 	-- loading
			setVisibility(loading.index, true);
			setVisibility(unloading.index, false);
			--print("loading");
		else			-- unloading
			setVisibility(loading.index, false);
			setVisibility(unloading.index, true);
			--print("unloading");
		end;
		self.loading = bool;
		ChangePlaneEvent.sendEvent(self, bool, noEventSend)
	else
		self:changePlane(not self.loading); -- get a varity betwwen both planes -- 
	end;
end;

function SpreaderUnloading:update(dt)
	if self.fillLevelBackup < self.fillLevel then
		self.fillLevelBackup = self.fillLevel;
		if not self.loading then
			self:changePlane(true);
		end;
	end;
	if self:getIsActiveForInput() then
		if self.isTurnedOn then
			self.fillLevelBackup = self.fillLevel;
			if self.loading then
				self:changePlane(false); -- set only unloadingPlane
			end;
		end;
	end;
end;

function SpreaderUnloading:draw()
end;