


hidraulika = {}

function hidraulika.prerequisitesPresent(specializations)
    Vehicle.registerJointType("frontloader");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function hidraulika:load(xmlFile)
		
    
    local armDownNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.armDown#index"));
    if armDownNode ~= nil then
        self.armDown = {};
        self.armDown.node = armDownNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armDown#minRot"));
        self.armDown.minRot = {};
        self.armDown.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armDown.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armDown.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armDown#maxRot"));
        self.armDown.maxRot = {};
        self.armDown.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armDown.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armDown.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.armDown.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.armDown#rotTime"), 2)*1000;
        self.armDown.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.armDown#touchRotLimit"), 10));
    end;

    local armUpNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.armUp#index"));
    if armUpNode ~= nil then
        self.armUp = {};
        self.armUp.node = armUpNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armUp#minRot"));
        self.armUp.minRot = {};
        self.armUp.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armUp.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armUp.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armUp#maxRot"));
        self.armUp.maxRot = {};
        self.armUp.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armUp.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armUp.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.armUp.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.armUp#rotTime"), 2)*1000;
        self.armUp.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.armUp#touchRotLimit"), 10));
    end;

    local cylinder1Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.cylinder1#index"));
    if cylinder1Node ~= nil then
        self.cylinder1 = {};
        self.cylinder1.node = cylinder1Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cylinder1#minRot"));
        self.cylinder1.minRot = {};
        self.cylinder1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.cylinder1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.cylinder1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cylinder1#maxRot"));
        self.cylinder1.maxRot = {};
        self.cylinder1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.cylinder1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.cylinder1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.cylinder1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.cylinder1#rotTime"), 2)*1000;
        self.cylinder1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.cylinder1#touchRotLimit"), 10));
    end;

    local cylinder2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.cylinder2#index"));
    if cylinder2Node ~= nil then
        self.cylinder2 = {};
        self.cylinder2.node = cylinder2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cylinder2#minTrans"));
        self.cylinder2.minTrans = {};
        self.cylinder2.minTrans[1] = Utils.getNoNil(x, 0);
        self.cylinder2.minTrans[2] = Utils.getNoNil(y, 0);
        self.cylinder2.minTrans[3] = Utils.getNoNil(z, 0);
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cylinder2#maxTrans"));
        self.cylinder2.maxTrans = {};
        self.cylinder2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.cylinder2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.cylinder2.maxTrans[3] = Utils.getNoNil(z, 0);
        self.cylinder2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.cylinder2#transTime"), 2)*1000;
        self.cylinder2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.cylinder2#touchTransLimit"), 10);
    end;

    local rotBraceNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotBrace#index"));
    if rotBraceNode ~= nil then
        self.rotBrace = {};
        self.rotBrace.node = rotBraceNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotBrace#minRot"));
        self.rotBrace.minRot = {};
        self.rotBrace.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotBrace.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotBrace.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotBrace#maxRot"));
        self.rotBrace.maxRot = {};
        self.rotBrace.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotBrace.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotBrace.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotBrace.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotBrace#rotTime"), 2)*1000;
        self.rotBrace.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotBrace#touchRotLimit"), 10));
    end;

    local padNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.pad#index"));
    if padNode ~= nil then
        self.pad = {};
        self.pad.node = padNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.pad#minRot"));
        self.pad.minRot = {};
        self.pad.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.pad.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.pad.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.pad#maxRot"));
        self.pad.maxRot = {};
        self.pad.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.pad.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.pad.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.pad.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.pad#rotTime"), 2)*1000;
        self.pad.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.pad#touchRotLimit"), 10));
    end;

    local osszekotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.osszekot#index"));
    if osszekotNode ~= nil then
        self.osszekot = {};
        self.osszekot.node = osszekotNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.osszekot#minRot"));
        self.osszekot.minRot = {};
        self.osszekot.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.osszekot.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.osszekot.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.osszekot#maxRot"));
        self.osszekot.maxRot = {};
        self.osszekot.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.osszekot.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.osszekot.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.osszekot.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.osszekot#rotTime"), 2)*1000;
        self.osszekot.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.osszekot#touchRotLimit"), 10));
    end;

end;
      
function hidraulika:delete()
end;

function hidraulika:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function hidraulika:keyEvent(unicode, sym, modifier, isDown)

    if sym == Input.KEY_pageup  then
	self.armDownMax = isDown;
	self.armUpMax = isDown;
	self.cylinder1Max = isDown;
	self.rotBraceMax = isDown;
	self.padMax = isDown;
	self.osszekotMax = isDown;
	self.cylinder2Max = isDown;
	self.armMax = true;
	self.armMin = false;
	self.armDownMin = false;
	self.armUpMin = false;
	self.cylinder1Min = false;
	self.rotBraceMin = false;
	self.padMin = false;
	self.osszekotMin = false;
	self.cylinder2Min = false;
        local x, y, z = getRotation(self.armDown.node);
	if x >= self.armDown.maxRot[1]-0.03 then
	      if self.selectedImplement ~= 0 then
	          local implement = self.attachedImplements[self.selectedImplement];
	          local jointDesc = self.attacherJoints[implement.jointDescIndex];
	          self:setJointMoveDown(implement.jointDescIndex, false, false);
	      end;
	end;		
    end;

    if sym == Input.KEY_pagedown then
	self.armDownMin = isDown;
	self.armUpMin = isDown;
	self.cylinder1Min = isDown;
	self.rotBraceMin = isDown;
	self.padMin = isDown;
	self.osszekotMin = isDown;
	self.cylinder2Min = isDown;
	self.armDownMax = false;
	self.armUpMax = false;
	self.cylinder1Max = false;
	self.rotBraceMax = false;
	self.padMax = false;
	self.osszekotMax = false;
	self.cylinder2Max = false;
        local x, y, z = getRotation(self.armDown.node);
	if x <= self.armDown.minRot[1]+0.03 then
	      if self.selectedImplement ~= 0 then
	          local implement = self.attachedImplements[self.selectedImplement];
	          local jointDesc = self.attacherJoints[implement.jointDescIndex];
	          self:setJointMoveDown(implement.jointDescIndex, true, true);
	      end;
	end;
    end;

end;

function hidraulika:update(dt)

    if self.isAITractorActivated then
		if self.turnStage == 0 then
   		 	if self.selectedImplement ~= 0 then
        			local implement = self.attachedImplements[self.selectedImplement];
        			if implement.object.allowsLowering then
            				local jointDesc = self.attacherJoints[implement.jointDescIndex];
            				if jointDesc.allowsLowering then
                				jointDesc.moveDown = true;
            				end;
        			end;
   		 	end;
			self.armDownMin = true;
			self.armUpMin = true;
			self.cylinder1Min = true;
			self.rotBraceMin = true;
			self.padMin = true;
			self.osszekotMin = true;
			self.cylinder2Min = true;
			self.armDownMax = false;
			self.armUpMax = false;
			self.cylinder1Max = false;
			self.rotBraceMax = false;
			self.padMax = false;
			self.osszekotMax = false;
			self.cylinder2Max = false;
		else
   		 	if self.selectedImplement ~= 0 then
        			local implement = self.attachedImplements[self.selectedImplement];
        			if implement.object.allowsLowering then
            				local jointDesc = self.attacherJoints[implement.jointDescIndex];
            				if jointDesc.allowsLowering then
                				jointDesc.moveDown = false;
            				end;
        			end;
   			end;
			self.armDownMax = true;
			self.armUpMax = true;
			self.cylinder1Max = true;
			self.rotBraceMax = true;
			self.padMax = true;
			self.osszekotMax = true;
			self.cylinder2Max = true;
			self.armDownMin = false;
			self.armUpMin = false;
			self.cylinder1Min = false;
			self.rotBraceMin = false;
			self.padMin = false;
			self.osszekotMin = false;
			self.cylinder2Min = false;
		end;
    elseif self:getIsActiveForInput() and self.isEntered then

        if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
		if not self.armDownMax then
   		 	if self.selectedImplement ~= 0 then
        			local implement = self.attachedImplements[self.selectedImplement];
        			if implement.object.allowsLowering then
            				local jointDesc = self.attacherJoints[implement.jointDescIndex];
            				if jointDesc.allowsLowering then
                				jointDesc.moveDown = false;
            				end;
        			end;
   			end;
			self.armDownMax = true;
			self.armUpMax = true;
			self.cylinder1Max = true;
			self.rotBraceMax = true;
			self.padMax = true;
			self.osszekotMax = true;
			self.cylinder2Max = true;
			self.armDownMin = false;
			self.armUpMin = false;
			self.cylinder1Min = false;
			self.rotBraceMin = false;
			self.padMin = false;
			self.osszekotMin = false;
			self.cylinder2Min = false;
		else
   		 	if self.selectedImplement ~= 0 then
        			local implement = self.attachedImplements[self.selectedImplement];
        			if implement.object.allowsLowering then
            				local jointDesc = self.attacherJoints[implement.jointDescIndex];
            				if jointDesc.allowsLowering then
                				jointDesc.moveDown = true;
            				end;
        			end;
   		 	end;
			self.armDownMin = true;
			self.armUpMin = true;
			self.cylinder1Min = true;
			self.rotBraceMin = true;
			self.padMin = true;
			self.osszekotMin = true;
			self.cylinder2Min = true;
			self.armDownMax = false;
			self.armUpMax = false;
			self.cylinder1Max = false;
			self.rotBraceMax = false;
			self.padMax = false;
			self.osszekotMax = false;
			self.cylinder2Max = false;
		end;
        end;

	if InputBinding.hasEvent(InputBinding.ATTACH) then
		if not self.armDownMax then
   		 	if self.selectedImplement ~= 0 then
        			local implement = self.attachedImplements[self.selectedImplement];
        			if implement.object.allowsLowering then
            				local jointDesc = self.attacherJoints[implement.jointDescIndex];
            				if jointDesc.allowsLowering then
                				jointDesc.moveDown = false;
            				end;
        			end;
   			end;
			self.armDownMax = true;
			self.armUpMax = true;
			self.cylinder1Max = true;
			self.rotBraceMax = true;
			self.padMax = true;
			self.osszekotMax = true;
			self.cylinder2Max = true;
			self.armDownMin = false;
			self.armUpMin = false;
			self.cylinder1Min = false;
			self.rotBraceMin = false;
			self.padMin = false;
			self.osszekotMin = false;
			self.cylinder2Min = false;
		else
   		 	if self.selectedImplement ~= 0 then
        			local implement = self.attachedImplements[self.selectedImplement];
        			if implement.object.allowsLowering then
            				local jointDesc = self.attacherJoints[implement.jointDescIndex];
            				if jointDesc.allowsLowering then
                				jointDesc.moveDown = true;
            				end;
        			end;
   		 	end;
			self.armDownMin = true;
			self.armUpMin = true;
			self.cylinder1Min = true;
			self.rotBraceMin = true;
			self.padMin = true;
			self.osszekotMin = true;
			self.cylinder2Min = true;
			self.armDownMax = false;
			self.armUpMax = false;
			self.cylinder1Max = false;
			self.rotBraceMax = false;
			self.padMax = false;
			self.osszekotMax = false;
			self.cylinder2Max = false;
		end;
	end;
    end;

	local doRotate = self.armUpMax or self.armUpMin 
	if self.armUp ~= nil and doRotate then
		local x, y, z = getRotation(self.armUp.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.armUp.maxRot, self.armUp.minRot, 3, self.armUp.rotTime, dt, not self.armUpMax);
		setRotation(self.armUp.node, unpack(newRot));
	end;

	local doRotate = self.armDownMax or self.armDownMin 
	if self.armDown ~= nil and doRotate then
        	local x, y, z = getRotation(self.armDown.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.armDown.maxRot, self.armDown.minRot, 3, self.armDown.rotTime, dt, not self.armDownMax);
        	setRotation(self.armDown.node, unpack(newRot));
	end;

	local doRotate = self.cylinder1Max or self.cylinder1Min 
	if self.cylinder1 ~= nil and doRotate then
		local x, y, z = getRotation(self.cylinder1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.cylinder1.maxRot, self.cylinder1.minRot, 3, self.cylinder1.rotTime, dt, not self.cylinder1Max);
		setRotation(self.cylinder1.node, unpack(newRot));
	end;

	local doTranslate = self.cylinder2Max or self.cylinder2Min 
	if self.cylinder2 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.cylinder2.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.cylinder2.maxTrans, self.cylinder2.minTrans, 3, self.cylinder2.transTime, dt, not self.cylinder2Max); 
		setTranslation(self.cylinder2.node, unpack(newTrans)); 
	end;

	local doRotate = self.rotBraceMax or self.rotBraceMin 
	if self.rotBrace ~= nil and doRotate then
		local x, y, z = getRotation(self.rotBrace.node);		
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotBrace.maxRot, self.rotBrace.minRot, 3, self.rotBrace.rotTime, dt, not self.rotBraceMax);
		setRotation(self.rotBrace.node, unpack(newRot));
	end;

	local doRotate = self.padMax or self.padMin 
	if self.pad ~= nil and doRotate then
		local x, y, z = getRotation(self.pad.node);		
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.pad.maxRot, self.pad.minRot, 3, self.pad.rotTime, dt, not self.padMax);
		setRotation(self.pad.node, unpack(newRot));
	end;
	
	local doRotate = self.osszekotMax or self.osszekotMin 
	if self.osszekot ~= nil and doRotate then
		local x, y, z = getRotation(self.osszekot.node);		
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.osszekot.maxRot, self.osszekot.minRot, 3, self.osszekot.rotTime, dt, not self.osszekotMax);
		setRotation(self.osszekot.node, unpack(newRot));
	end;

end;

function hidraulika:draw()


end;

function hidraulika:onLeave()


end;

function hidraulika:validateAttacherJoint(implement, jointDesc, dt)
	local jointType = implement.object.attacherJoint.jointType;
	if jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		setVisibility(self.pad.node, true);
		setVisibility(self.osszekot.node, true);
	else
		setVisibility(self.pad.node, false);
		setVisibility(self.osszekot.node, false);
	end;
    return true;
end;


















