Tatra6x6 = {};

function Tatra6x6.prerequisitesPresent(specializations)
	return true;
end;

function Tatra6x6:load(xmlFile)

	self.exhaustFlap = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.exhaustFlap#index"));
	
	self.frontholder = {};
	self.frontholder.object = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontholder#index"));
	self.frontholder.refPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontholder#referencePoint"));
	self.frontholder.refRotX = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.frontholder#referenceRotX"), -1.04); 
	
	self.backholder = {};
	self.backholder.object = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backholder#index"));
	self.backholder.refPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backholder#referencePoint"));
	self.backholder.refRotX = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.backholder#referenceRotX"), 1.30); 
	
	self.fourWheelMode = false;
	self.isStarted = false;
	
	-- 4x4 symbol--
	
	self.hudfourWheelMode_yesPosX = 0.7557;
    self.hudfourWheelMode_yesWidth = 0.235;
    self.hudfourWheelMode_yesPosY = 0.214;
    self.hudfourWheelMode_yesHeight = 0.037;

	self.infoPanelfourWheelModePath = Utils.getFilename("texturen/Quatro_hud2.png", self.baseDirectory);
	self.hudfourWheelMode_yesOverlay = Overlay:new("hudfourWheelMode", self.infoPanelfourWheelModePath, self.hudfourWheelMode_yesPosX, self.hudfourWheelMode_yesPosY, self.hudfourWheelMode_yesWidth, self.hudfourWheelMode_yesHeight);

	self.showHudfourWheelMode_yes = false;
	
end;

function Tatra6x6:delete()
  -- 4x4 symbol --
    if self.hudfourWheelModeyesOverlay ~= nil then
		self.hudfourWheelMode_yesOverlay:delete();
	end;
end;

function Tatra6x6:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Tatra6x6:keyEvent(unicode, sym, modifier, isDown)

end;

function Tatra6x6:update(dt)

	if self.isMotorStarted then
		local rotX, rotY, rotZ = getRotation(self.exhaustFlap);
		local rotX = Utils.degToRad((self.motor.nonClampedMotorRpm+200)/28);
		if self.motor.minRpm < 0 then
			rotX = rotX-Utils.degToRad(self.motor.minRpm/28);
		else
			rotX = rotX
		end;
		if rotX < Utils.degToRad(0) then
			rotX = Utils.degToRad(0);
		end;
		if rotX > Utils.degToRad(70) then
			rotX = Utils.degToRad(70);
		end;
		setRotation(self.exhaustFlap, rotX*-1, rotY, rotZ);
	end;
	
	if self.isEntered then
		if InputBinding.hasEvent(InputBinding.SIXWHEEL) then
			self.fourWheelMode = not self.fourWheelMode;
		end;
	end;
	
	-- 4x4 symbol status --
   	if self.fourWheelMode == true then
			self.showHudfourWheelMode_yes = true
		else
			self.showHudfourWheelMode_yes = false
	end;
	
	if self.frontholder.refPoint ~= nil and self.frontholder.refRotX ~= nil then
		local xRefPointFront, yRefPointFront, zRefPointFront = getRotation(self.frontholder.refPoint);
		local xRefPointBack, yRefPointBack, zRefPointBack = getRotation(self.backholder.refPoint);
		if math.floor(xRefPointFront*100)/100 ~= self.frontholder.refRotX then
			setRotation(self.frontholder.object, Utils.degToRad(69.21102), 0, 0);
		else
			setRotation(self.frontholder.object, Utils.degToRad(-1.34007), 0, 0);
		end;
		if math.floor(xRefPointBack*100)/100 ~= self.backholder.refRotX then
			setRotation(self.backholder.object, Utils.degToRad(-67.97647), 0, 0);
		else
			setRotation(self.backholder.object, Utils.degToRad(-0.30185), 0, 0);
		end;
	end;	
	
	if self.fourWheelMode then
		for i=1, table.getn(self.wheels) do
			self.wheels[1].driveMode = 1;
			self.wheels[2].driveMode = 1;
			self.wheels[3].driveMode = 1;
			self.wheels[4].driveMode = 1;
			self.wheels[5].driveMode = 1;
			self.wheels[6].driveMode = 1;		
		end;
	else
		for i=1, table.getn(self.wheels) do
			self.wheels[1].driveMode = 0;
			self.wheels[2].driveMode = 0;
			self.wheels[3].driveMode = 1;
			self.wheels[4].driveMode = 1;
			self.wheels[5].driveMode = 1;
			self.wheels[6].driveMode = 1;		
		end;
	end;
	
end;

function Tatra6x6:onLeave()
end;

function Tatra6x6:draw()
	if self.fourWheelMode then
		g_currentMission:addHelpButtonText(g_i18n:getText("Tatra6x6_1"), InputBinding.SIXWHEEL);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("Tatra6x6_2"), InputBinding.SIXWHEEL);
	end;
	if self.showHudfourWheelMode_yes and self.isEntered then
		self.hudfourWheelMode_yesOverlay:render();
	end;
end;

function Tatra6x6:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
