--T150
--23:24 25.09.2011
--by Northern_Strike(RUS) for LSSA MT 

T150 = {};

function T150.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function T150:load(xmlFile)

self.controlpathgearhud1 = Utils.getFilename("hud/gearhud1.png", self.baseDirectory);

self.hudGeargearhud1Width = 0.405;
    self.hudGeargearhud1Height = 0.455;
    self.hudGeargearhud1PoxX = 0.6;
    self.hudGeargearhud1PoxY = 0.5;
    self.hudGeargearhud1Overlay = Overlay:new("hudGeargearhud1", self.controlpathgearhud1, self.hudGeargearhud1PoxX, self.hudGeargearhud1PoxY, self.hudGeargearhud1Width, self.hudGeargearhud1Height);

self.controlpath4p = Utils.getFilename("hud/4p.png", self.baseDirectory);

self.hudGear4pWidth = 0.405;
    self.hudGear4pHeight = 0.455;
    self.hudGear4pPoxX = 0.6;
    self.hudGear4pPoxY = 0.5
    self.hudGear4pOverlay = Overlay:new("hudGear4p", self.controlpath4p, self.hudGear4pPoxX, self.hudGear4pPoxY, self.hudGear4pWidth, self.hudGear4pHeight);

self.controlpath3p = Utils.getFilename("hud/3p.png", self.baseDirectory);

self.hudGear3pWidth = 0.405;
    self.hudGear3pHeight = 0.455;
    self.hudGear3pPoxX = 0.6;
    self.hudGear3pPoxY = 0.5
    self.hudGear3pOverlay = Overlay:new("hudGear3p", self.controlpath3p, self.hudGear3pPoxX, self.hudGear3pPoxY, self.hudGear3pWidth, self.hudGear3pHeight);

self.controlpath2p = Utils.getFilename("hud/2p.png", self.baseDirectory);

self.hudGear2pWidth = 0.405;
    self.hudGear2pHeight = 0.455;
    self.hudGear2pPoxX = 0.6;
    self.hudGear2pPoxY = 0.5
    self.hudGear2pOverlay = Overlay:new("hudGear2p", self.controlpath2p, self.hudGear2pPoxX, self.hudGear2pPoxY, self.hudGear2pWidth, self.hudGear2pHeight);

self.controlpath1p = Utils.getFilename("hud/1p.png", self.baseDirectory);

self.hudGear1pWidth = 0.405;
    self.hudGear1pHeight = 0.455;
    self.hudGear1pPoxX = 0.6;
    self.hudGear1pPoxY = 0.5
    self.hudGear1pOverlay = Overlay:new("hudGear1p", self.controlpath1p, self.hudGear1pPoxX, self.hudGear1pPoxY, self.hudGear1pWidth, self.hudGear1pHeight);

self.controlpath2d = Utils.getFilename("hud/2d.png", self.baseDirectory);

self.hudGear2dWidth = 0.405;
    self.hudGear2dHeight = 0.455;
    self.hudGear2dPoxX = 0.6;
    self.hudGear2dPoxY = 0.5
    self.hudGear2dOverlay = Overlay:new("hudGear2d", self.controlpath2d, self.hudGear2dPoxX, self.hudGear2dPoxY, self.hudGear2dWidth, self.hudGear2dHeight);

self.controlpathZ = Utils.getFilename("hud/z.png", self.baseDirectory);

self.hudGearZWidth = 0.405;
    self.hudGearZHeight = 0.455;
    self.hudGearZPoxX = 0.6;
    self.hudGearZPoxY = 0.5
    self.hudGearZOverlay = Overlay:new("hudGearZ", self.controlpathZ, self.hudGearZPoxX, self.hudGearZPoxY, self.hudGearZWidth, self.hudGearZHeight);

self.controlpathN = Utils.getFilename("hud/n.png", self.baseDirectory);

self.hudGearNWidth = 0.405;
    self.hudGearNHeight = 0.455;
    self.hudGearNPoxX = 0.6;
    self.hudGearNPoxY = 0.5
    self.hudGearNOverlay = Overlay:new("hudGearN", self.controlpathN, self.hudGearNPoxX, self.hudGearNPoxY, self.hudGearNWidth, self.hudGearNHeight);

       self.ventelator1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ventelator1#index"));

    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;

	local rotationPartNoderuchnik = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ruchnik#index"));
    if rotationPartNoderuchnik ~= nil then
        self.rotationPartruchnik = {};
        self.rotationPartruchnik.node = rotationPartNoderuchnik;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartruchnik#minRot"));
        self.rotationPartruchnik.minRot = {};
        self.rotationPartruchnik.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartruchnik.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartruchnik.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.ruchnik#maxRot"));
        self.rotationPartruchnik.maxRot = {};
        self.rotationPartruchnik.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartruchnik.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartruchnik.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartruchnik.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.ruchnik#rotTime"), 2)*1000;
        self.rotationPartruchnik.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.ruchnik#touchRotLimit"), 10));
    end;

 self.gearShifter = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.gearShifter#index"));
 self.gearShifter2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.gearShifter2#index"));

local rotationPartNoderuchkaR = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ruchkaR#index"));

    if rotationPartNoderuchkaR ~= nil then
        self.rotationPartruchkaR = {};
        self.rotationPartruchkaR.node = rotationPartNoderuchkaR;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.ruchkaR#minRot"));
        self.rotationPartruchkaR.minRot = {};
        self.rotationPartruchkaR.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartruchkaR.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartruchkaR.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.ruchkaR#maxRot"));
        self.rotationPartruchkaR.maxRot = {};
        self.rotationPartruchkaR.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartruchkaR.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartruchkaR.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartruchkaR.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.ruchkaR#rotTime"), 2)*1000;
        self.rotationPartruchkaR.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.ruchkaR#touchRotLimit"), 10));
    end;


    	local stekloLNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.stekloL#index"));
    if stekloLNode ~= nil then
        self.stekloL = {};
        self.stekloL.node = stekloLNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stekloL#minTrans"));
        self.stekloL.minTrans = {};
        self.stekloL.minTrans[1] = Utils.getNoNil(x, 0);
        self.stekloL.minTrans[2] = Utils.getNoNil(y, 0);
        self.stekloL.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stekloL#maxTrans"));
        self.stekloL.maxTrans = {};
        self.stekloL.maxTrans[1] = Utils.getNoNil(x, 0);
        self.stekloL.maxTrans[2] = Utils.getNoNil(y, 0);
        self.stekloL.maxTrans[3] = Utils.getNoNil(z, 0);

        self.stekloL.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.stekloL#transTime"), 2)*1000;
        self.stekloL.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.stekloL#touchTransLimit"), 10);
    end;

	local stekloRNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.stekloR#index"));
    if stekloRNode ~= nil then
        self.stekloR = {};
        self.stekloR.node = stekloRNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stekloR#minTrans"));
        self.stekloR.minTrans = {};
        self.stekloR.minTrans[1] = Utils.getNoNil(x, 0);
        self.stekloR.minTrans[2] = Utils.getNoNil(y, 0);
        self.stekloR.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.stekloR#maxTrans"));
        self.stekloR.maxTrans = {};
        self.stekloR.maxTrans[1] = Utils.getNoNil(x, 0);
        self.stekloR.maxTrans[2] = Utils.getNoNil(y, 0);
        self.stekloR.maxTrans[3] = Utils.getNoNil(z, 0);

        self.stekloR.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.stekloR#transTime"), 2)*1000;
        self.stekloR.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.stekloR#touchTransLimit"), 10);
    end;

local rotationPartNodemotortr = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.motortr#index"));
   	if rotationPartNodemotortr ~= nil then
        self.rotationPartmotortr = {};
        self.rotationPartmotortr.node = rotationPartNodemotortr;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.motortr#minRot"));
        self.rotationPartmotortr.minRot = {};
        self.rotationPartmotortr.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmotortr.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmotortr.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.motortr#maxRot"));
        self.rotationPartmotortr.maxRot = {};
        self.rotationPartmotortr.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmotortr.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmotortr.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartmotortr.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.motortr#rotTime"), 2)*1000;
        self.rotationPartmotortr.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.motortr#touchRotLimit"), 10));
    end;

		self.motortzznach = 80;

local rotationPartNodestrelka4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.strelka4#index"));

    if rotationPartNodestrelka4 ~= nil then
        self.rotationPartstrelka4 = {};
        self.rotationPartstrelka4.node = rotationPartNodestrelka4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.strelka4#minRot"));
        self.rotationPartstrelka4.minRot = {};
        self.rotationPartstrelka4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartstrelka4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartstrelka4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.strelka4#maxRot"));
        self.rotationPartstrelka4.maxRot = {};
        self.rotationPartstrelka4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartstrelka4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartstrelka4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartstrelka4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.strelka4#rotTime"), 2)*1000;
        self.rotationPartstrelka4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.strelka4#touchRotLimit"), 10));
    end;

local rotationPartNodestrelka3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.strelka3#index"));

    if rotationPartNodestrelka3 ~= nil then
        self.rotationPartstrelka3 = {};
        self.rotationPartstrelka3.node = rotationPartNodestrelka3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.strelka3#minRot"));
        self.rotationPartstrelka3.minRot = {};
        self.rotationPartstrelka3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartstrelka3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartstrelka3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.strelka3#maxRot"));
        self.rotationPartstrelka3.maxRot = {};
        self.rotationPartstrelka3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartstrelka3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartstrelka3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartstrelka3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.strelka3#rotTime"), 2)*1000;
        self.rotationPartstrelka3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.strelka3#touchRotLimit"), 10));
    end;


local rotationPartNodestrelka2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.strelka2#index"));

    if rotationPartNodestrelka2 ~= nil then
        self.rotationPartstrelka2 = {};
        self.rotationPartstrelka2.node = rotationPartNodestrelka2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.strelka2#minRot"));
        self.rotationPartstrelka2.minRot = {};
        self.rotationPartstrelka2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartstrelka2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartstrelka2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.strelka2#maxRot"));
        self.rotationPartstrelka2.maxRot = {};
        self.rotationPartstrelka2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartstrelka2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartstrelka2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartstrelka2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.strelka2#rotTime"), 2)*1000;
        self.rotationPartstrelka2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.strelka2#touchRotLimit"), 10));
    end;


local rotationPartNodestrelka1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.strelka1#index"));

    if rotationPartNodestrelka1 ~= nil then
        self.rotationPartstrelka1 = {};
        self.rotationPartstrelka1.node = rotationPartNodestrelka1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.strelka1#minRot"));
        self.rotationPartstrelka1.minRot = {};
        self.rotationPartstrelka1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartstrelka1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartstrelka1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.strelka1#maxRot"));
        self.rotationPartstrelka1.maxRot = {};
        self.rotationPartstrelka1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartstrelka1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartstrelka1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartstrelka1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.strelka1#rotTime"), 2)*1000;
        self.rotationPartstrelka1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.strelka1#touchRotLimit"), 10));
    end;

    local rotationPartNodeDrehzahl1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tahometr1#index"));
    if rotationPartNodeDrehzahl1 ~= nil then
        self.tahometr1 = {};
        self.tahometr1.node = rotationPartNodeDrehzahl1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tahometr1#minRot"));
        self.tahometr1.minRot = {};
        self.tahometr1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tahometr1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tahometr1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tahometr1#maxRot"));
        self.tahometr1.maxRot = {};
        self.tahometr1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tahometr1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tahometr1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.tahometr1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tahometr1#rotTime"), 2)*1000;
        self.tahometr1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tahometr1#touchRotLimit"), 10));
    end;

self.controlpath = Utils.getFilename("menu.png", self.baseDirectory);

self.hudfurazhirWidth = 0.700;
    self.hudfurazhirHeight = 0.320;
    self.hudfurazhirPoxX = 0;
    self.hudfurazhirPoxY = 0;
    self.hudfurazhirOverlay = Overlay:new("hudfurazhir", self.controlpath, self.hudfurazhirPoxX, self.hudfurazhirPoxY, self.hudfurazhirWidth, self.hudfurazhirHeight);

	 local rotationPartNodepravDoor = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pravDoor#index"));
    if rotationPartNodepravDoor ~= nil then
        self.rotationPartpravDoor = {};
        self.rotationPartpravDoor.node = rotationPartNodepravDoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartpravDoor#minRot"));
        self.rotationPartpravDoor.minRot = {};
        self.rotationPartpravDoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartpravDoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartpravDoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.pravDoor#maxRot"));
        self.rotationPartpravDoor.maxRot = {};
        self.rotationPartpravDoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartpravDoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartpravDoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartpravDoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.pravDoor#rotTime"), 2)*1000;
        self.rotationPartpravDoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.pravDoor#touchRotLimit"), 10));
    end;

   local rotationPartNodelevDoor = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.levDoor#index"));
    if rotationPartNodelevDoor ~= nil then
        self.rotationPartlevDoor = {};
        self.rotationPartlevDoor.node = rotationPartNodelevDoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartlevDoor#minRot"));
        self.rotationPartlevDoor.minRot = {};
        self.rotationPartlevDoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartlevDoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartlevDoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.levDoor#maxRot"));
        self.rotationPartlevDoor.maxRot = {};
        self.rotationPartlevDoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartlevDoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartlevDoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartlevDoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.levDoor#rotTime"), 2)*1000;
        self.rotationPartlevDoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.levDoor#touchRotLimit"), 10));
    end;

	numparts2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.parts2#count"), 0);
	self.parts2 = {};
    for i=1, numparts2 do
        local partnamei = string.format("vehicle.parts2.part%d", i);
        self.parts2[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
        setVisibility(self.parts2[i], false);
    end;
	self.parts2Active = false;

	self.kardan1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kadranu.kardan1#index"));
	self.kardan2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kadranu.kardan2#index"));

	self.RotPoint = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kadranu.RotPoint#index"));

     local rotationPartNodelevpodn = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.levpodn#index"));
    if rotationPartNodelevpodn ~= nil then
        self.rotationPartlevpodn = {};
        self.rotationPartlevpodn.node = rotationPartNodelevpodn;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartlevpodn#minRot"));
        self.rotationPartlevpodn.minRot = {};
        self.rotationPartlevpodn.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartlevpodn.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartlevpodn.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.levpodn#maxRot"));
        self.rotationPartlevpodn.maxRot = {};
        self.rotationPartlevpodn.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartlevpodn.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartlevpodn.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartlevpodn.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.levpodn#rotTime"), 2)*1000;
        self.rotationPartlevpodn.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.levpodn#touchRotLimit"), 10));
    end;
	
	 local rotationPartNodepravpodn = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pravpodn#index"));
    if rotationPartNodepravpodn ~= nil then
        self.rotationPartpravpodn = {};
        self.rotationPartpravpodn.node = rotationPartNodepravpodn;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartpravpodn#minRot"));
        self.rotationPartpravpodn.minRot = {};
        self.rotationPartpravpodn.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartpravpodn.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartpravpodn.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.pravpodn#maxRot"));
        self.rotationPartpravpodn.maxRot = {};
        self.rotationPartpravpodn.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartpravpodn.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartpravpodn.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartpravpodn.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.pravpodn#rotTime"), 2)*1000;
        self.rotationPartpravpodn.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.pravpodn#touchRotLimit"), 10));
    end;
	local rotationPartNodeteto = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.teto#index"));
    if rotationPartNodeteto ~= nil then
        self.rotationPartteto = {};
        self.rotationPartteto.node = rotationPartNodeteto;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartteto#minRot"));
        self.rotationPartteto.minRot = {};
        self.rotationPartteto.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartteto.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartteto.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.teto#maxRot"));
        self.rotationPartteto.maxRot = {};
        self.rotationPartteto.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartteto.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartteto.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartteto.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.teto#rotTime"), 2)*1000;
        self.rotationPartteto.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.teto#touchRotLimit"), 10));
    end;
	local rotationPartNodeabl1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.abl1#index"));
    if rotationPartNodeabl1 ~= nil then
        self.rotationPartabl1 = {};
        self.rotationPartabl1.node = rotationPartNodeabl1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartabl1#minRot"));
        self.rotationPartabl1.minRot = {};
        self.rotationPartabl1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl1#maxRot"));
        self.rotationPartabl1.maxRot = {};
        self.rotationPartabl1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartabl1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl1#rotTime"), 2)*1000;
        self.rotationPartabl1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl1#touchRotLimit"), 10));
    end;
    local rotationPartNodeabl2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.abl2#index"));
    if rotationPartNodeabl2 ~= nil then
        self.rotationPartabl2 = {};
        self.rotationPartabl2.node = rotationPartNodeabl2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartabl2#minRot"));
        self.rotationPartabl2.minRot = {};
        self.rotationPartabl2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl2#maxRot"));
        self.rotationPartabl2.maxRot = {};
        self.rotationPartabl2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartabl2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl2#rotTime"), 2)*1000;
        self.rotationPartabl2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl2#touchRotLimit"), 10));
    end;
    local rotationPartNodehidra1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hidra1#index"));
    if rotationPartNodehidra1 ~= nil then
        self.rotationParthidra1 = {};
        self.rotationParthidra1.node = rotationPartNodehidra1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParthidra1#minRot"));
        self.rotationParthidra1.minRot = {};
        self.rotationParthidra1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hidra1#maxRot"));
        self.rotationParthidra1.maxRot = {};
        self.rotationParthidra1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationParthidra1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra1#rotTime"), 2)*1000;
        self.rotationParthidra1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra1#touchRotLimit"), 10));
    end;
        local rotationPartNodehidra2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hidra2#index"));
    if rotationPartNodehidra2 ~= nil then
        self.rotationParthidra2 = {};
        self.rotationParthidra2.node = rotationPartNodehidra2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParthidra2#minRot"));
        self.rotationParthidra2.minRot = {};
        self.rotationParthidra2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hidra2#maxRot"));
        self.rotationParthidra2.maxRot = {};
        self.rotationParthidra2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationParthidra2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra2#rotTime"), 2)*1000;
        self.rotationParthidra2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra2#touchRotLimit"), 10));
    end;
      local rotationPartNodehidra3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hidra3#index"));
    if rotationPartNodehidra3 ~= nil then
        self.rotationParthidra3 = {};
        self.rotationParthidra3.node = rotationPartNodehidra3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParthidra3#minRot"));
        self.rotationParthidra3.minRot = {};
        self.rotationParthidra3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hidra3#maxRot"));
        self.rotationParthidra3.maxRot = {};
        self.rotationParthidra3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationParthidra3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra3#rotTime"), 2)*1000;
        self.rotationParthidra3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra3#touchRotLimit"), 10));
    end;

end;

function T150:readStream(streamId, connection)
end;

function T150:writeStream(streamId, connection)
end;

function T150:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym ==  (self.keys.ruchnik) then
		self.handbrake = not self.handbrake;
		self.rotationMaxruchnik = not self.rotationMaxruchnik;
	end;

	if self.isEntered then
	if sym == Input.KEY_KP_7 then
		self.stekloLMax = isDown;
	end;
	if sym == Input.KEY_KP_4 then
		self.stekloLMin = isDown;
	end;
	if sym == Input.KEY_KP_9 then
		self.stekloRMax = isDown;
		self.rotationPartruchkaRMax = isDown;
	end;
	if sym == Input.KEY_KP_6 then
		self.stekloRMin = isDown;
		self.rotationPartruchkaRMin = isDown;
	end;
      end;
end;


function T150:update(dt)

	if self.isEntered then
			if InputBinding.hasEvent (InputBinding.hudgear) then
				self.hudgearactivate = not self.hudgearactivate;
			end;
	end;	

if self.isEntered then
	if self.handbrake then
		setTextBold(true);
		setTextColor(1,0,0,1);
		if self.input == -1 then
			setTextBold(true);
			setTextColor(1,0,0,1);
			renderText(0.3, 0.3, 0.05, "Handbrake ON!");
		end;
end;
end;

	if self.isMotorStarted then
         		rotate(self.ventelator1, 0, 0, dt*0.01 );		
	end;

	if self.rotationPartruchnik  ~= nil then
		local x, y, z = getRotation(self.rotationPartruchnik .node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartruchnik.maxRot, self.rotationPartruchnik.minRot, 3, self.rotationPartruchnik.rotTime, dt, not self.rotationMaxruchnik);
		setRotation(self.rotationPartruchnik .node, unpack(newRot));
	end;

if self.isEntered then
	if self.handbrake then
		self.motor.backwardGearRatio = 0;
		self.motor.forwardGearRatios = {0, 0, 0};
		self.motor.brakeForce = 100;
	else
		self.motor.backwardGearRatio = 18;
		self.motor.forwardGearRatios = {18, 18, 18};
	end;
end;

	local speed = self.lastSpeed*3600;
     if self.gearShifter2 ~= nil then
          if self.movingDirection < 0 then
               setRotation(self.gearShifter2, Utils.degToRad(-10), Utils.degToRad(0), Utils.degToRad(10));
				self.bcActiveN = false;
				self.bcActiveZ = true;
				self.bcActive2d = false;
				self.bcActive1p = false;
				self.bcActive2p = false;
				self.bcActive3p = false;
				self.bcActive4p = false;
          else     
          if speed >= -0.5 and speed < 0.5 then
               setRotation(self.gearShifter2, Utils.degToRad(0), Utils.degToRad(0), Utils.degToRad(0));
				self.bcActiveN = true;
				self.bcActiveZ = false;
				self.bcActive2d = false;
          elseif speed >= 0.5 then
               setRotation(self.gearShifter2, Utils.degToRad(-10), Utils.degToRad(0), Utils.degToRad(-10));
				self.bcActiveN = false;
				self.bcActiveZ = false;
				self.bcActive2d = true;
          end;
     end;
  end;

     if self.gearShifter ~= nil then
          if speed < 0.5 then
               setRotation(self.gearShifter, Utils.degToRad(-30), Utils.degToRad(0), Utils.degToRad(0));
          else     
--0--
          if speed >= -0.5 and speed < 0.5 then
               setRotation(self.gearShifter, Utils.degToRad(-30), Utils.degToRad(0), Utils.degToRad(0));
				self.bcActive1p = false;
				self.bcActive2p = false;
				self.bcActive3p = false;
				self.bcActive4p = false;
--1---
          elseif speed >= 0.5 and speed <8 then
               setRotation(self.gearShifter, Utils.degToRad(-15), Utils.degToRad(0), Utils.degToRad(0));
				self.bcActive1p = true;
				self.bcActive2p = false;
				self.bcActive3p = false;
				self.bcActive4p = false;
--2---
          elseif speed >= 8 and speed < 16 then
               setRotation(self.gearShifter, Utils.degToRad(0), Utils.degToRad(0), Utils.degToRad(0));
				self.bcActive1p = false;
				self.bcActive2p = true;
				self.bcActive3p = false;
				self.bcActive4p = false;
--3---	

          elseif speed >= 16 and speed < 24 then
               setRotation(self.gearShifter, Utils.degToRad(15), Utils.degToRad(0), Utils.degToRad(0));
				self.bcActive1p = false;
				self.bcActive2p = false;
				self.bcActive3p = true;
				self.bcActive4p = false;
--4---
          elseif speed >= 24 then
               setRotation(self.gearShifter, Utils.degToRad(30), Utils.degToRad(0), Utils.degToRad(0));
				self.bcActive1p = false;
				self.bcActive2p = false;
				self.bcActive3p = false;
				self.bcActive4p = true;
--Back---
          elseif speed < -0.5 then
               setRotation(self.gearShifter, Utils.degToRad(-30), Utils.degToRad(0), Utils.degToRad(0));
-- -1---
          elseif speed <= -0.5 and speed > -8 then
               setRotation(self.gearShifter, Utils.degToRad(-15), Utils.degToRad(0), Utils.degToRad(0));
-- -2---
          elseif speed <= -8 and speed > -16 then
               setRotation(self.gearShifter, Utils.degToRad(0), Utils.degToRad(0), Utils.degToRad(0));
-- -3---
          elseif speed <= -16 and speed > -24 then
               setRotation(self.gearShifter, Utils.degToRad(15), Utils.degToRad(0), Utils.degToRad(0));
-- -4---
          elseif speed <= -24 then
               setRotation(self.gearShifter, Utils.degToRad(30), Utils.degToRad(0), Utils.degToRad(0));
          end;
     end;
  end;

	if self.isEntered then
		if InputBinding.isPressed(InputBinding.t150_windr1) then
			self:setAnimationTime(1, self.animationParts[1].currentPosition+(self.animationParts[1].offSet+dt), false);
		elseif InputBinding.isPressed(InputBinding.t150_windr2) then
			self:setAnimationTime(1, self.animationParts[1].currentPosition-(self.animationParts[1].offSet+dt), false);
		end;

		if InputBinding.isPressed(InputBinding.t150_windl1) then
			self:setAnimationTime(2, self.animationParts[2].currentPosition+(self.animationParts[2].offSet+dt), false);
		elseif InputBinding.isPressed(InputBinding.t150_windl2) then
			self:setAnimationTime(2, self.animationParts[2].currentPosition-(self.animationParts[2].offSet+dt), false);
		end;
		if InputBinding.isPressed(InputBinding.mehrRPM) then
			self:setAnimationTime(3, self.animationParts[3].currentPosition+(self.animationParts[3].offSet+dt), false);
		elseif InputBinding.isPressed(InputBinding.wenigerRPM) then
			self:setAnimationTime(3, self.animationParts[3].currentPosition-(self.animationParts[3].offSet+dt), false);
		end;
	end;

	local doRotate =  self.rotationPartruchkaRMax or self.rotationPartruchkaRMin 
	if self.rotationPartruchkaR ~= nil and doRotate then 
		local x, y, z = getRotation(self.rotationPartruchkaR.node); 
		local rot = {x,y,z}; 
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartruchkaR.maxRot, self.rotationPartruchkaR.minRot, 3, self.rotationPartruchkaR.rotTime, dt, not self.rotationMaxruchkaR);
		setRotation(self.rotationPartruchkaR.node, unpack(newRot));
	end; 

	local doTranslate = self.stekloLMax or self.stekloLMin 
	if self.stekloL ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.stekloL.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.stekloL.maxTrans, self.stekloL.minTrans, 3, self.stekloL.transTime, dt, not self.stekloLMax); 
		setTranslation(self.stekloL.node, unpack(newTrans));
	end; 

	local doTranslate = self.stekloRMax or self.stekloRMin 
	if self.stekloR ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.stekloR.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.stekloR.maxTrans, self.stekloR.minTrans, 3, self.stekloR.transTime, dt, not self.stekloRMax); 
		setTranslation(self.stekloR.node, unpack(newTrans));
     end;	

	if self.isMotorStarted then
		self.motortrprov = not self.motortrprov;
	end;

	if self.isMotorStarted then
if self.rotationPartmotortr ~= nil then
		local x, y, z = getRotation(self.rotationPartmotortr.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartmotortr.maxRot, self.rotationPartmotortr.minRot, 3, self.rotationPartmotortr.rotTime, dt, self.motortnnach1);
		setRotation(self.rotationPartmotortr.node, unpack(newRot));
  	 end;
  	 end;

	   if self.motortrprov then
		self.motortzznach = self.motortzznach - dt;
		if self.motortzznach < 0 then
			self.motortnnach1 = not self.motortnnach1;
			self.motortzznach = 80;
		end;
	end;

	if self.rotationPartstrelka1 ~= nil then
		local x, y, z = getRotation(self.rotationPartstrelka1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartstrelka1.maxRot, self.rotationPartstrelka1.minRot, 3, self.rotationPartstrelka1.rotTime, dt, not self.rotationMaxstrelka1);
		setRotation(self.rotationPartstrelka1.node, unpack(newRot));
	end;

	if self.rotationPartstrelka2 ~= nil then
		local x, y, z = getRotation(self.rotationPartstrelka2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartstrelka2.maxRot, self.rotationPartstrelka2.minRot, 3, self.rotationPartstrelka2.rotTime, dt, not self.rotationMaxstrelka2);
		setRotation(self.rotationPartstrelka2.node, unpack(newRot));
	end;

	if self.rotationPartstrelka3 ~= nil then
		local x, y, z = getRotation(self.rotationPartstrelka3.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartstrelka3.maxRot, self.rotationPartstrelka3.minRot, 3, self.rotationPartstrelka3.rotTime, dt, not self.rotationMaxstrelka3);
		setRotation(self.rotationPartstrelka3.node, unpack(newRot));
	end;

	if self.rotationPartstrelka4 ~= nil then
		local x, y, z = getRotation(self.rotationPartstrelka4.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartstrelka4.maxRot, self.rotationPartstrelka4.minRot, 3, self.rotationPartstrelka4.rotTime, dt, not self.rotationMaxstrelka4);
		setRotation(self.rotationPartstrelka4.node, unpack(newRot));
	end;

	if self.isMotorStarted then
	local maxDrehzahl = 2000;
			if self.tahometr1 ~= nil then
				local x, y, z = getRotation(self.tahometr1.node);
				y = ((self.tahometr1.maxRot[2] - self.tahometr1.minRot[2]) / maxDrehzahl) * self.motor.lastMotorRpm + self.tahometr1.minRot[2];
				setRotation(self.tahometr1.node, x, y ,z);
			end;
	else
			setRotation(self.tahometr1.node, 0, 0 ,0);
	end;

	if self.isEntered then
			if InputBinding.hasEvent (InputBinding.INFOHUD) then
				self.bcActive = not self.bcActive;
			end;
	end;	

   if self.parts2Active then
		for i=1, numparts2 do
			setVisibility(self.parts2[i], self.parts2Active);
		end;
	        else
		for i=1, numparts2 do
			setVisibility(self.parts2[i], self.parts2Active, false);
	    end;	
    end;

	if self.isMotorStarted then
	   self.PointRot = getRotation(self.RotPoint)

       setRotation(self.kardan1,0 ,0 ,self.PointRot);
       setRotation(self.kardan2,0 ,0 ,self.PointRot);
	   end;

if self.inrange then
	if InputBinding.hasEvent (InputBinding.rehotka_t150) then
		self.parts2Active = not self.parts2Active;
	end;
	if InputBinding.hasEvent (InputBinding.pravpodn_t150) then
		self.rotationMaxpravpodn = not self.rotationMaxpravpodn;
	end;
	if InputBinding.hasEvent (InputBinding.levpodn_t150) then
		self.rotationMaxlevpodn = not self.rotationMaxlevpodn;
	end;
end;

if self.inrange or self.isEntered then
	if InputBinding.hasEvent (InputBinding.levDoor_t150) then
		self.rotationMaxlevDoor = not self.rotationMaxlevDoor;
	end;
	if InputBinding.hasEvent (InputBinding.pravDoor_t150) then
		self.rotationMaxpravDoor = not self.rotationMaxpravDoor;
	end;
end;

	if self.isEntered then
		if self.bcActive then	
			g_currentMission:addHelpButtonText(g_i18n:getText("OFF_HUD_t150"), InputBinding.INFOHUD);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("ON_HUD_t150"), InputBinding.INFOHUD);
		end;  
	end;	

	if self.inrange then

		if self.parts2Active then
			g_currentMission:addHelpButtonText(g_i18n:getText("reshpodn_t150_n1"), InputBinding.rehotka_t150);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("reshpodn_t150_n2"), InputBinding.rehotka_t150);
		end;

		if self.rotationMaxpravpodn then
			g_currentMission:addHelpButtonText(g_i18n:getText("pravpodn_t150_n1"), InputBinding.pravpodn_t150);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("pravpodn_t150_n2"), InputBinding.pravpodn_t150);
		end;

		if self.rotationMaxlevpodn then
			g_currentMission:addHelpButtonText(g_i18n:getText("levpodn_t150_n1"), InputBinding.levpodn_t150);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("levpodn_t150_n2"), InputBinding.levpodn_t150);
		end;

	end;	

	if self.inrange or self.isEntered then
		if self.rotationMaxlevDoor then
			g_currentMission:addHelpButtonText(g_i18n:getText("levDoor_t150_n1"), InputBinding.levDoor_t150);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("levDoor_t150_n2"), InputBinding.levDoor_t150);
		end;

		if self.rotationMaxpravDoor then
			g_currentMission:addHelpButtonText(g_i18n:getText("pravDoor_t150_n1"), InputBinding.pravDoor_t150);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("pravDoor_t150_n2"), InputBinding.pravDoor_t150);
		end;
	end;	

        if self.rotationPartpravDoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartpravDoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartpravDoor.maxRot, self.rotationPartpravDoor.minRot, 3, self.rotationPartpravDoor.rotTime, dt, not self.rotationMaxpravDoor);
		   setRotation(self.rotationPartpravDoor.node, unpack(newRot));
        end;

	    if self.rotationPartlevDoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartlevDoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartlevDoor.maxRot, self.rotationPartlevDoor.minRot, 3, self.rotationPartlevDoor.rotTime, dt, not self.rotationMaxlevDoor);
		   setRotation(self.rotationPartlevDoor.node, unpack(newRot));
        end;

	    if self.rotationPartbackwindow ~= nil then
		   local x, y, z = getRotation(self.rotationPartbackwindow.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbackwindow.maxRot, self.rotationPartbackwindow.minRot, 3, self.rotationPartbackwindow.rotTime, dt, not self.rotationMaxbackwindow);
		   setRotation(self.rotationPartbackwindow.node, unpack(newRot));
        end;

        if self.rotationPartpravpodn ~= nil then
		   local x, y, z = getRotation(self.rotationPartpravpodn.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartpravpodn.maxRot, self.rotationPartpravpodn.minRot, 3, self.rotationPartpravpodn.rotTime, dt, not self.rotationMaxpravpodn);
		   setRotation(self.rotationPartpravpodn.node, unpack(newRot));
        end;
    
       if self.rotationPartteto ~= nil then
		   local x, y, z = getRotation(self.rotationPartteto.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartteto.maxRot, self.rotationPartteto.minRot, 3, self.rotationPartteto.rotTime, dt, not self.rotationMaxteto);
		   setRotation(self.rotationPartteto.node, unpack(newRot));
        end;
        
	    if self.rotationPartlevpodn ~= nil then
		   local x, y, z = getRotation(self.rotationPartlevpodn.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartlevpodn.maxRot, self.rotationPartlevpodn.minRot, 3, self.rotationPartlevpodn.rotTime, dt, not self.rotationMaxlevpodn);
		   setRotation(self.rotationPartlevpodn.node, unpack(newRot));
        end;
		if self.rotationPartabl1 ~= nil then
		   local x, y, z = getRotation(self.rotationPartabl1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartabl1.maxRot, self.rotationPartabl1.minRot, 3, self.rotationPartabl1.rotTime, dt, not self.rotationMaxabl1);
		   setRotation(self.rotationPartabl1.node, unpack(newRot));
        end;
        if self.rotationPartabl2 ~= nil then
		   local x, y, z = getRotation(self.rotationPartabl2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartabl2.maxRot, self.rotationPartabl2.minRot, 3, self.rotationPartabl2.rotTime, dt, not self.rotationMaxabl2);
		   setRotation(self.rotationPartabl2.node, unpack(newRot));
        end;
        if self.rotationParthidra1 ~= nil then
		   local x, y, z = getRotation(self.rotationParthidra1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationParthidra1.maxRot, self.rotationParthidra1.minRot, 3, self.rotationParthidra1.rotTime, dt, not self.rotationMaxhidra1);
		   setRotation(self.rotationParthidra1.node, unpack(newRot));
        end;
        if self.rotationParthidra2 ~= nil then
		   local x, y, z = getRotation(self.rotationParthidra2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationParthidra2.maxRot, self.rotationParthidra2.minRot, 3, self.rotationParthidra2.rotTime, dt, not self.rotationMaxhidra2);
		   setRotation(self.rotationParthidra2.node, unpack(newRot));
        end;
        if self.rotationParthidra3 ~= nil then
		   local x, y, z = getRotation(self.rotationParthidra3.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationParthidra3.maxRot, self.rotationParthidra3.minRot, 3, self.rotationParthidra3.rotTime, dt, not self.rotationMaxhidra3);
		   setRotation(self.rotationParthidra3.node, unpack(newRot));
	
end;

end;

function T150:updateTick(dt)

if g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement 
		local nearestDistance = 6.0; --max distance allowed
		local px, py, pz = getWorldTranslation(self.rootNode); 
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.inrange = true; 
		else
			self.inrange = false; 
		end;
	end;
end;

function T150:draw()

	if self.hudgearactivate then
if self.isEntered then
 	 if self.hudGeargearhud1Overlay ~= nil then
    self.hudGeargearhud1Overlay:render();
end;
end;

if self.isEntered then
 	 if self.hudGear4pOverlay ~= nil then
  if self.bcActive4p then
    self.hudGear4pOverlay:render();
  end;
end;
end;

if self.isEntered then
 	 if self.hudGear3pOverlay ~= nil then
  if self.bcActive3p then
    self.hudGear3pOverlay:render();
  end;
end;
end;

if self.isEntered then
 	 if self.hudGear2pOverlay ~= nil then
  if self.bcActive2p then
    self.hudGear2pOverlay:render();
  end;
end;
end;

if self.isEntered then
 	 if self.hudGear1pOverlay ~= nil then
  if self.bcActive1p then
    self.hudGear1pOverlay:render();
  end;
end;
end;

if self.isEntered then
 	 if self.hudGear2dOverlay ~= nil then
  if self.bcActive2d then
    self.hudGear2dOverlay:render();
  end;
end;
end;

if self.isEntered then
 	 if self.hudGearZOverlay ~= nil then
  if self.bcActiveZ then
    self.hudGearZOverlay:render();
  end;
end;
end;

if self.isEntered then
 	 if self.hudGear1p2dOverlay ~= nil then
  if self.bcActive1p2d then
    self.hudGear1p2dOverlay:render();
  end;
end;
end;

if self.isEntered then
 	 if self.hudGearNOverlay ~= nil then
  if self.bcActiveN then
    self.hudGearNOverlay:render();
  end;
end;
end;
end;
if self.isEntered then
 	 if self.hudfurazhirOverlay ~= nil then
  if self.bcActive then
    self.hudfurazhirOverlay:render();
  end;
end;
end;
end;


function T150:onLeave()
end;

function T150:delete()   
end;


function T150:mouseEvent(posX, posY, isDown, isUp, button)
end;

function key_convert(key)
    if key ~= nil then 
	    local keyname = "";
	    if key > 32 and key < 123 then
	    	keyname = string.upper(string.char(key));
	    elseif key > 255 and key < 266 then
	    	keyname = "NUM "..string.char(key-208);
	    else 
	    	keyname = "";
	    end;
	    return(keyname);
	  end;
end;
