--
-- AllradV2
-- Specialization for Allrad
--
-- by modelleicher
-- www.schwabenmodding.bplaced.net
-- MP Fhig!


Traction4x4 = {};

function Traction4x4.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Traction4x4:load(xmlFile)

    self.allradState = Traction4x4.allradState;

    self.Traction4x4Active = false;
	 
	self.wellenCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Allradwellen.Wellen#count"), 0);	 
	self.Wellen = {}
	if self.wellenCount ~= 0 and self.wellenCount ~= nil then
	    for i=1, self.wellenCount do
	        local Welle = string.format("vehicle.Allradwellen.Welle%d", i)
		    self.Wellen[i] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, Welle .. "#index"));
	    end;
	end;
	self.hudAllradonPosX = 0.68;
    self.hudAllradonWidth = 0.08;
    self.hudAllradonPosY = 0.015;
    self.hudAllradonHeight = 0.195;
	
	self.infoPanelAllradPath = Utils.getFilename("Textures/traction_on.png", self.baseDirectory);
	self.hudAllradonOverlay = Overlay:new("Textures/traction_on", self.infoPanelAllradPath, self.hudAllradonPosX, self.hudAllradonPosY, self.hudAllradonWidth, self.hudAllradonHeight);
	
	self.infoPanelAllradPath1 = Utils.getFilename("Textures/traction_off.png", self.baseDirectory);
	self.hudAllradoffOverlay = Overlay:new("Textures/traction_off", self.infoPanelAllradPath1, self.hudAllradonPosX, self.hudAllradonPosY, self.hudAllradonWidth, self.hudAllradonHeight);	
	
	self.showhudAllradon = false;

end;

function Traction4x4:delete()
    if self.hudAllradonOverlay ~= nil then
		self.hudAllradonOverlay:delete();
	end;
	if self.hudAllradonOverlay ~= nil then
		self.hudAllradoffOverlay:delete();
	end;
end;

function Traction4x4:readStream(streamId, connection)  
     self:allradState(streamReadBool(streamId), true);  
end;

function Traction4x4:writeStream(streamId, connection)  
    streamWriteBool(streamId, self.Traction4x4Active);  
end;

function Traction4x4:mouseEvent(posX, posY, isDown, isUp, button)
end;
function Traction4x4:keyEvent(unicode, sym, modifier, isDown)
end;

function Traction4x4:allradState(state, noEventSend)  
    AllradStateEvent.sendEvent(self, state, noEventSend);	
    self.Traction4x4Active = state;
end;

function Traction4x4:update(dt)
    if self:getIsActiveForInput() then  
		if InputBinding.hasEvent(InputBinding.Traction4x4) then
		   	self.Traction4x4Active = not self.Traction4x4Active;
		end;
    end;	
	if self:getIsActive() then	
   		if self.Traction4x4Active == true then
			self.showhudAllradon = true;
			self.showhudAllradoff = false;			
			self.wheels[1].driveMode =2
		 	self.wheels[2].driveMode =2
		 	self.wheels[3].driveMode =2
		 	self.wheels[4].driveMode =2			
		else
			self.showhudAllradon = false;
			self.showhudAllradoff = true;
		 	self.wheels[1].driveMode =0
			self.wheels[2].driveMode =0
			self.wheels[3].driveMode =2
			self.wheels[4].driveMode =2			
		end; 
	    if self.wellenCount ~= 0 and self.wellenCount ~= nil then
	      local getRx, getRy, getRz = getRotation(self.wheels[3].repr);
	      for i=1, self.wellenCount do
	         setRotation(self.Wellen[i], 0, 0, getRx);
	      end;
	    end;		
    end; 
end;

function Traction4x4:draw()
   if self.showhudAllradon == true then
      	self.hudAllradonOverlay:render();
	end;
   if self.showhudAllradoff == true then
      	self.hudAllradoffOverlay:render();
	end;
end;

AllradStateEvent = {};
AllradStateEvent_mt = Class(AllradStateEvent, Event);

InitEventClass(AllradStateEvent, "AllradStateEvent");

function AllradStateEvent:emptyNew() 
    local self = Event:new(AllradStateEvent_mt );
    self.className="AllradStateEvent";
    return self;
end;

function AllradStateEvent:new(vehicle, state) 
    self.vehicle = vehicle;
    self.state = state;
    return self;
end;

function AllradStateEvent:readStream(streamId, connection)  
    local id = streamReadInt32(streamId); 
    self.state = streamReadBool(streamId); 
    self.vehicle = networkGetObject(id); 
    self:run(connection);  
end;

function AllradStateEvent:writeStream(streamId, connection)   
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
    streamWriteBool(streamId, self.state );   
end;

function AllradStateEvent:run(connection)  
    self.vehicle:allradState(self.state, true);
	if not connection:getIsServer() then  
		g_server:broadcastEvent(AllradStateEvent:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;

function AllradStateEvent.sendEvent(vehicle, state, noEventSend)  
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then  
			g_server:broadcastEvent(AllradStateEvent:new(vehicle, state), nil, nil, vehicle);
		else 
			g_client:getServerConnection():sendEvent(AllradStateEvent:new(vehicle, state));
		end;
	end;
end;

