--
-- Plane
-- Class for all Dolly Trailers
--
-- @author  Jack
-- @date  25/04/09
--
-- Copyright (C) Jack

Plane = {};

function Plane.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function Plane:load(xmlFile)
	

-- Plane
    self.plane = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.plane#index"));
	self.planeActive = false;

end;

function Plane:delete()   
end;


function Plane:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Plane:keyEvent(unicode, sym, modifier, isDown)
end;


function Plane:update(dt)

if self.inrange then
	if InputBinding.hasEvent(InputBinding.Kryshki) then
		self.planeActive = not self.planeActive;
	end;
end;	

-- Plane1 (anfang)
		if self.planeActive then
				local plane = self.plane;
				setVisibility(plane);
				
				local planeA = self.planeA;
				setVisibility(planeA, false);

		else
				local plane = self.plane;
				setVisibility(plane, false);

				local planeA = self.planeA;
				setVisibility(planeA);

		end;	


-- Plane1 (ende)	

end;

function Plane:updateTick(dt)

if g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement 
		local nearestDistance = 4.0; --max distance allowed
		local px, py, pz = getWorldTranslation(self.rootNode); 
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.inrange = true; 
		else
			self.inrange = false; 
		end;
end;
end;

function Plane:draw()
end;

function Plane:allowFillType(fillType)
end;

function Plane:anim(varName, loopCheck)
end; 	

function Plane:delete()
end;

function Plane:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Plane:connectCollisions(varName)
end;

function Plane:draw()
if self.inrange then
	if self.planeActive then 
		g_currentMission:addExtraPrintText("Taste X: chetki");
	else
		g_currentMission:addExtraPrintText("Taste X: chetki");
	end;
end;
end;


