--
-- AddAlternativeTriggerEvent
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date:		01/08/11
-- @version:	v1.0
-- @history:	v1.0 - initial implementation
--

AddAlternativeTriggerEvent = {};
AddAlternativeTriggerEvent_mt = Class(AddAlternativeTriggerEvent, Event);

AddAlternativeTriggerEvent.TRIGGER_CREATE = 0;
AddAlternativeTriggerEvent.TRIGGER_SEND = 1;
AddAlternativeTriggerEvent.TRIGGER_ACK = 2;
AddAlternativeTriggerEvent.NUM_BITS = 2;

InitEventClass(AddAlternativeTriggerEvent, "AddAlternativeTriggerEvent");

function AddAlternativeTriggerEvent:emptyNew()
    local self = Event:new(AddAlternativeTriggerEvent_mt);
    self.className="AddAlternativeTriggerEvent";
    return self;
end;

function AddAlternativeTriggerEvent:new(vehicle, eventType, triggerId)
    local self = AddAlternativeTriggerEvent:emptyNew()
    self.vehicle = vehicle;
	self.eventType = eventType;
	self.triggerId = triggerId;
    return self;
end;

function AddAlternativeTriggerEvent:readStream(streamId, connection)
	self.eventType = streamReadUIntN(streamId, AddAlternativeTriggerEvent.NUM_BITS);
    self.vehicle = networkGetObject(streamReadInt32(streamId));
	if self.eventType ~= AddAlternativeTriggerEvent.TRIGGER_CREATE then
		self.triggerId = streamReadInt32(streamId);		
	end;
    self:run(connection);
end;

function AddAlternativeTriggerEvent:writeStream(streamId, connection)
	streamWriteUIntN(streamId, self.eventType, AddAlternativeTriggerEvent.NUM_BITS);
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	if self.eventType ~= AddAlternativeTriggerEvent.TRIGGER_CREATE then
		streamWriteInt32(streamId, self.triggerId);	
	end;
end;

function AddAlternativeTriggerEvent:run(connection)
	if self.eventType == AddAlternativeTriggerEvent.TRIGGER_CREATE then
		local trigger = g_currentMission.alternativeTipTrigger:addNewTrigger(self.vehicle, false, false);		
	elseif self.eventType == AddAlternativeTriggerEvent.TRIGGER_SEND then
		local trigger = g_currentMission.alternativeTipTrigger:addNewTrigger(self.vehicle, true, true);
		g_client:finishRegisterObject(trigger, self.triggerId);
		connection:sendEvent(AddAlternativeTriggerEvent:new(self.vehicle, AddAlternativeTriggerEvent.TRIGGER_ACK, self.triggerId));			
	elseif self.eventType == AddAlternativeTriggerEvent.TRIGGER_ACK then
		local trigger = networkGetObject(self.triggerId);		
		g_server:finishRegisterObject(connection, trigger);		
	end;
end;

function AddAlternativeTriggerEvent.sendEvent(vehicle, eventType, triggerId, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(AddAlternativeTriggerEvent:new(vehicle, eventType, triggerId), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(AddAlternativeTriggerEvent:new(vehicle, eventType, triggerId));
		end;
	end;
end;