-- Author : WeeRuz
print("Script print: manySilo");
manySilo = {};



function manySilo:onCreate(id)
	
	manySilo:load(id);
	
end;


manySiloOnCreate = manySilo.onCreate;


function manySilo:load(id)

self.id = id;
	addTrigger(self.id, "manySiloCallback", self);
	print("Trigger id:"..self.id)
	self.hud = false;
	self.otherId = 0;
	self.triggerId = 0;
	self.fruitcnt = 0;
	self.currentFruit = 1;
	self.trailerFruits = {};
	self.fill = false;
	self.lockedFruit = 0;
	self.allowedFruits = {};
	self.fruitsToTrailer = {};
	self.fillFruit = FruitUtil.fruitTypeToFillType[self.currentFruit];
	self.setting = Utils.getNoNil(getUserAttribute(self.id, "setting"),"");
	if getUserAttribute(self.id,"fruitTypes") ~= "" then
	self.fruitTypes = getUserAttribute(self.id,"fruitTypes"):split(" ");
	else
	self.fruitTypes = {};
	end;
	if getUserAttribute(self.id,"ignoreList") ~= "" then
	self.ignoreList = getUserAttribute(self.id,"ignoreList"):split(" ");
	else
	self.ignoreList = {};
	end;
	

	if self.setting == "" and table.maxn(self.ignoreList) > 0 then
		print("manySilo-WARNING: Fruits detected in ignoreList even though setting attribute is empty. Ignorelist wont work without a setting.")
	end;	
	if self.setting ~= "" and table.maxn(self.fruitTypes) > 0 then
		print("manySilo-WARNING: Fruits detected in fruitTypes, but setting is set to '"..self.setting.."'. Setting attribute has higher priority and will take over.")
	end;
	if self.setting == "" and table.maxn(self.fruitTypes) > 0 and table.maxn(self.ignoreList) > 0 then
		print("manySilo-WARNING: Fruits detected in both fruitTypes and ignoreList attribute. You dont have to use ignoreList when using fruitTypes.")
	end;
	if self.setting ~= "" and self.setting ~= "realism" and self.setting ~= "all" and self.setting ~= "seedable" then
		print("manySilo-WARNING: Unknown setting in 'setting' attribute. Falling back on 'realism'");
		self.setting = "realism";
	end;
	if self.setting == "" and table.maxn(self.fruitTypes) == 0 then
		print("manySilo-WARNING: Both fruitTypes and setting is empty. Falling back on 'all' setting.")
		self.setting = "all";
	end;
	if self.setting == "realism" then
		local i = 0;
		for a=1, FruitUtil.NUM_FRUITTYPES do
			if (FruitUtil.fruitIndexToDesc[a].allowsSeeding) and (FruitUtil.fruitIndexToDesc[a].name~="grass")then
					i=i+1;
					self.allowedFruits[i]=a;
			end;
		end;
		if self.ignoreList[1] ~= "" then
			for b=1,table.maxn(self.allowedFruits) do
				for d=1, table.maxn(self.ignoreList) do
					if FruitUtil["FRUITTYPE_"..string.upper(self.ignoreList[d])] == self.allowedFruits[b] then
						table.remove(self.allowedFruits,b)
					end;
				end;
			end;
		end;
	end;
	if self.setting == "seedable" then
		local i = 0;
		for a=1, FruitUtil.NUM_FRUITTYPES do
			if (FruitUtil.fruitIndexToDesc[a].allowsSeeding) then
					i=i+1;
					self.allowedFruits[i]=a;
			end;
		end;
		if self.ignoreList[1] ~= "" then
			for b=1,table.maxn(self.allowedFruits) do
				for d=1, table.maxn(self.ignoreList) do
					if FruitUtil["FRUITTYPE_"..string.upper(self.ignoreList[d])] == self.allowedFruits[b] then
						table.remove(self.allowedFruits,b)
					end;
				end;
			end;
		end;
	end;
	if self.setting == "all" then
		local i = 0;
		for a=1, FruitUtil.NUM_FRUITTYPES do
			i=i+1;
			self.allowedFruits[i]=a;
		end;
		if self.ignoreList[1] ~= "" then
			for b=1,table.maxn(self.allowedFruits) do
				for d=1, table.maxn(self.ignoreList) do
					if FruitUtil["FRUITTYPE_"..string.upper(self.ignoreList[d])] == self.allowedFruits[b] then
						table.remove(self.allowedFruits,b)
					end;
				end;
			end;
		end;
	end;
	if table.maxn(self.allowedFruits)<1 then
		for f = 1, table.maxn(self.fruitTypes) do
			self.allowedFruits[f] = FruitUtil["FRUITTYPE_"..string.upper(self.fruitTypes[f])]
		end;
	end;
	
	for c = 1 , table.maxn(self.allowedFruits) do
		print("Allowed fruits :"..c..":"..FruitUtil.fruitIndexToDesc[self.allowedFruits[c]].name)
	end;
	self.siloParticleSystemRoot = loadI3DFile("data/vehicles/particleSystems/wheatParticleSystemLong.i3d");
end;
function manySilo:loadMap(name)

end;

function manySilo:deleteMap()
removeTrigger(self.id);
end;

function manySilo:delete()
end;



function manySilo:mouseEvent(posX, posY, isDown, isUp, button)
end;

function manySilo:keyEvent(unicode, sym, modifier, isDown)
end;
function manySilo:update(dt)

	if self.triggerId ~= 0 and getNumOfChildren(self.siloParticleSystemRoot) ~= nil then
		local ParticlePosX,ParticePosY,ParticlePosZ = Utils.getVectorFromString(getUserAttribute(self.triggerId, "particlePosition"));
		local x,y,z = localToWorld(self.triggerId, ParticlePosX,ParticePosY,ParticlePosZ)
		setTranslation(self.siloParticleSystemRoot, x, y, z);
		link(getRootNode(), self.siloParticleSystemRoot);
		for i=0, getNumOfChildren(self.siloParticleSystemRoot)-1 do
			local child = getChildAt(self.siloParticleSystemRoot, i);
			if getClassName(child) == "Shape" then
				local geometry = getGeometry(child);
				if geometry ~= 0 then
					if getClassName(geometry) == "ParticleSystem" then
						self.siloParticleSystem = geometry;
					end;
				end;
			end;
		end;
	end;
	if self.siloParticleSystem ~= nil then
		setEmittingState(self.siloParticleSystem, false);
	end;
	if not self.fill then
		setEmittingState(self.siloParticleSystem, false);
	end;
	if self.otherId ~= 0 then
		trailer = g_currentMission.objectToTrailer[self.otherId];
		if trailer ~= nil then
		
			if trailer.fillTypes ~= nil and trailer.setFillLevel ~= nil and trailer.fillLevel ~= nil and trailer.typeDesc ~= "sower" and trailer.typeDesc ~= "sprayer" then			
				
				local i = 0;
				for t=1, table.maxn(self.allowedFruits) do
					for tt=1, table.maxn(trailer.fillTypes) do
						if FruitUtil.fruitTypeToFillType[self.allowedFruits[t]] == tt and trailer.fillTypes[tt] == true then
							i=i+1;
							self.trailerFruits[i] = FruitUtil.fruitTypeToFillType[self.allowedFruits[t]];
							self.fruitsToTrailer[FruitUtil.fruitTypeToFillType[self.allowedFruits[t]]] = i;
						end;
					end;
				end;
				
				
				if InputBinding.hasEvent(InputBinding.MENU_RIGHT) then
				--print_r(trailer,"")
					--for c = 1 , table.maxn(self.trailerFruits) do
						--print("Allowed fruits :"..c..":"..FruitUtil.fruitIndexToDesc[FruitUtil.fillTypeToFruitType[self.trailerFruits[c]]].name)
					--end;
					--print_r(g_currentMission.objectToTrailer,"test","")
				end;
				if InputBinding.hasEvent(InputBinding.MENU_UP) and self.currentFruit > 1 then
					if trailer.fillLevel <= 0 then
						self.currentFruit = self.currentFruit - 1					
						self.fillFruit = self.trailerFruits[self.currentFruit];
					end;
				end;
				if InputBinding.hasEvent(InputBinding.MENU_DOWN) and self.currentFruit < table.maxn(self.trailerFruits) then
					if trailer.fillLevel <= 0 then
						self.currentFruit = self.currentFruit + 1					
						self.fillFruit = self.trailerFruits[self.currentFruit];
					end;
				end;
				if InputBinding.hasEvent(InputBinding.MENU_ACCEPT) then
					self.fill = not self.fill;
				end;
				if trailer.fillLevel > 0 then
					
					self.currentFruit = self.fruitsToTrailer[FruitUtil.fruitTypeToFillType[trailer:getCurrentFruitType()]];
					
					self.lockedFruit = self.currentFruit;
					self.fillFruit = self.trailerFruits[self.currentFruit];
					
				else
				self.lockedFruit = 0;
				end;
				if trailer.fillLevel < trailer.capacity and trailer:allowFillType(self.fillFruit, true) then
					if self.fill then
						local delta = dt*0.6;
						if g_currentMission.missionStats.farmSiloAmounts[self.fillFruit]<=delta then
							delta=g_currentMission.missionStats.farmSiloAmounts[self.fillFruit];
							self.fill = false;
						end;
						if delta > 0 then
							trailer:setFillLevel(trailer.fillLevel+delta, self.fillFruit);
							g_currentMission.missionStats.farmSiloAmounts[self.fillFruit]=g_currentMission.missionStats.farmSiloAmounts[self.fillFruit]-delta;
							setEmittingState(self.siloParticleSystem, true);
						end;
					end;
					if g_currentMission.missionStats.farmSiloAmounts[self.fillFruit]<=0 then
						g_currentMission.missionStats.farmSiloAmounts[self.fillFruit]=0;
						self.fill = false;
					end;
				else
					
					self.fill = false;
				end;
				if trailer.isActive == false then
					self.show = false;
					self.otherId = 0;
					self.triggerId = 0;	
					
					self.fruitcnt = 0;
					self.currentFruit = 1;
					self.trailerFruits = {};
					self.fill = false;
					self.lockedFruit = 0;
				else
				self.show = true;
				end;
				
			end;
		end;		
	end;
end;
function manySilo:draw()
	if self.show then
		setTextBold(true);
		renderText(0.02,0.70,0.023,"Choose fruit to fill:");
		setTextBold(false);
		setTextColor(0.1,1,0.1,1);
		local i = 0.02;
		for a = 1, table.maxn(self.trailerFruits) do
			if self.trailerFruits[a] ~= nil then
				if self.lockedFruit == a then
					setTextColor(1,0.1,0.1,1);
				elseif Utils.getNoNil(g_currentMission.missionStats.farmSiloAmounts[self.trailerFruits[a]],0)<=0 and self.lockedFruit ~= a then
					setTextColor(0.7,0.5,0,1);
				else
					setTextColor(0.1,1,0.1,1);
				end;
				if a == self.currentFruit then
					renderText(0.02,0.70-i,0.02,a..": ["..g_i18n:getText(FruitUtil.fruitIndexToDesc[FruitUtil.fillTypeToFruitType[self.trailerFruits[a]]].name).."]");
				else
					renderText(0.02,0.70-i,0.02,a..": "..g_i18n:getText(FruitUtil.fruitIndexToDesc[FruitUtil.fillTypeToFruitType[self.trailerFruits[a]]].name));
				end;
				i=i+0.02;
			end;
		end;
	end;
end;
function manySilo:manySiloCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if onEnter then
		if otherId ~= nil then
			self.otherId = otherId;
			self.triggerId = triggerId;			
		end;
	elseif onLeave then
			self.otherId = 0;
			self.triggerId = 0;	
			self.show = false;
			self.fruitcnt = 0;
			self.currentFruit = 1;
			self.trailerFruits = {};
			self.fill = false;
			self.lockedFruit = 0;

	elseif onStay then
		if otherId ~= nil then
			self.otherId = otherId;
			self.triggerId = triggerId;
		end;
	end;
end;


function print_r (t, name, indent)
  local tableList = {}
  function table_r (t, name, indent, full)
    local serial=string.len(full) == 0 and name
        or type(name)~="number" and '["'..tostring(name)..'"]' or '['..name..']'
    print(indent,serial,' = ') 
    if type(t) == "table" then
      if tableList[t] ~= nil then print('{}; -- ',tableList[t],' (self reference)\n')
      else
        tableList[t]=full..serial
        if next(t) then -- Table not empty
          print('{\n')
          for key,value in pairs(t) do table_r(value,key,indent..'\t',full..serial) end 
          print(indent,'};\n')
        else print('{};\n') end
      end
    else print(type(t)~="number" and type(t)~="boolean" and '"'..tostring(t)..'"'
                  or tostring(t),';\n') end
  end
  table_r(t,name or '__unnamed__',indent or '','')
end
function string:split(delimiter)
  local result = { }
  local from  = 1
  local delim_from, delim_to = string.find( self, delimiter, from  )
  while delim_from do
    table.insert( result, string.sub( self, from , delim_from-1 ) )
    from  = delim_to + 1
    delim_from, delim_to = string.find( self, delimiter, from  )
  end
  table.insert( result, string.sub( self, from  ) )
  return result
end

addModEventListener(manySilo);
