--
-- PowerShaftLong
-- Specialization for PowerShaftLong
--
-- @author  Manuel Leithner
-- @date  26/07/09
--

PowerShaftLong = {};

function PowerShaftLong.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function PowerShaftLong:load(xmlFile)
	
	self.powerShaft = {};		
	self.powerShaft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#index"));
	local x,y,z = getRotation(self.powerShaft.node);
	self.powerShaft.rot = {x,y,z};
	self.powerShaft.part = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#part"));
	x,y,z = getTranslation(self.powerShaft.part);
	self.powerShaft.trans = {x,y,z};
	self.powerShaft.middlePart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#middlePart"));
	if self.powerShaft.middlePart ~= nil then
		x,y,z = getScale(self.powerShaft.middlePart);
	end;
	self.powerShaft.middleScale = {x,y,z};
	self.powerShaft.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#fixPoint"));
	local ax, ay, az = getWorldTranslation(self.powerShaft.part);
	local bx, by, bz = getWorldTranslation(self.powerShaft.fixPoint);		
	self.powerShaft.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);	

	self.attacherVehiclePowerShaft = nil;
	self.doJointSearch = false;
	
end;

function PowerShaftLong:delete()
end;

function PowerShaftLong:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PowerShaftLong:keyEvent(unicode, sym, modifier, isDown)
end;

function PowerShaftLong:update(dt)
	
	if self.doJointSearch then
		for i=1, table.getn(self.attacherVehicle.attachedImplements) do
			if self.attacherVehicle.attachedImplements[i].object == self then			
				local index = self.attacherVehicle.attachedImplements[i].jointDescIndex;
				local joint = self.attacherVehicle.attacherJoints[index];	
				if joint.powerShaftAttacher ~= nil then
					self.attacherVehiclePowerShaft = joint.powerShaftAttacher;
					break;	
				end;
			end;
		end;
		self.doJointSearch = false;
	end;
	
	if self:getIsActive() then		
			
		if self.attacherVehiclePowerShaft ~= nil then		
			local ax, ay, az = getWorldTranslation(self.powerShaft.node);
			local bx, by, bz = getWorldTranslation(self.attacherVehiclePowerShaft);
			local x, y, z = worldDirectionToLocal(getParent(self.powerShaft.node), bx-ax, by-ay, bz-az);
			setDirection(self.powerShaft.node, x, y, z, 0, -1, 0);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			if self.powerShaft.middlePart ~= nil then
				setScale(self.powerShaft.middlePart, 1, 1, distance)
			end;
			setTranslation(self.powerShaft.part, 0, 0, distance-self.powerShaft.distance);		
		end;		
	end;
	
end;

function PowerShaftLong:draw()
end;


function PowerShaftLong:onAttach(attacherVehicle)
	self.doJointSearch = true;
end;

function PowerShaftLong:onDetach()
	if self.powerShaft.middlePart ~= nil then
		setScale(self.powerShaft.middlePart, unpack(self.powerShaft.middleScale));
	end;
	setTranslation(self.powerShaft.part, unpack(self.powerShaft.trans));
	setRotation(self.powerShaft.node, unpack(self.powerShaft.rot));
	self.attacherVehiclePowerShaft = nil;
end;




