--
-- BergmannHTW65
-- 
-- used to set 'control-variables' in cylinderd2
--
--
-- @author:		fruktor (wwww.modding-society.de)
-- @version:	v0.1
-- @date:		08/12/10
-- @history:	v0.1 - inital implementation
--
-- Copyright (C) 
--

BergmannHTW65 = {};

function BergmannHTW65.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function BergmannHTW65:load(xmlFile)
	self.doJointSearchCylindered = false;
	self.origMouseControlsAxes = self.mouseControlsAxes;
	self.disaMouseControlsAxes = {};
end;	
	

function BergmannHTW65:delete()
end;

function BergmannHTW65:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BergmannHTW65:keyEvent(unicode, sym, modifier, isDown)
end;

function BergmannHTW65:update(dt)
end;

function BergmannHTW65:updateTick(dt)

	if self.varTip ~= nil then
		if self.varTip.activeTrailerIdx ~= self.varTip.trailerNr then
			self.mouseControlsAxes = self.disaMouseControlsAxes;
			return;
		else
			self.mouseControlsAxes = self.origMouseControlsAxes;
		end;
	end;

	-- ####
	if self.doJointSearchCylindered then
		if self.attacherVehicle ~= nil then
			for k,v in pairs(self.attacherVehicle.attachedImplements) do
				if v.object == self then
					local joint = self.attacherVehicle.attacherJoints[v.jointDescIndex];
					self.vehicleJoint = joint;
					self.doJointSearchCylindered = false;
					break;
				end;
			end;
		end;
		self.doJointSearchCylindered = false;
	end;
	
	-- #### update the attacherJoint!     
    if self.vehicleJoint ~= nil then
        setJointFrame(self.vehicleJoint.jointIndex, 1, self.attacherJoint.node);
	end;
	
	-- ### update PowerShaft!
	--[[
	if self.attacherVehiclePowerShaft ~= nil then
		self.doJointSearch = true;
	end;
	]]--	
end;

function BergmannHTW65:draw()
end;

function BergmannHTW65:onAttach()
	self.doJointSearchCylindered = true;
end;

function BergmannHTW65:onDetach()
	self.vehicleJoint = nil;
	
	local rX, rY, rZ = getRotation( Utils.indexToObject(self.components, "15") );
	
	if rX > Utils.degToRad(3) then
		self.attacherJoint.jointType = Vehicle.JOINTTYPE_TRAILERLOW;
	else
		self.attacherJoint.jointType = Vehicle.JOINTTYPE_TRAILERLOW;
	end;
end;

function BergmannHTW65:onLeave()
end;

function BergmannHTW65:onDeactivate()
end;

function BergmannHTW65:onDeactivateSounds()
end;


