--
-- Specialization for stjernbalehandler
-- Plays animations and attach and deattach bales.
--
--
-- @author:		Marcu Hedblom a.k.a Xentro (www.ls-uk.info)
-- @version:	v1.0
-- @date:		2011-10-16
-- @history:	v1.0 - inital implementation
--
--

Stjern = {};

function Stjern.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations) and SpecializationUtil.hasSpecialization(Cylindered, specializations);
end;

function Stjern:load(xmlFile)
	self.setPlayAnim = SpecializationUtil.callSpecializationsFunction("setPlayAnim");
	self.contactReport = Stjern.contactReport;
	self.contactReport2 = Stjern.contactReport2;
	self.attachObject = Stjern.attachObject;
	self.detachObject = Stjern.detachObject;

	self.PAs = {};
	local i=0;
	while true do
		local baseName = string.format("vehicle.stjern.part(%d)", i);
		if not hasXMLProperty(xmlFile, baseName) then
			break;
        end;
		local PA = {};
		PA.aName = getXMLString(xmlFile, baseName .. "#name");
		PA.inputName = getXMLString(xmlFile, baseName .. "#inputName");
		if PA.aName == nil or InputBinding[PA.inputName] == nil then
			break;
		end;
			
		PA.helpTextNameP = getXMLString(xmlFile, baseName .. "#helpTextNamePos");
		PA.helpTextNameN = getXMLString(xmlFile, baseName .. "#helpTextNameNeg");
		if PA.helpTextNameP ~= nil then PA.helpText = true; else PA.helpText = false; end;
		if PA.helpTextNameP ~= nil and PA.helpTextNameN ~= nil then PA.multiHelpText = true; else PA.multiHelpText = false; end;
			
		PA.aFinished = false;
		
		PA.lockOne = Utils.indexToObject(self.components, getXMLString(xmlFile,baseName.."#lockOne"));
		PA.lockTwo = Utils.indexToObject(self.components, getXMLString(xmlFile,baseName.."#lockTwo"));
		PA.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile,baseName.."#fixPoint"));
		if PA.lockOne == nil or PA.lockTwo == nil or PA.fixPoint == nil then
			break;
		end;
		PA.isContactLoaded = false;
		PA.isAttached = false;
		PA.contactArea1 = nil;
		PA.contactArea2 = nil;
		PA.force = Utils.getNoNil(getXMLFloat(xmlFile,baseName.."#force"), 0.001);
		
		PA.joint = nil;

		PA.motorLowered = false;
		table.insert(self.PAs, PA);
		i = i+1;
	end;
	self.motorLoweredSoundPartNumber = 0;
	
	for k,v in pairs(self.PAs) do
		if not v.isContactLoaded then
			addContactReport(v.lockOne, v.force, "contactReport", self);
			addContactReport(v.lockTwo, v.force, "contactReport2", self);
			v.isContactLoaded = true;			
		end;
	end;
end;

function Stjern:delete()
end;

function Stjern:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Stjern:keyEvent(unicode, sym, modifier, isDown)
end;

function Stjern:readStream(streamId, connection)
	for k,v in pairs(self.PAs) do
		local state = streamReadBool(streamId);
		self:setPlayAnim(v.aName,state,true);
	end;
end;
	
function Stjern:writeStream(streamId, connection)
	for k,v in pairs(self.PAs) do
		streamWriteBool(streamId, v.aFinished);
	end;
end;

function Stjern:update(dt)
	if self:getIsActiveForInput() then
		for k,v in pairs(self.PAs) do
			if InputBinding.hasEvent(InputBinding[v.inputName]) then
				self:setPlayAnim(v.aName, not v.aFinished); 
			end;
		end;
	end;
end;

function Stjern:updateTick(dt)
	if self:getIsActive() then
		for k,v in pairs(self.PAs) do
			local playSoundForAnimation = self:getIsAnimationPlaying(v.aName);
			if playSoundForAnimation then
				if not self.cylinderedHydraulicSoundEnabled then
					if self:getIsActiveForSound() and self.attacherVehicle ~= nil then
						self.cylinderedHydraulicSoundPartNumber = k;
						playSample(self.cylinderedHydraulicSound, 0, self.cylinderedHydraulicSoundVolume, 0);
						self.cylinderedHydraulicSoundEnabled = true;
					end;
					if self.attacherVehicle ~= nil then
						self.motorLoweredSoundPartNumber = k;
						self.attacherVehicle.motorSoundPitchOffset = self.attacherVehicle.motorSoundPitchOffset - 0.13;
						v.motorLowered = true;
					end;
				end;
			else
				if self.cylinderedHydraulicSoundEnabled and self.cylinderedHydraulicSoundPartNumber == k then
					stopSample(self.cylinderedHydraulicSound);
					self.cylinderedHydraulicSoundEnabled = false;
				end;
				if v.motorLowered and self.attacherVehicle ~= nil and self.motorLoweredSoundPartNumber == k then
					self.attacherVehicle.motorSoundPitchOffset = self.attacherVehicle.motorSoundPitchOffset + 0.13;
					v.motorLowered = false;
				end;
			end;
			if self.isServer then	
				if v.contactArea1 ~= nil and v.contactArea1 == v.contactArea2 and self:getIsAnimationPlaying(v.aName) and not v.aFinished then
					if not v.isAttached then
						self:attachObject(v.aName);
						v.isAttached = true;
					end;
					self:stopAnimation(v.aName);
				end;

				if v.isAttached and v.aFinished then
					self:detachObject(v.aName);
				end;
			end;
		end;
	end;
end;

function Stjern:draw()
	for k,v in pairs(self.PAs) do
		if v.helpText then
			if v.multiHelpText then
				if v.aFinished then
					g_currentMission:addHelpButtonText(g_i18n:getText(v.helpTextNameN), InputBinding[v.inputName]);
				else
					g_currentMission:addHelpButtonText(g_i18n:getText(v.helpTextNameP), InputBinding[v.inputName]);
				end;
			else
				g_currentMission:addHelpButtonText(g_i18n:getText(v.helpTextNameP), InputBinding[v.inputName]);
			end;
		end;
	end;
end;

function Stjern:onDetach()
	for k,v in pairs(self.PAs) do
		if v.isContactLoaded then
			removeContactReport(v.lockOne);
			removeContactReport(v.lockTwo);
			v.isContactLoaded = false;		
		end;
		if v.isAttached then
			self:detachObject(v.aName);
		end;
		if self:getIsAnimationPlaying(v.aName) then
			self:stopAnimation(v.aName);
			self:onDeactivateSounds()
			if v.motorLowered then
				self.lastAttacherVehicle.motorSoundPitchOffset = self.lastAttacherVehicle.motorSoundPitchOffset + 0.13;
				v.motorLowered = false;
			end;
		end;
	end;
end;

function Stjern:onAttach(attacherVehicle)
	for k,v in pairs(self.PAs) do
		if not v.isContactLoaded then
			addContactReport(v.lockOne, v.force, "contactReport", self);
			addContactReport(v.lockTwo, v.force, "contactReport2", self);
			v.isContactLoaded = true;			
		end;
		if v.contactArea1 ~= nil and v.contactArea1 == v.contactArea2 and not v.aFinished then
			if not v.isAttached then
				self:attachObject(v.aName);
				v.isAttached = true;
			end;
		end;
	end;
	self.lastAttacherVehicle = attacherVehicle;
end;
function Stjern:contactReport(objectId, otherObjectId, isStart, normalForce, tangentialForce)
	local object = g_currentMission:getNodeObject(otherObjectId);
	if object ~= nil then
		for k,v in pairs(self.PAs) do
			if objectId == v.lockOne then
				if object:isa(Bale) then
					if isStart and otherObjectId then
						v.contactArea1 = otherObjectId;
					else
						v.contactArea1 = nil;
					end;
				end;
			end;
		end;
	end;
end;

function Stjern:contactReport2(objectId, otherObjectId, isStart, normalForce, tangentialForce)
	local object = g_currentMission:getNodeObject(otherObjectId);
	if object ~= nil then
		for k,v in pairs(self.PAs) do
			if objectId == v.lockTwo then
				if object:isa(Bale) then
					if isStart and otherObjectId then
						v.contactArea2 = otherObjectId;
					else
						v.contactArea2 = nil;
					end;
				end;
			end;
		end;
	end;
end;

function Stjern:attachObject(name)
	if self.isServer then	
		for k,v in pairs(self.PAs) do
			if not v.isAttached and name == v.aName and v.contactArea1 ~= nil and v.contactArea1 == v.contactArea2 then
				local x,y,z = getWorldTranslation(v.contactArea1);  
				local x1,x2,x3 = worldToLocal(v.lockOne, x,y,z);  
				setTranslation(v.fixPoint, x1,x2,x3)
				
				local zX, zY, zZ = localDirectionToWorld(v.contactArea1, 0,0,1);
				local zX, zY, zZ = worldDirectionToLocal(v.lockOne, zX, zY, zZ);

				local yX, yY, yZ = localDirectionToWorld(v.contactArea1, 0,1,0);
				local yX, yY, yZ = worldDirectionToLocal(v.lockOne, yX, yY, yZ);
				setDirection(v.fixPoint, zX, zY, zZ, yX, yY, yZ);
				
				local constr = JointConstructor:new();  
				for i= 0, 2 do 
					constr:setTranslationLimit(i, true, 0, 0); 
					constr:setRotationLimit(i, 0, 0); 
				end;
				constr:setActors(v.lockOne , v.contactArea1);
				constr:setJointTransforms(v.fixPoint , v.contactArea1);
				v.joint = constr:finalize();
				
				v.isAttached = true;
			end;
		end;
	end;
end;

function Stjern:detachObject(name)
	if self.isServer then	
		for k,v in pairs(self.PAs) do
			if v.isAttached and name == v.aName then
				removeJoint(v.joint);
				v.isAttached = false;
			end;
		end;
	end;
end;

function Stjern:setPlayAnim(name,state,noEventSend)
	for k,v in ipairs(self.PAs) do
		if v.aName ~= nil and name == v.aName then
			if state then
				if v.aName ~= nil and self.playAnimation ~= nil then
					self:playAnimation(v.aName, 1, nil, true);
					v.aFinished = state;
				end;
			else
				if v.aName ~= nil and self.playAnimation ~= nil then
					self:playAnimation(v.aName, -1, nil, true);
					v.aFinished = state;
				end;
			end;
		end;
	end;
	setPlayAnimeEvent.sendEvent(self,name,state,noEventSend);
end;

-- Event --
setPlayAnimeEvent = {};
setPlayAnimeEvent_mt = Class(setPlayAnimeEvent, Event);
InitEventClass(setPlayAnimeEvent, "setPlayAnimeEvent");

function setPlayAnimeEvent:emptyNew()
    local self = Event:new(setPlayAnimeEvent_mt);
    self.className="setPlayAnimeEvent";
    return self;
end;

function setPlayAnimeEvent:new(object, name, state)
	local self = setPlayAnimeEvent:emptyNew()
	self.object = object;
	self.name = name;
	self.state = state;
	return self;
end;

function setPlayAnimeEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
	self.name  = streamReadString(streamId);
    self.state = streamReadBool(streamId);
    self:run(connection);
end;

function setPlayAnimeEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteString(streamId, self.name);
	streamWriteBool(streamId, self.state);
end;

function setPlayAnimeEvent:run(connection)
	self.object:setPlayAnim(self.name,self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(setPlayAnimeEvent:new(self.object, self.name, self.state), nil, connection, self.object);
	end;	
end;

function setPlayAnimeEvent.sendEvent(vehicle, name, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(setPlayAnimeEvent:new(vehicle, name, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(setPlayAnimeEvent:new(vehicle, name, state));
		end;
	end;
end;