hamulce = {};

function hamulce.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function hamulce:load(xmlFile)
    self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;
	self.brakelightsActive = false;
	end;
	
function hamulce:delete()
end;

function hamulce:mouseEvent(posX, posY, isDown, isUp, button)
end;

function hamulce:update(dt)
self.input = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);		
 
 if InputBinding.isAxisZero(self.input) then
     self.input = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
end;		
		if -self.input < -0.001 and self.movingDirection > 0 then
			self.brakelightsActive = true;
		elseif -self.input > 0.001 and self.movingDirection < 0 then
    			self.brakelightsActive = true;
		else
			self.brakelightsActive = false;
		end;

	if self.isEntered then
			if self.brakelightsActive then
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive);
			end;
		else
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive, false);
			end;
		end;
	end;
end;

function hamulce:draw()
end;

function onLeave()
    self.brakelightsActive = false;
		for i=1, self.numbrakelights do
		local brakelight = self.brakelights[i];
		setVisibility(brakelight, self.brakelightsActive, false);
	end;
	end;