--
-- SpringhillMap
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

SpringhillMap = {}

local SpringhillMap_mt = Class(SpringhillMap, Mission00);

function SpringhillMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = SpringhillMap_mt;
    end;
    local self = SpringhillMap:superClass():new(baseDirectory, mt);
    return self;
end;

function SpringhillMap:delete()
    SpringhillMap:superClass().delete(self);
end;

function SpringhillMap:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    Potato_Merchants = Utils.getFilename("map01/pdapics/Potato_Merchants.png", self.baseDirectory);
    BrewerySmith = Utils.getFilename("map01/pdapics/BrewerySmith.png", self.baseDirectory);
	Garage = Utils.getFilename("map01/pdapics/garage.png", self.baseDirectory);
    
    -- load paths for AI traffic vehicles
    self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
          
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("missions/CattleMeadowNew.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
	
	--Mission Glass Containers
    -- self:loadGlassContainers(Utils.getFilename("missions/glassContainers.i3d", self.baseDirectory));
	
	--Mission Bottles
    -- self:loadCollectableBottles(Utils.getFilename("missions/collectableBottles.i3d", self.baseDirectory));
    g_currentMission.milkProductionScale = 0.4;
    g_currentMission.milkPriceScale = 1.0;
    g_currentMission.manureProductionScale = 0.4;
 
 
 	-- PDA Hotspots
	
	self.missionPDA:createMapHotspot("Watermill", "dataS2/missions/hud_pda_spot_watermill.png", 932, 1352, 0.02, 0.02, false, false, 0);
    self.missionPDA:createMapHotspot("BrewerySmith", BrewerySmith, 794, 1250, 0.04, 0.04, false, false, 0);
    self.missionPDA:createMapHotspot("Potato_Merchants", Potato_Merchants , 675, 1310 , 0.035, 0.035, false, false, 0);
	self.missionPDA:createMapHotspot("Cow", "dataS2/missions/hud_pda_spot_cow.png", 1110, 1057, 0.026, 0.026, false, false, 0);
	self.missionPDA:createMapHotspot("Garage", Garage , 675, 1200, 0.03, 0.023, false, false, 0);
    
    SpringhillMap:superClass().load(self);
end
function SpringhillMap:loadFinished()
    SpringhillMap:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function SpringhillMap:mouseEvent(posX, posY, isDown, isUp, button)
    SpringhillMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function SpringhillMap:keyEvent(unicode, sym, modifier, isDown)
    SpringhillMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function SpringhillMap:update(dt)
    SpringhillMap:superClass().update(self, dt);
end;

function SpringhillMap:draw()
    SpringhillMap:superClass().draw(self);
end;
