--
--
--





MapWeightstationMod = {};
MapWeightstationMod.stations = {};


function MapWeightstationMod:loadMap(name)
end;

function MapWeightstationMod:deleteMap()
end;

function MapWeightstationMod:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MapWeightstationMod:keyEvent(unicode, sym, modifier, isDown)
end;

function MapWeightstationMod:update(dt)
end;

function MapWeightstationMod:draw()
end;

function MapWeightstationMod:addWeightstation(station)
	table.insert(self.stations, station);
end;


addModEventListener(MapWeightstationMod);









--
--
--

function onCreate(self, id)
	local instance = Weightstation:new(g_server ~= nil, g_client ~= nil);
	local index = g_currentMission:addOnCreateLoadedObject(instance);
	instance:load(id);
	instance:register(true);
end;

Weightstation = {};

local Weightstation_mt = Class(Weightstation, Object);

function Weightstation:new(isServer, isClient)
	local self = Object:new(isServer, isClient, Weightstation_mt);
	self.className = "Weightstation";
	return self;
end;

function Weightstation:load(name)
	
	local dir = getUserProfileAppPath() .. "mods/MapWeightstationMod/";
	local file = dir .. "MapWeightstationMod.xml";
	if g_currentMission.missionInfo.isValid then
		self.firstTimeRun = true;
	else
		self.firstTimeRun = false;
	end;	
	
	local xmlFile = loadXMLFile("Weightstation", file);
	print("----------------> file="..tostring(file).." xmlFile="..tostring(xmlFile));
	
	self.fruitHectoliters = {};
	local i=0;
	while true do
		local key = string.format("vehicle.fruitHectoliters.fruit(%d)", i);
        local fruitNameStr = getXMLString(xmlFile, key .. "#name");
        if fruitNameStr == nil then
            break;
        end;
		self.fruitHectoliters[Fillable.fillTypeNameToInt[fruitNameStr]] = {};
		self.fruitHectoliters[Fillable.fillTypeNameToInt[fruitNameStr]].hectoliter = getXMLFloat(xmlFile, key .. "#hectoliter")/100;
		i=i+1;
	end;
	
	self.weightStation = {};
	self.weightStation.trigger = Utils.indexToObject(name, getXMLString(xmlFile, "vehicle.build.weightTrigger#index"));
	addTrigger(self.weightStation.trigger, "onVehicleCallback", self);
	self.weightStation.isEnabled = true;
	self.weightStation.digits = {};
	self.weightStation.digits[1] = Utils.indexToObject(name, getXMLString(xmlFile, "vehicle.build.digits#digit1"));
	self.weightStation.digits[2] = Utils.indexToObject(name, getXMLString(xmlFile, "vehicle.build.digits#digit2"));
	self.weightStation.digits[3] = Utils.indexToObject(name, getXMLString(xmlFile, "vehicle.build.digits#digit3"));
	self.weightStation.digits[4] = Utils.indexToObject(name, getXMLString(xmlFile, "vehicle.build.digits#digit4"));
	
	self.weightStation.digitPosition = {};
	self.weightStation.digitPosition["0"] = -1.000;
	self.weightStation.digitPosition["1"] = -0.105;
	self.weightStation.digitPosition["2"] = -0.208;
	self.weightStation.digitPosition["3"] = -0.306;
	self.weightStation.digitPosition["4"] = -0.410;
	self.weightStation.digitPosition["5"] = -0.517;
	self.weightStation.digitPosition["6"] = -0.613;
	self.weightStation.digitPosition["7"] = -0.719;
	self.weightStation.digitPosition["8"] = -0.817;
	self.weightStation.digitPosition["9"] = -0.926;
	
	self.vehiclesInTrigger = {};
	self.allVehicleMass = 0;
	self.playerToWeight = {};
	self.balesToWeight = {};
	
	MapWeightstationMod:addWeightstation(self);
end;

function Weightstation:delete()
	if self.weightStation.trigger ~= nil then
		removeTrigger(self.weightStation.trigger);
	end;
end;


function Weightstation:loadMap(name)
end;

function Weightstation:deleteMap()
end;


function Weightstation:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Weightstation:keyEvent(unicode, sym, modifier, isDown)
end;

function Weightstation:update(dt)
end;

function Weightstation:updateTick(dt)
	if self.weightStation.isEnabled then
		self:getVehicleMass(dt);
	end;
end;

function Weightstation:draw()
end;

function Weightstation:setDigitNumbers(mass)
	local mass = mass;
	local massUnits = string.format("%d", mass);
	local digit1 = "0";
	local digit2 = "0";
	local digit3 = "0";
	local digit4 = "0"
	if mass >= 10 then
		digit4 = string.sub(massUnits, 1, 1);
	end;
	if mass >= 100 then
		digit3 = string.sub(massUnits, 1, 1);
		digit4 = string.sub(massUnits, 2, 2);
	end;
	if mass >= 1000 then
		digit2 = string.sub(massUnits, 1, 1);
		digit3 = string.sub(massUnits, 2, 2);
		digit4 = string.sub(massUnits, 3, 3);
	end;
	if mass >= 10000 then
		digit1 = string.sub(massUnits, 1, 1);
		digit2 = string.sub(massUnits, 2, 2);
		digit3 = string.sub(massUnits, 3, 3);
		digit4 = string.sub(massUnits, 4, 4);
	end;
	setShaderParameter(self.weightStation.digits[4], "Position", self.weightStation.digitPosition[digit4], 0, 0, 0, false);
	setShaderParameter(self.weightStation.digits[3], "Position", self.weightStation.digitPosition[digit3], 0, 0, 0, false);
	setShaderParameter(self.weightStation.digits[2], "Position", self.weightStation.digitPosition[digit2], 0, 0, 0, false);
	setShaderParameter(self.weightStation.digits[1], "Position", self.weightStation.digitPosition[digit1], 0, 0, 0, false);
end;

function Weightstation:onVehicleCallback(triggerId, otherId, onEnter, onLeave, onStay)
	if self.weightStation.isEnabled then
		if onStay then
			local doInsertVehicle = true;
			local doInsertPlayer = true;
			local doInsertBale = true;
			local vehicle = g_currentMission.nodeToVehicle[otherId];
			for k, vehicles in pairs(self.vehiclesInTrigger) do
				if vehicle == vehicles then
					doInsertVehicle = false;
				end;
			end;
			for k, player in pairs(self.playerToWeight) do
				if otherId == player.rootNode then
					doInsertPlayer = false;
				end;
			end;
			for k, bale in pairs(self.balesToWeight) do
				if otherId == bale.nodeId then
					doInsertBale = false;
				end;
			end;
			if doInsertVehicle then
				table.insert(self.vehiclesInTrigger, vehicle);
			end;
			if doInsertPlayer then
				for i, misssionPlayers in pairs(g_currentMission.players) do
					if otherId == misssionPlayers.rootNode then
						table.insert(self.playerToWeight, misssionPlayers);
					end;
				end;
			end;
			if doInsertBale then
				for index, item in pairs(g_currentMission.itemsToSave) do
					if item.item:isa(Bale) then
						if item.item.nodeId == otherId then
							table.insert(self.balesToWeight, item.item);
						end;
					end;
				end;
			end;
		elseif onLeave then
			local vehicle = g_currentMission.nodeToVehicle[otherId];
			for k, v in pairs(self.vehiclesInTrigger) do
				if vehicle == v then
					table.remove(self.vehiclesInTrigger, k);
				end;
			end;
			for k, player in pairs(self.playerToWeight) do
				if player.rootNode == otherId then
					table.remove(self.playerToWeight, k);
				end;
			end;
			for k, bale in pairs(self.balesToWeight) do
				if bale.nodeId == otherId then
					table.remove(self.balesToWeight, k);
				end;
			end;
		end;
	end;
end;

function Weightstation:getVehicleMass(dt)
	local mass = 0;
	for k, vehicle in pairs(self.vehiclesInTrigger) do
		for k, component in pairs(vehicle.components) do
			mass = mass + getMass(component.node);	
		end;
	end;
	mass = mass*1000;
	for k, vehicle in pairs(self.vehiclesInTrigger) do
		if vehicle.fillLevelMax == nil then
			if vehicle.fillLevel ~= nil then
				mass = mass-(vehicle.fillLevel*vehicle.massScale);
				local massScale = 0.70;
				for k, fruit in pairs(self.fruitHectoliters) do
					if k == vehicle.currentFillType and fruit then
						massScale = fruit.hectoliter;
					end;
				end;
				mass = mass+(vehicle.fillLevel*massScale);
			end;
			if vehicle.grainTankFillLevel ~= nil then
				local massScale = 0.70;
				for k, fruit in pairs(self.fruitHectoliters) do
					if k == vehicle.currentGrainTankFruitType and fruit then
						massScale = fruit.hectoliter;
					end;
				end;
				mass = mass+(vehicle.grainTankFillLevel*massScale);
			end;
		elseif vehicle.fillLevelMax ~= nil then
			mass = mass+(633*vehicle.fillLevel);
		end;
		if vehicle.fuelFillLevel ~= nil then
			mass = mass+vehicle.fuelFillLevel;
		end;
		if vehicle.isControlled then
			mass = mass+80;
		end;
	end;
	local numPlayers = table.getn(self.playerToWeight);
	mass = mass+(80*numPlayers);
	local numBales = table.getn(self.balesToWeight);
	mass = mass+(633*numBales);
	if mass > self.allVehicleMass then
		self.allVehicleMass = math.min(self.allVehicleMass+(dt*5), mass);
	elseif mass < self.allVehicleMass then
		self.allVehicleMass = math.max(self.allVehicleMass-(dt*15), mass);
	end;
	self:setDigitNumbers(self.allVehicleMass);
end;
