-- MapWaterTriggers
-- Script for MapWaterTriggers
--
-- @ Autor  Tobias F. (John Deere 6930)
-- @ Last Edit  10/09/2011

MapWaterTrigger = {};
MapWaterTrigger.waterTriggers = {};
MapWaterTrigger.baseDirectory = g_currentModDirectory;

-- saveSelectedGame Wrapper
local CareerScreenSaveSelectedGame = CareerScreen.saveSelectedGame;
CareerScreen.saveSelectedGame = function(self)
	CareerScreenSaveSelectedGame(self); 
	MapWaterTrigger:saveWaterTriggerStates();
end;

local Server_sendObjects_old = Server.sendObjects;
function Server:sendObjects(connection, x,y,z, viewDistanceCoeff)
	for _,waterTrigger in pairs(MapWaterTrigger.waterTriggers) do
		connection:sendEvent(SetFillLevelEvent:new(waterTrigger, waterTrigger.fillLevel));
	end;
    Server_sendObjects_old(self, connection, x,y,z, viewDistanceCoeff);
end;

--Fixing Fillable
FillableWaterTrigger = {}
function FillableWaterTrigger:load(xmlFile)
	self.onEnteredMapWaterTrigger = FillableWaterTrigger.onEnteredMapWaterTrigger;
	self.onLeavedMapWaterTrigger = FillableWaterTrigger.onLeavedMapWaterTrigger;
	self.currentMapWaterTrigger = nil;
	self.doRefuelWater = false;
end;

function FillableWaterTrigger:onEnteredMapWaterTrigger(trigger)
	self.currentMapWaterTrigger = trigger;
end;

function FillableWaterTrigger:onLeavedMapWaterTrigger()
	self.currentMapWaterTrigger = nil;
	self.doRefuelWater = false;
end;

function FillableWaterTrigger:update(dt)
	if self.currentMapWaterTrigger ~= nil then
		local trigger = self.currentMapWaterTrigger;	
		if self:getIsActiveForInput() and self.fillLevel < self.capacity and trigger.fillLevel > 0 then
			if InputBinding.hasEvent(InputBinding.REFUEL_WATERTRIGGER) then
				self.doRefuelWater = not self.doRefuelWater;
			end;
		end;
		if self:getIsActive() then
			if self.fillLevel >= self.capacity or trigger.fillLevel <= 0 then
				self.doRefuelWater = false;
			end;
			if self.doRefuelWater then
				self:setFillLevel(self.fillLevel+trigger.fillingPerSecond, trigger.fillType);
				trigger:setFillLevel(trigger.fillLevel-trigger.fillingPerSecond);
			end;
		end;
	else
		self.doRefuelWater = false;
	end;
end;

function FillableWaterTrigger:draw()
	if self.currentMapWaterTrigger ~= nil then
		local trigger = self.currentMapWaterTrigger;	
		g_currentMission:addExtraPrintText(string.format(g_i18n:getText("WATERFILLLEVEL"), trigger.fillLevel));
		if not self.doRefuelWater and self.fillLevel < self.capacity and trigger.fillLevel > 0 then
			g_currentMission:addHelpButtonText(g_i18n:getText("REFILL"), InputBinding.REFUEL_WATERTRIGGER)
		end;
	end;
end;
Fillable.load   = Utils.appendedFunction(Fillable.load, FillableWaterTrigger.load);
Fillable.update   = Utils.appendedFunction(Fillable.update, FillableWaterTrigger.update);
Fillable.draw   = Utils.appendedFunction(Fillable.draw, FillableWaterTrigger.draw);

function MapWaterTrigger:loadMap(name)
	local dir = getUserProfileAppPath() .. "savegame"..g_currentMission.missionInfo.savegameIndex;
	createFolder(dir);
	self.mapWaterTriggers_xml = dir .. "/mapWaterTriggers.xml";
	if g_currentMission.missionInfo.isValid then
		self.firstTimeRun = true;
	else
		os.remove(self.mapWaterTriggers_xml);
		self.firstTimeRun = false;
	end;
end;

function MapWaterTrigger:deleteMap()
end;

function MapWaterTrigger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MapWaterTrigger:keyEvent(unicode, sym, modifier, isDown)
end;

function MapWaterTrigger:update(dt)
	if g_server ~= nil then
		if self.firstTimeRun then
			self:loadWaterTriggerStates();
			self.firstTimeRun = false;
		end;
		if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
			for _, waterTrigger in pairs(self.waterTriggers) do
				local newFillLevel = waterTrigger.fillLevel+waterTrigger.rainRefillPerSecond;
				waterTrigger:setFillLevel(newFillLevel);
			end;
		end;
	end;
end;

function MapWaterTrigger:draw()
end;

function MapWaterTrigger:addWaterTrigger(WaterTrigger)
	table.insert(self.waterTriggers, WaterTrigger)
end;

function MapWaterTrigger:saveWaterTriggerStates()
	local existDir = io.open (self.mapWaterTriggers_xml, "w");	
	if existDir == nil then
		createXMLFile("createWaterTrigger", self.mapWaterTriggers_xml, "saveWaterTrigger");
	end;
    local xmlFile = io.open (self.mapWaterTriggers_xml, "w");
    if xmlFile ~= nil then
        xmlFile:write('<?xml version="1.0" encoding="utf-8" standalone="no" ?>\n<waterTriggers>\n');
		for _,waterTrigger in pairs(self.waterTriggers) do
			xmlFile:write('    <waterTrigger fillLevel="'..waterTrigger.fillLevel..'"/>\n');
		end;
        xmlFile:write("</waterTriggers>");
        xmlFile:close();
    end;	
end;

function MapWaterTrigger:loadWaterTriggerStates()
	local existDir = io.open (self.mapWaterTriggers_xml, "r");
	if existDir ~= nil then
		local xmlFile = loadXMLFile("TempConfig", self.mapWaterTriggers_xml);
		local i = 0;
		while true do
			local key = string.format("waterTriggers.waterTrigger(%d)", i);
			local fillLevel = getXMLFloat(xmlFile, key.."#fillLevel");
			if fillLevel == nil or self.waterTriggers[i+1] == nil then
				break;
			end;
			self.waterTriggers[i+1].fillLevel = fillLevel;
			i = i + 1;
		end;
		delete(xmlFile);
	else
		print("Warning: ", self.mapWaterTriggers_xml, " can not be found, Watertrigger States not loaded.");
	end;
end;
addModEventListener(MapWaterTrigger);

-- WaterTrigger
-- Script for WaterTrigger
--
-- @ Autor  Tobias F. (John Deere 6930)
-- @ Last Edit  10/09/2011

function onCreate(self, id)
	local instance = WaterTrigger:new(g_server ~= nil, g_client ~= nil);
	local index = g_currentMission:addOnCreateLoadedObject(instance);
	instance:load(id);
	instance:register(true);
end;

WaterTrigger = {};

local WaterTrigger_mt = Class(WaterTrigger, Object);

function WaterTrigger:new(isServer, isClient)
	local self = Object:new(isServer, isClient, WaterTrigger_mt);
	self.className = "WaterTrigger";
	return self;
end;

function WaterTrigger:load(name)
	self.triggerId = name;
	addTrigger(name, "triggerCallback", self);
	self.isEnabled = true;
	self.fillType = Fillable.FILLTYPE_WATER;	
	self.fillLevel = 0;
	self.capacity = getUserAttribute(name, "capacity");--float	
	local moveMaxMinY = getUserAttribute(name, "moveMaxMinY");--string
	self.maxY, self.minY = unpack(Utils.getVectorNFromString(moveMaxMinY, 2));	
	local planeIndex = getUserAttribute(name, "planeIndex");--string
	self.movingPlane = Utils.indexToObject(self.triggerId, planeIndex);
	self.rainRefillPerSecond = Utils.getNoNil(getUserAttribute(name, "rainRefillPerSecond"), 2.0);--float	
	self.fillingPerSecond = Utils.getNoNil(getUserAttribute(name, "fillingPerSecond"), 5.0);--float	
	self:setFillLevel(0, true);	
	MapWaterTrigger:addWaterTrigger(self);
end;

function WaterTrigger:delete()
	removeTrigger(self.triggerId);
end;

function WaterTrigger:update()
end;

function WaterTrigger:updateTick()
end;

function WaterTrigger:setFillLevel(fillLevel, noEventSend)
	SetFillLevelEvent.sendEvent(self, fillLevel, noEventSend);
	self.fillLevel = fillLevel;
	if self.fillLevel >= self.capacity then
		self.fillLevel = self.capacity;
	end;
	if self.fillLevel < 0 then
		self.fillLevel = 0;
	end;
	if self.movingPlane ~= nil and self.minY ~= nil and self.maxY ~= nil then
		local x,_,z = getTranslation(self.movingPlane);
		local y = self.minY+(self.fillLevel/self.capacity)*(self.maxY-self.minY);
		setTranslation(self.movingPlane, x,y,z);
	end;
end;

function WaterTrigger:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if self.isEnabled then
		if (onEnter or onLeave) then
			local trailer = g_currentMission.objectToTrailer[otherShapeId];
			if trailer ~= nil and trailer:allowFillType(self.fillType, false) and trailer.onEnteredMapWaterTrigger ~= nil then
				if onEnter then
					trailer:onEnteredMapWaterTrigger(self);
				else
					trailer:onLeavedMapWaterTrigger();
				end;
			end;
		end;
	end;
end;