﻿--
-- RBAutoStack
--

RBAutoStack = {};

function RBAutoStack.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function RBAutoStack:load(xmlFile)
  self.pomocneKoleckoDole = true;
  self.isTurnedOn = false;
  self.Tip = 0;
  self.balikVeSberaku = false;
  self.muzuDalsi = false;
  self.warning = false;

  local pomocneKolecko = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pomocneKolecko#index"));
  if pomocneKolecko ~= nil then
    self.pomocneKolecko = {};
    self.pomocneKolecko.node = pomocneKolecko;
    local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.pomocneKolecko#minTrans"));
    self.pomocneKolecko.minTrans = {x, y, z};
    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.pomocneKolecko#maxTrans"));
    self.pomocneKolecko.maxTrans = {x, y, z};
    self.pomocneKolecko.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.pomocneKolecko#transTime"), 1)*1000;   
  end;

  local sberac = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sberac#index"));
  if sberac ~= nil then
    self.sberac = {};
    self.sberac.node = sberac;
    local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.sberac#minRot"));
    self.sberac.minRot = {};
    self.sberac.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
    self.sberac.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
    self.sberac.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
    
    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.sberac#maxRot"));
    self.sberac.maxRot = {};
    self.sberac.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
    self.sberac.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
    self.sberac.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
    
    self.sberac.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.sberac#rotTime"), 1)*1000;
    
    self.sberac.joint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sberac#jointIndex"));
    
    self.sberac.stul = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sberac#stul"));
    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.sberac#minRotStul"));
    self.sberac.minRotStul = {};
    self.sberac.minRotStul[1] = Utils.degToRad(Utils.getNoNil(x, 0));
    self.sberac.minRotStul[2] = Utils.degToRad(Utils.getNoNil(y, 0));
    self.sberac.minRotStul[3] = Utils.degToRad(Utils.getNoNil(z, 0));
    
    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.sberac#maxRotStul"));
    self.sberac.maxRotStul = {};
    self.sberac.maxRotStul[1] = Utils.degToRad(Utils.getNoNil(x, 0));
    self.sberac.maxRotStul[2] = Utils.degToRad(Utils.getNoNil(y, 0));
    self.sberac.maxRotStul[3] = Utils.degToRad(Utils.getNoNil(z, 0));
    
    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.sberac#minRotTip"));
    self.sberac.minRotTip = {};
    self.sberac.minRotTip[1] = Utils.degToRad(Utils.getNoNil(x, 0));
    self.sberac.minRotTip[2] = Utils.degToRad(Utils.getNoNil(y, 0));
    self.sberac.minRotTip[3] = Utils.degToRad(Utils.getNoNil(z, 0));
    
    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.sberac#maxRotTip"));
    self.sberac.maxRotTip = {};
    self.sberac.maxRotTip[1] = Utils.degToRad(Utils.getNoNil(x, 0));
    self.sberac.maxRotTip[2] = Utils.degToRad(Utils.getNoNil(y, 0));
    self.sberac.maxRotTip[3] = Utils.degToRad(Utils.getNoNil(z, 0));
    
    
    local sx, sy, sz = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.sberac#minTrans"));
    self.sberac.minTrans = {sx, sy, sz};
    sx, sy, sz = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.sberac#maxTrans"));
    self.sberac.maxTrans = {sx, sy, sz};
    self.sberac.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.sberac#transTime"), 1)*1000;
    
    local joints = getChildAt(self.sberac.stul, 0);
    self.sberac.ulozisteBaliku = {};
    for i = 1, 5 do
      self.sberac.ulozisteBaliku[(i*2)-1]={};
      self.sberac.ulozisteBaliku[(i*2)-1].node = getChildAt(joints,(i-1));
      self.sberac.ulozisteBaliku[(i*2)-1].balik = nil;
      self.sberac.ulozisteBaliku[(i*2)-1].balikCol = 0;
      self.sberac.ulozisteBaliku[(i*2)-1].fileName = "";

      self.sberac.ulozisteBaliku[(i*2)]={};
      self.sberac.ulozisteBaliku[(i*2)].node = getChildAt(self.sberac.ulozisteBaliku[(i*2)-1].node, 0);
      self.sberac.ulozisteBaliku[(i*2)].balik = nil;
      self.sberac.ulozisteBaliku[(i*2)].balikCol = 0;
      self.sberac.ulozisteBaliku[(i*2)].fileName = "";                  
    end;
         
  end;

  local hSberac = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulikaSberac#valec"));
  if hSberac ~= nil then
    self.hsberac = {};
    self.hsberac.valec = hSberac;
    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hydraulikaSberac#minRot"));
    self.hsberac.minRot = {};
    self.hsberac.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
    self.hsberac.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
    self.hsberac.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
    
    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hydraulikaSberac#maxRot"));
    self.hsberac.maxRot = {};
    self.hsberac.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
    self.hsberac.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
    self.hsberac.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
    
    self.hsberac.pist = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulikaSberac#pist")); 

    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hydraulikaSberac#minTrans"));
    self.hsberac.minTrans = {x, y, z};
    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hydraulikaSberac#maxTrans"));
    self.hsberac.maxTrans = {x, y, z};    
  end;

  local hPosun = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulikaPosun#valec"));
  if hPosun ~= nil then
    self.hposun = {};
    self.hposun.valec = hPosun;
    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hydraulikaPosun#minRot"));
    self.hposun.minRot = {};
    self.hposun.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
    self.hposun.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
    self.hposun.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
    
    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hydraulikaPosun#maxRot"));
    self.hposun.maxRot = {};
    self.hposun.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
    self.hposun.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
    self.hposun.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
    
    self.hposun.pist = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulikaPosun#pist")); 

    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hydraulikaPosun#minTrans"));
    self.hposun.minTrans = {x, y, z};
    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hydraulikaPosun#maxTrans"));
    self.hposun.maxTrans = {x, y, z};    
  end;
  
  local hVysuv = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulikaVysuv#valec"));
  if hVysuv ~= nil then
    self.hvysuv = {};
    self.hvysuv.valec = hVysuv;
    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hydraulikaVysuv#minRot"));
    self.hvysuv.minRot = {};
    self.hvysuv.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
    self.hvysuv.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
    self.hvysuv.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
    
    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hydraulikaVysuv#maxRot"));
    self.hvysuv.maxRot = {};
    self.hvysuv.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
    self.hvysuv.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
    self.hvysuv.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
    
    self.hvysuv.pist = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulikaVysuv#pist")); 

    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hydraulikaVysuv#minTrans"));
    self.hvysuv.minTrans = {x, y, z};
    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hydraulikaVysuv#maxTrans"));
    self.hvysuv.maxTrans = {x, y, z};    
  end;  
  
  local hydraulicSound = getXMLString(xmlFile, "vehicle.hydraulicSound#file");
  if hydraulicSound ~= nil and hydraulicSound ~= "" then
    hydraulicSound = Utils.getFilename(hydraulicSound, self.baseDirectory);
    self.hydraulicSound = createSample("hydraulicSound");
    loadSample(self.hydraulicSound, hydraulicSound, false);
    self.hydraulicSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hydraulicSound#pitchOffset"), 1);
    self.hydraulicSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hydraulicSound#pitchMax"), 2.0);
    self.hydraulicSoundEnabled = false;
    
    self.stulSound = createSample("stulSound");
    loadSample(self.stulSound, hydraulicSound, false);
    self.stulSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hydraulicSound#pitchOffset"), 1);
    self.stulSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hydraulicSound#pitchMax"), 2.0);
    self.stulSoundEnabled = false;    
  end;
  
  self.fillLevel = 0;
end;

function RBAutoStack:delete()
  if self.hydraulicSound ~= nil then
    delete(self.hydraulicSound);
  end;           
end;

--function RBAutoStack:readStream(streamId, connection)
--	self.fillLevel = streamReadInt32(streamId);
--	self.Tip = streamReadInt32(streamId);

--	self.pomocneKoleckoDole = streamReadBool(streamId);
--	self.balikVeSberaku = streamReadBool(streamId);
--	self.muzuDalsi = streamReadBool(streamId);
--end;

--function RBAutoStack:writeStream(streamId, connection)
--	streamWriteInt32(streamId, self.fillLevel);
--	streamWriteInt32(streamId, self.Tip);

--	streamWriteBool(streamId, self.pomocneKoleckoDole);
--	streamWriteBool(streamId, self.balikVeSberaku);
--	streamWriteBool(streamId, self.muzuDalsi);
--end

function RBAutoStack:getSaveAttributesAndNodes(nodeIdent)
    for i=1, 5 do
      for a=0, 1 do
        local index = ((6-i)*2)-1+a;
        if self.sberac.ulozisteBaliku[index].balik ~= nil then
          local balik = self.sberac.ulozisteBaliku[index].balik;
          local bx, by, bz = getWorldTranslation(balik);
          local rx,ry,rz = getWorldRotation(balik);

          setTranslation(balik, bx, by+0.05, bz);
          setRotation(balik, rx,ry,rz);
          link(getRootNode(), balik);
          setRigidBodyType(balik,"Dynamic");
          setCollisionMask(balik,self.sberac.ulozisteBaliku[index].balikCol);

          local child = self.sberac.ulozisteBaliku[index].balik;
          local name = getName(child);             
          local filename = self.sberac.ulozisteBaliku[index].fileName;
          --table.insert(g_currentMission.itemsToSave,{["class"]="MT",["i3dFilename"]=filename,["node"]=child,["childIndex"]=0});
          self.sberac.ulozisteBaliku[index].balik = nil;
          self.sberac.ulozisteBaliku[index].balikCol = 0;        
          self.fillLevel = self.fillLevel - 1;
        end;
      end;        
    end;
	
	return nil
end;

function RBAutoStack:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	self.fillLevel = 0;

	return BaseMission.VEHICLE_LOAD_OK;
end

function RBAutoStack:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RBAutoStack:keyEvent(unicode, sym, modifier, isDown)
end;

function RBAutoStack:update(dt)
  local x, y, z = getTranslation(self.pomocneKolecko.node);
  local trans = {x,y,z};
  local newtrans = Utils.getMovedLimitedValues(trans, self.pomocneKolecko.maxTrans, self.pomocneKolecko.minTrans, 3, self.pomocneKolecko.transTime, dt, self.pomocneKoleckoDole);
  setTranslation(self.pomocneKolecko.node, unpack(newtrans)); 
  
  if self.Tip == 0 then    
  	if self:getIsActiveForInput() then
	    if self.Tip == 0 and InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			if self.isTurnedOn then
				self.isTurnedOn = false;
			else
				self.isTurnedOn = true;
			end;        
	    end;	    
		if self.isTurnedOn and (self.fillLevel > 0) and InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			self.Tip = 1;
	    end;
    end;

    local x, y, z = getRotation(self.sberac.node);
    local rot = {x,y,z};
    local rotujDolu = self.isTurnedOn;
    if rotujDolu then
      if self.balikVeSberaku then 
        rotujDolu = false; 
      end;
    end;
    local newRot = Utils.getMovedLimitedValues(rot, self.sberac.maxRot, self.sberac.minRot, 3, self.sberac.rotTime, dt, rotujDolu);   
    setRotation(self.sberac.node, unpack(newRot));
    
    local hx, hy, hz = getRotation(self.hsberac.valec);
    local hrot = {hx,hy,hz};
    local hnewRot = Utils.getMovedLimitedValues(hrot, self.hsberac.maxRot, self.hsberac.minRot, 3, self.sberac.rotTime, dt, rotujDolu);   
    setRotation(self.hsberac.valec, unpack(hnewRot));
    
    hx, hy, hz = getTranslation(self.hsberac.pist);
    local htrans = {hx,hy,hz};
    local hnewtrans = Utils.getMovedLimitedValues(htrans, self.hsberac.maxTrans, self.hsberac.minTrans, 3, self.sberac.rotTime, dt, rotujDolu);
    setTranslation(self.hsberac.pist, unpack(hnewtrans));        
    
    if math.abs(z-newRot[3]) < 0.001 then
      if self.hydraulicSoundEnabled then
    		stopSample(self.hydraulicSound);
			self.hydraulicSoundEnabled = false;
      end;
      if self.balikVeSberaku and (z==self.sberac.maxRot[3]) then
        link(self.sberac.ulozisteBaliku[self.fillLevel].node,self.sberac.ulozisteBaliku[self.fillLevel].balik);
        self.balikVeSberaku = false;
      else
        self.muzuDalsi = true;      
      end;
    else
      playSample(self.hydraulicSound, 0, self.hydraulicSoundVolume, 0);
      setSamplePitch(self.hydraulicSound, self.hydraulicSoundPitchOffset-0.4);
      self.hydraulicSoundEnabled = true; 
    end;

    local zvednoutStul = false;  
    for i=1, 5 do
      local a = ((6-i)*2)-1;
      local balik = self.sberac.ulozisteBaliku[a];
      local nx,ny,nz = getTranslation(balik.node);
      if (nz==self.sberac.maxTrans[3]) and (self.sberac.ulozisteBaliku[a+1].balik~=nil) then
        local ntrans = {nx,ny,nz};
        local maxT = {self.sberac.maxTrans[1]+1.3*(i-1), self.sberac.maxTrans[2], self.sberac.maxTrans[3]};
        local minT = {self.sberac.maxTrans[1], self.sberac.maxTrans[2], self.sberac.maxTrans[3]};
        local newtrans = Utils.getMovedLimitedValues(ntrans, maxT, minT, 3, self.sberac.transTime, dt, false);
        setTranslation(balik.node, unpack(newtrans));
        if i~=1 then
          zvednoutStul = self.isTurnedOn and (zvednoutStul or (newtrans[1]~=maxT[1]));
        end;               
      else
        local ntrans = {nx,ny,nz};
        local newtrans = Utils.getMovedLimitedValues(ntrans, self.sberac.maxTrans, self.sberac.minTrans, 3, self.sberac.transTime, dt, (self.sberac.ulozisteBaliku[a+1].balik==nil));
        setTranslation(balik.node,unpack(newtrans));    
      end;
    end;
      
    x, y, z = getRotation(self.sberac.stul);
    rot = {x,y,z};
    newRot = Utils.getMovedLimitedValues(rot, self.sberac.minRotStul, self.sberac.maxRotStul, 3, self.sberac.rotTime, dt, zvednoutStul);   
    setRotation(self.sberac.stul, unpack(newRot));
    
    hx, hy, hz = getRotation(self.hposun.valec);
    hrot = {hx,hy,hz};
    hnewRot = Utils.getMovedLimitedValues(hrot, self.hposun.minRot, self.hposun.maxRot, 3, self.sberac.rotTime, dt, zvednoutStul);   
    setRotation(self.hposun.valec, unpack(hnewRot));
    
    hx, hy, hz = getTranslation(self.hposun.pist);
    htrans = {hx,hy,hz};
    hnewtrans = Utils.getMovedLimitedValues(htrans, self.hposun.minTrans, self.hposun.maxTrans, 3, self.sberac.rotTime, dt, zvednoutStul);
    setTranslation(self.hposun.pist, unpack(hnewtrans));        
              
    if (math.abs(newRot[1]-self.sberac.minRotStul[1]) > 0.001) and not self.stulSoundEnabled then
      playSample(self.stulSound, 0, self.stulSoundVolume, 0);
      setSamplePitch(self.stulSound, self.stulSoundPitchOffset-0.4);
      self.stulSoundEnabled = true;       
    elseif (math.abs(newRot[1]-self.sberac.minRotStul[1]) < 0.001) and self.stulSoundEnabled then
   		stopSample(self.stulSound);
 	  	self.stulSoundEnabled = false;
    end;
    
    self.muzuDalsi = self.muzuDalsi and (not zvednoutStul) and (math.abs(newRot[1]-self.sberac.minRotStul[1]) < 0.001); 
    if (self.isTurnedOn) and (self.muzuDalsi) and (not self.hydraulicSoundEnabled) and (self.fillLevel < self.capacity) then
      if not self.balikVeSberaku then
        local balik, index = BalikInRange(self);        
        if balik ~= nil then
          self.fillLevel = self.fillLevel + 1;
          setRigidBodyType(balik, "Kinematic");
          self.sberac.ulozisteBaliku[self.fillLevel].balikCol = getCollisionMask(balik);
          setCollisionMask(balik, 0);
          link(self.sberac.joint, balik);
          setTranslation(balik, 0, 0, 0);
          setRotation(balik,0, math.pi/2, 0);	-- Utils.degToRad(90)
          self.sberac.ulozisteBaliku[self.fillLevel].balik = balik;
          self.sberac.ulozisteBaliku[self.fillLevel].fileName = ""
          --table.remove(g_server.objects,index);
          self.balikVeSberaku = true;
          self.muzuDalsi = false;
        end;        
      end;
    end;
  elseif (self.Tip == 1) or (self.Tip == 5) then
    if not self.stulSoundEnabled then
      playSample(self.stulSound, 0, self.stulSoundVolume, 0);
      setSamplePitch(self.stulSound, self.stulSoundPitchOffset-0.4);
      self.stulSoundEnabled = true;          
    end;
    local sx, sy, sz = getRotation(self.sberac.stul);
    local srot = {sx,sy,sz};
    local snewRot = Utils.getMovedLimitedValues(srot, self.sberac.minRotTip, self.sberac.maxRotTip, 3, self.sberac.rotTime*3, dt, self.Tip == 1);   
    setRotation(self.sberac.stul, unpack(snewRot));
    
    local hx, hy, hz = getRotation(self.hvysuv.valec);
    local hrot = {hx,hy,hz};
    hnewRot = Utils.getMovedLimitedValues(hrot, self.hvysuv.minRot, self.hvysuv.maxRot, 3, self.sberac.rotTime*3, dt, self.Tip == 1);   
    setRotation(self.hvysuv.valec, unpack(hnewRot));
    
    hx, hy, hz = getTranslation(self.hvysuv.pist);
    htrans = {hx,hy,hz};
    hnewtrans = Utils.getMovedLimitedValues(htrans, self.hvysuv.minTrans, self.hvysuv.maxTrans, 3, self.sberac.rotTime*3, dt, self.Tip == 1);
    setTranslation(self.hvysuv.pist, unpack(hnewtrans));        
    
    for i=1, 5 do
      local a = ((6-i)*2)-1;
      local balik = self.sberac.ulozisteBaliku[a];
      local nx,ny,nz = getTranslation(balik.node);
      if ((self.sberac.ulozisteBaliku[a].balik~=nil) and (self.Tip==1)) or ((self.sberac.ulozisteBaliku[a+1].balik==nil) and (self.Tip==5)) then
        local ntrans = {nx,ny,nz};
        local maxT = {self.sberac.maxTrans[1]+1.3*(i-1), self.sberac.maxTrans[2], self.sberac.maxTrans[3]};
        local minT = {self.sberac.maxTrans[1], self.sberac.maxTrans[2], self.sberac.maxTrans[3]};
        local newtrans = Utils.getMovedLimitedValues(ntrans, maxT, minT, 3, self.sberac.transTime, dt, (self.Tip == 5));
        setTranslation(balik.node, unpack(newtrans));
      end;
    end;
    if (self.Tip == 1) and (math.abs(sx-snewRot[1]) < 0.001) then      
      self.Tip = 2;
    end;
    if (self.Tip == 5) and (math.abs(sx-snewRot[1]) < 0.001) then
      self.Tip = 0;
    end;
    if (math.abs(sx-snewRot[1]) < 0.001) and self.stulSoundEnabled then
   		stopSample(self.stulSound);
 	  	self.stulSoundEnabled = false;
    end;            
  elseif (self.Tip == 2) then
  	if self:getIsActiveForInput() then
	    if (InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA)) then
	      self.Tip = 5;
	    end;
  	  if (InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2)) then
	      self.Tip = 3;
	    end;
    end;
  elseif (self.Tip == 3) then
    for i=1, 5 do
      for a=0, 1 do
        local index = ((6-i)*2)-1+a;
        if self.sberac.ulozisteBaliku[index].balik ~= nil then
          local balik = self.sberac.ulozisteBaliku[index].balik;
          local bx, by, bz = getWorldTranslation(balik);
          local rx,ry,rz = getWorldRotation(balik);

          setTranslation(balik, bx, by+0.05, bz);
          setRotation(balik, rx,ry,rz);
          link(getRootNode(), balik);
          setRigidBodyType(balik,"Dynamic");
          setCollisionMask(balik,self.sberac.ulozisteBaliku[index].balikCol);

          local child = self.sberac.ulozisteBaliku[index].balik;
          local name = getName(child);             
          local filename = self.sberac.ulozisteBaliku[index].fileName;
          --table.insert(g_currentMission.itemsToSave,{["class"]="MT",["i3dFilename"]=filename,["node"]=child,["childIndex"]=0});
          self.sberac.ulozisteBaliku[index].balik = nil;
          self.sberac.ulozisteBaliku[index].balikCol = 0;        
          self.fillLevel = self.fillLevel - 1;
        end;
      end;        
    end;
    self.Tip = 4;
  elseif (self.Tip == 4) then
  	if self:getIsActiveForInput() then
  	  if (InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2)) then
	      self.Tip = 5;
	    end;
    end;      
  end;
end;

function RBAutoStack:draw()
  if self.isTurnedOn then
    if self.Tip == 0 then
      if self.warning and self.isTurnedOn then        
		    g_currentMission:addWarning(g_i18n:getText("rb_bale_isnt_round1"), 0.055, 0.055);               
      end;    
      g_currentMission:addHelpButtonText(g_i18n:getText("rb_turn_off"), InputBinding.IMPLEMENT_EXTRA);
      if self.fillLevel > 0 then 
        g_currentMission:addHelpButtonText(g_i18n:getText("rb_unload"), InputBinding.IMPLEMENT_EXTRA2);
      end;
    elseif self.Tip == 2 then
      g_currentMission:addHelpButtonText(g_i18n:getText("rb_unload_abort"), InputBinding.IMPLEMENT_EXTRA);
      g_currentMission:addHelpButtonText(g_i18n:getText("rb_unload_now"), InputBinding.IMPLEMENT_EXTRA2);
    elseif self.Tip == 4 then
      g_currentMission:addHelpButtonText(g_i18n:getText("rb_tilt_table"), InputBinding.IMPLEMENT_EXTRA2);      
    end;
  else
    g_currentMission:addHelpButtonText(g_i18n:getText("rb_turn_on"), InputBinding.IMPLEMENT_EXTRA);
  end;
end;

function RBAutoStack:onAttach(attacherVehicle)
	self.pomocneKoleckoDole = false;
end;

function RBAutoStack:onDetach()	
	self.pomocneKoleckoDole = true;
end;

function BalikInRange(self)
	local nearestObject = nil;
	local itemNode = nil;
	local index = 0;
	local nearestDistance = 1.0;
	
	local px, py, pz = getWorldTranslation(self.sberac.joint);

	self.warning = false;

	local g_object = nil
	if g_server ~= nil then
		g_object = g_server;
	else
		g_object = g_client;
	end

	if g_object ~= nil then	-- g_object should never be able to be nil, but better safe then sorry.
		for i=1, #g_object.objects do
			if g_object.objects[i] ~= nil and g_object.objects[i].className == "Bale" then
				itemNode = g_object.objects[i].nodeId;

				local vx, vy, vz = getWorldTranslation(itemNode);
				local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);

				if distance < nearestDistance then
					if getUserAttribute(itemNode, "isRoundbale") then
						index = i;
						nearestObject = itemNode;
						nearestDistance = distance;
						self.warning = false;
					else 
						self.warning = true;
					end;
				end
			end;
		end;
	end;

	if self.warning and (index > 0) then
		self.warning = false;
	end;

	return nearestObject, index;
end;
