--
-- rotacyjna
-- BY Majster2009

rotacyjna = {};

function rotacyjna.prerequisitesPresent(specializations)
    return true;
end;

function rotacyjna:load(xmlFile)


----------------------------------MOWER ORGINAL--------------------------------

    self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
    self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
    if self.groundReferenceNode == nil then
        self.groundReferenceNode = self.components[1].node;
    end;

    local mowerSound = getXMLString(xmlFile, "vehicle.mowerSound#file");
    if mowerSound ~= nil and mowerSound ~= "" then
        mowerSound = Utils.getFilename(mowerSound, self.baseDirectory); 
        self.mowerSound = createSample("mowerSound");
        self.mowerSoundEnabled = false;
        loadSample(self.mowerSound, mowerSound, false);
        self.mowerSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mowerSound#pitchOffset"), 1);
        self.mowerSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mowerSound#volume"), 1);
    end;

    local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
    for i=1, numCuttingAreas do
        local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
        self.cuttingAreas[i].foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMinLimit"), 0);
        self.cuttingAreas[i].foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMaxLimit"), 1);
    end;

    self.isTurnedOn = false;
    self.wasToFast = false;


	self.lowerRmp = SpecializationUtil.callSpecializationsFunction("lowerRmp");

---------------ruchome------------------

    local rotationPartNoderuchome = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ruchome#index"));
    if rotationPartNoderuchome ~= nil then
        self.rotationPartruchome = {};
        self.rotationPartruchome.node = rotationPartNoderuchome;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartruchome#minRot"));
        self.rotationPartruchome.minRot = {};
        self.rotationPartruchome.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartruchome.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartruchome.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.ruchome#maxRot"));
        self.rotationPartruchome.maxRot = {};
        self.rotationPartruchome.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartruchome.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartruchome.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartruchome.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.ruchome#rotTime"), 2)*1000;
        self.rotationPartruchome.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.ruchome#touchRotLimit"), 10));
    end;

		self.walek = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.walek#index"));	
		self.beben = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.beben#index"));
		self.beben2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.beben2#index"));

	
		self.walekvisActive = false;
		self.walekvis = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.walekvis#index"));
		self.walekvis2Active = true;
		self.walekvis2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.walekvis2#index"));


    self.groundParticleSystems = {};
    local psName = "vehicle.groundParticleSystem";
    Utils.loadParticleSystem(xmlFile, self.groundParticleSystems, psName, self.components, false, nil, self.baseDirectory)
    self.groundParticleSystemActive = false;


end;



function rotacyjna:update(dt)		
----------------------------------MOWER ORGINAL-----------------------------------

    self.wasToFast = false;
    if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
            self.isTurnedOn = not self.isTurnedOn;
        end;
    end;


	
    if self:getIsActive() then
	

        if self.isTurnedOn then
          
		   local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 31;
            if not toFast then
                local x,y,z = getWorldTranslation(self.groundReferenceNode);
                local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
                if terrainHeight+self.groundReferenceThreshold >= y then

					local foldAnimTime = self.foldAnimTime;
                    for k, cuttingArea in pairs(self.cuttingAreas) do
                        if foldAnimTime == nil or (foldAnimTime <= cuttingArea.foldMaxLimit and foldAnimTime >= cuttingArea.foldMinLimit) then
                            local x,y,z = getWorldTranslation(cuttingArea.start);
                            local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                            local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
							
                            Utils.updateMeadowArea(x, z, x1, z1, x2, z2);
                        
						end;
                    end;
                end;
            end;
	
           
		   if not self.mowerSoundEnabled and self:getIsActiveForSound() then
                setSamplePitch(self.mowerSound, self.mowerSoundPitchOffset);
                playSample(self.mowerSound, 0, self.mowerSoundVolume, 0);
                self.mowerSoundEnabled = true;
            end;

            self.wasToFast = toFast;

        else
            if self.mowerSoundEnabled then
                stopSample(self.mowerSound);
                self.mowerSoundEnabled = false;
            end;
        end;
        
	end;

           

----------------------------------ruchome----------------------------
if self.rotationPartruchome ~= nil then
	local x, y, z = getRotation(self.rotationPartruchome.node);
	local rot = {x,y,z};
	local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartruchome.maxRot, self.rotationPartruchome.minRot, 3, self.rotationPartruchome.rotTime, dt, not self.rotationMaxruchome);
	setRotation(self.rotationPartruchome.node, unpack(newRot));
end
		
	

	
	

		if self.isTurnedOn and self.walek ~= nil then
			rotate(self.walek, 0, 0, dt*0.5);
		end;

			
		if self.isTurnedOn and self.beben2 ~= nil then
			rotate(self.beben2, 0, dt*3, 0);
		end;
	  
	  if self.isTurnedOn and self.beben ~= nil then
			rotate(self.beben, 0, dt*3, 0);
		end; 

		
			setVisibility(self.walekvis, self.walekvisActive);
			setVisibility(self.walekvis2, self.walekvis2Active);

	
			
			
			
			
end;



function rotacyjna:draw()
----------------------------------MOWER ORGINAL-----------------------------------	
	
	
	if self.isTurnedOn then
       	g_currentMission:addExtraPrintText("Wcisnij B: Wylacz");
    else
       	g_currentMission:addExtraPrintText("Wcisnij B: Wlacz");
    end;

 if self.wasToFast then
        g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "2", InputBinding.getButtonKeyName(InputBinding.SPEED_LEVEL2)), 0.07+0.022, 0.019+0.029);
    end;	
		






		
		
		if self.rozkladanie then	
			g_currentMission:addExtraPrintText("Wcisnij N: Zloz");
		else
			g_currentMission:addExtraPrintText("Wcisnij N: Rozloz");
		end;

end;



function rotacyjna:mouseEvent(posX, posY, isDown, isUp, button)
end;

function rotacyjna:keyEvent(unicode, sym, modifier, isDown)
	---------------ruchome------------------
	
	  if isDown and sym == Input.KEY_n then 
		self.rotationMaxruchome = not self.rotationMaxruchome;
		self.walekvisActive = not self.walekvisActive;
		self.walekvis2Active = not self.walekvis2Active;
	end;

end;

function rotacyjna:onAttach()
----------------------------------MOWER ORGINAL-----------------------------------

end; 	

function rotacyjna:onDetach()
  ----------------------------------MOWER ORGINAL-----------------------------------
	if self.deactivateOnDetach then
        rotacyjna.onDeactivate(self);
    else
        rotacyjna.onDeactivateSounds(self)
    end;
	self.isTurnedOn = false

end;

function rotacyjna:delete()
----------------------------------MOWER ORGINAL-----------------------------------
    if self.mowerSound ~= nil then
        delete(self.mowerSound);
    end;
    Utils.deleteParticleSystem(self.groundParticleSystems);
end;

function rotacyjna:onDeactivate()
    rotacyjna.onDeactivateSounds(self)
    if self.groundParticleSystemActive then
        self.groundParticleSystemActive = false;
        Utils.setEmittingState(self.groundParticleSystems, false);
    end;
    self.isTurnedOn = false;
end;

function rotacyjna:onDeactivateSounds()


    if self.mowerSoundEnabled then
        stopSample(self.mowerSound);
        self.mowerSoundEnabled = false;
    end;
end;

function rotacyjna:onLeave()
    if self.deactivateOnLeave then
       rotacyjna.onDeactivate(self);
    else
        rotacyjna.onDeactivateSounds(self)
    end;
self.isTurnedOn = false
end;
