-- RollersSpecialization
-- Specialization for RollersSpecialization mod
--
-- @author  Tobias F. (John Deere 6930, 1. LS-Modschmiede)
-- @date LastEdit 24/10/09

RollersSpecialization = {};

function RollersSpecialization.prerequisitesPresent(specializations)
    return true;
end;

function RollersSpecialization:load(xmlFile)
    local numspinners = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.spinners#count"), 0);
    self.spinners = {};
    for i=1, numspinners do
		local partnamei = string.format("vehicle.spinners.spinner" .. "%d", i);
		self.spinners[i] = {};
		self.spinners[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partnamei .. "#Rot"));
		self.spinners[i].Rot = {};
		self.spinners[i].Rot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
		self.spinners[i].Rot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
		self.spinners[i].Rot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
    end;
    self.isTurnedOn = false;
end;                          
                             
function RollersSpecialization:delete()
end;

function RollersSpecialization:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RollersSpecialization:keyEvent(unicode, sym, modifier, isDown)
end;

function RollersSpecialization:update(dt)
    if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
            self.isTurnedOn = not self.isTurnedOn;
        end;
    end;	
    if self:getIsActive() then		
		if self.isTurnedOn then
			for i=1, table.getn(self.spinners) do
				if self.spinners[i] ~= nil then
					rotate(self.spinners[i].index, unpack(self.spinners[i].Rot));
				end;
			end;
		end;
	end;
end;

function RollersSpecialization:draw()
    if self.isTurnedOn then
        g_currentMission:addHelpButtonText(g_i18n:getText("turn_off_rollers"), InputBinding.IMPLEMENT_EXTRA);
    else
        g_currentMission:addHelpButtonText(g_i18n:getText("turn_on_rollers"), InputBinding.IMPLEMENT_EXTRA);
    end;	
end;
