--
-- PFM Z343
-- author: Burner
-- 

Z343 = {};

function Z343.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function Z343:load(xmlFile)
	self.av = {};
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local xUp, yUp, zUp = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, hydraulicName .. "#upVectors"),"0 1 0"));
		self.hydraulics[i].upVectors = {xUp, yUp, zUp};
		
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		if self.hydraulics[i].translationPunch ~= nil then
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	self.setHydraulicTime = 30;
	
	self.threshingParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.threshingParticleSystems.threshingParticleSystem(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end;
		local isStatic = Utils.getNoNil(getXMLBool(xmlFile, namei.."#static"), false);
		if isStatic then
			StaticParticleSystem.loadParticleSystem(xmlFile, self.threshingParticleSystems, namei, nodei, false, nil, self.baseDirectory);
		else
			Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems, namei, nodei, false, nil, self.baseDirectory);
		end;
		Utils.setEmittingState(self.threshingParticleSystems,false);
		i = i +1;		
    end;
	
	self.customAttacher = {};
	local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.attacherJoint#minRot"));
	self.customAttacher.minRot = {};
	self.customAttacher.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
	self.customAttacher.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
	self.customAttacher.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
	local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.attacherJoint#maxRot"));
	self.customAttacher.maxRot = {};
	self.customAttacher.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
	self.customAttacher.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
	self.customAttacher.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
	
	self.attacherBackup = {};
end;

function Z343:delete()
end;

function Z343:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Z343:keyEvent(unicode, sym, modifier, isDown)
end;

function Z343:update(dt)
    if self:getIsActiveForInput() then
		if InputBinding.isPressed(InputBinding.Z343_ReelUp) and self:getIsActiveForInput() then
			self:setAnimationTime(1, self.animationParts[1].currentPosition+(self.animationParts[1].offSet+dt), false);
		elseif InputBinding.isPressed(InputBinding.Z343_ReelDown) and self:getIsActiveForInput() then
			self:setAnimationTime(1, self.animationParts[1].currentPosition-(self.animationParts[1].offSet+dt), false);
		end;
    end;
	if self:getIsActive() then			
		self.setHydraulicTime = 30;	
	end;

	if self.setHydraulicTime > 0 then
		for k,v in pairs(self.hydraulics) do 
			self:setHydraulicDirection(k);
		end;
		self.setHydraulicTime = self.setHydraulicTime - 1;
	end;
end;

function Z343:updateTick(dt)
end;

function Z343:draw()
	g_currentMission:addExtraPrintText(string.format(""..InputBinding.getKeyNamesOfDigitalAction(InputBinding.Z343_ReelUp) .. " / " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.Z343_ReelDown)..":      "..g_i18n:getText("Z343_ReelMove")..""));
end;

function Z343:onAttach(attacherVehicle)
	self.av = attacherVehicle;
	for k, jointDesc in pairs(attacherVehicle.attacherJoints) do
		if jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER then
			self.attacherBackup.minRot = jointDesc.minRot;
			self.attacherBackup.maxRot = jointDesc.maxRot;
			jointDesc.minRot = self.customAttacher.minRot;
			jointDesc.maxRot = self.customAttacher.maxRot;
		end;
	end;
end;

function Z343:onDetach()
	for k, jointDesc in pairs(self.av.attacherJoints) do
		if jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER then
			jointDesc.minRot = self.attacherBackup.minRot;
			jointDesc.maxRot = self.attacherBackup.maxRot;
		end;
	end;
end;

function Z343:onLeave()
end;

function Z343:onDeactivate()
end;

function Z343:setHydraulicDirection(index)
	local hydraulic = self.hydraulics[index];
	if hydraulic.fixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(hydraulic.node);
		local bx, by, bz = getWorldTranslation(hydraulic.fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
		local xUp, yUp, zUp = unpack(hydraulic.upVectors);
		setDirection(hydraulic.node, x, y, z, xUp, yUp, zUp);
		if hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(hydraulic.punch, 0, 0, distance-hydraulic.punchDistance);
		end;
	end;
end;