SetDoorStateEvent = {};
SetDoorStateEvent_mt = Class(SetDoorStateEvent, Event);

InitEventClass(SetDoorStateEvent, "SetDoorStateEvent");

function SetDoorStateEvent:emptyNew()
    local self = Event:new(SetDoorStateEvent_mt);
    self.className="SetDoorStateEvent";
    return self;
end;

function SetDoorStateEvent:new(vehicle, doorState)
    local self = SetDoorStateEvent:emptyNew()
    self.vehicle = vehicle;
	self.doorState = doorState;
    return self;
end;

function SetDoorStateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.doorState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetDoorStateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.doorState);
end;

function SetDoorStateEvent:run(connection)   
	self.vehicle:setDoorState(self.doorState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetDoorStateEvent:new(self.vehicle, self.doorState), nil, connection, self.vehicle);
    end;
end;

function SetDoorStateEvent.sendEvent(vehicle, doorState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetDoorStateEvent:new(vehicle, doorState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetDoorStateEvent:new(vehicle, doorState));
		end;
	end;
end;