--
-- PFM Z350
-- author: Burner
-- 

PFMZ_Z350 = {};

function PFMZ_Z350.prerequisitesPresent(specializations)
    return true;
end;

function PFMZ_Z350:load(xmlFile)
	self.lockCutterAttacher = SpecializationUtil.callSpecializationsFunction("lockCutterAttacher");
	self.setDoorState = SpecializationUtil.callSpecializationsFunction("setDoorState");
	
	self.doorAnimation = getXMLString(xmlFile, "vehicle.door#animationName");
	self.doorClosed = true;
	
	self.rollNodes = {};
    local rollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.roll#index"));
    if rollNode ~= nil then
        local speed = 0.003*3;
        table.insert(self.rollNodes, {node=rollNode, speed=speed});
    end;
    local i = 0;
    while true do
        local key = string.format("vehicle.rolls.roll(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local rollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speed"), 0.003);
        if rollNode ~= nil then
            table.insert(self.rollNodes, {node=rollNode, speed=speed});
        end;
        i = i + 1;
    end;
	
	for k, jointDesc in pairs(self.attacherJoints) do
		if jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER then
			jointDesc.maxRotBackup = jointDesc.maxRot;
		end;
	end;
	
	self.attachCutterUpActive = false;
end;

function PFMZ_Z350:delete()
end;

function PFMZ_Z350:readStream(streamId, connection)
	self:setDoorState(streamReadBool(streamId), true);
	self:lockCutterAttacher(streamReadBool(streamId), true);
end;

function PFMZ_Z350:writeStream(streamId, connection)
	streamWriteBool(streamId, self.doorClosed);
	streamWriteBool(streamId, self.attachCutterUpActive);
end;

function PFMZ_Z350:readUpdateStream(streamId, timestamp, connection)
end;

function PFMZ_Z350:writeUpdateStream(streamId, connection, dirtyMask)
end;

function PFMZ_Z350:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PFMZ_Z350:keyEvent(unicode, sym, modifier, isDown)
end;

function PFMZ_Z350:update(dt)
	if self:getIsActive() then
		if self.isThreshing then
			for _, rollNode in pairs(self.rollNodes) do
				rotate(rollNode.node, -dt*rollNode.speed, 0, 0);
			end;
		end;
	end;
	
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.PFMZ_Z350_ToggleDoor) then
			self:setDoorState(not self.doorClosed);
		end;
	end;
	
	if self.isClient then
		if g_currentMission.attachableInMountRange ~= nil then
			if g_currentMission.attachableInMountRangeVehicle == self then
				for k, jointDesc in pairs(self.attacherJoints) do
					if jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER and g_currentMission.attachableInMountRange.attacherJoint.jointType == Vehicle.JOINTTYPE_CUTTER then
						local x, y, z = getWorldTranslation(jointDesc.jointTransform);
						local ax, ay, az = getWorldTranslation(g_currentMission.attachableInMountRange.attacherJoint.node);
						local heightDifference = y - ay;
						if heightDifference < 0.2 then
							if self.attachCutterUpActive then
								g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PFMZ_Z350_UnlockCutterAttacher"), self.typeDesc), InputBinding.PFMZ_Z350_LockCutterAttacher);
							else
								g_currentMission:addWarning(g_i18n:getText("PFMZ_Z350_LockCutterAttacherInfo"), 0.07+0.022, 0.019+0.029);	
								g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PFMZ_Z350_LockCutterAttacher"), self.typeDesc), InputBinding.PFMZ_Z350_LockCutterAttacher);
							end;
							if InputBinding.hasEvent(InputBinding.PFMZ_Z350_LockCutterAttacher) then
								self:lockCutterAttacher(not self.attachCutterUpActive);
							end;
						end;
					end;
				end;
			end;
		end;
	end;
	
	if table.getn(self.attachedImplements) > 0 and self.attachCutterUpActive then
		self.attachCutterUpActive = false;
		for k, jointDesc in pairs(self.attacherJoints) do
			if jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER then
				jointDesc.maxRot = jointDesc.maxRotBackup;
			end;
		end;
	end;
end;

function PFMZ_Z350:updateTick(dt)	
end;

function PFMZ_Z350:setDoorState(doorState,noEventSend)
	SetDoorStateEvent.sendEvent(self, doorState, noEventSend);
	if doorState then
		if self.doorAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.doorAnimation, -1, nil, true);
			self.doorClosed = true;
		end;
	else
		if self.doorAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.doorAnimation, 1, nil, true);
			self.doorClosed = false;
		end;
	end;
end;

function PFMZ_Z350:draw()
	if self.isClient then
		if self.doorClosed then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PFMZ_Z350_OpenDoor"), self.typeDesc), InputBinding.PFMZ_Z350_ToggleDoor);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PFMZ_Z350_CloseDoor"), self.typeDesc), InputBinding.PFMZ_Z350_ToggleDoor);
		end;
	end;
end;

function PFMZ_Z350:lockCutterAttacher(attachCutterUp, noEventSend)
	LockCutterAttacherEvent.sendEvent(self, attachCutterUp, noEventSend);
	self.attachCutterUpActive = attachCutterUp;
	for k, jointDesc in pairs(self.attacherJoints) do
		if jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER then
			if attachCutterUp then
				jointDesc.maxRot = jointDesc.minRot;
			else
				jointDesc.maxRot = jointDesc.maxRotBackup;
			end;
		end;
	end;
end;