--
-- PFM Z342
-- author: Burner
-- 

Z342 = {};

function Z342.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function Z342:load(xmlFile)
	self.av = {};
	self.threshingScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingScale#value"), 20);
    self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"),0.5);
    self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
    if self.groundReferenceNode == nil then
        self.groundReferenceNode = self.components[1].node;
    end;
	local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
    self.cuttingAreas = nil;
    self.cuttingAreas = {};
    self.cuttingAreasN = {};
    for i=1, numCuttingAreas do
        self.cuttingAreasN[i] = {};
        local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
        self.cuttingAreasN[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.cuttingAreasN[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.cuttingAreasN[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;
	
	self.threshingParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.threshingParticleSystems.threshingParticleSystem(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end;
		local isStatic = Utils.getNoNil(getXMLBool(xmlFile, namei.."#static"), false);
		if isStatic then
			StaticParticleSystem.loadParticleSystem(xmlFile, self.threshingParticleSystems, namei, nodei, false, nil, self.baseDirectory);
		else
			Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems, namei, nodei, false, nil, self.baseDirectory);
		end;
		Utils.setEmittingState(self.threshingParticleSystems,false);
		i = i +1;		
    end;
end;

function Z342:delete()
end;

function Z342:readStream(streamId, connection)
end;

function Z342:writeStream(streamId, connection)
end;

function Z342:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Z342:keyEvent(unicode, sym, modifier, isDown)
end;

function Z342:update(dt)
end;

function Z342:updateTick(dt)
	self.lastArea = 0;
	if self.reelStarted and self.movingDirection < 0 then
        local hasGroundContact = false;
        local x,y,z = getWorldTranslation(self.groundReferenceNode);
        local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
        if terrainHeight+self.groundReferenceThreshold >= y then
            hasGroundContact = true;
        end;
		if hasGroundContact then
			local realArea = 0;
			for k,area in pairs(self.cuttingAreasN) do
				for fruitType,v in pairs(self.fruitTypes) do
					local x,y,z = getWorldTranslation(area.start);
					local x1,y1,z1 = getWorldTranslation(area.width);
					local x2,y2,z2 = getWorldTranslation(area.height);
					
					local area = Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0)*g_currentMission.windrowCutLongRatio;
					area = area + Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0);
					if area > 0 then
						self.currentFruitType = FruitUtil.FRUITTYPE_GRASS;
						self.lastArea = self.lastArea + area;
						realArea = realArea + area/g_currentMission.maxFruitValue;
					end;
				end;
				--self.lastArea = self.lastArea;
			end;
			local pixelToQm = 2048 / 4096 * 2048 / 4096; -- 4096px are mapped to 2048m
			local qm = realArea*pixelToQm;
			local ha = qm/10000;
			
			g_currentMission.missionStats.hectaresThreshedTotal = g_currentMission.missionStats.hectaresThreshedTotal + ha;
			g_currentMission.missionStats.hectaresThreshedSession = g_currentMission.missionStats.hectaresThreshedSession + ha;

			g_currentMission.missionStats.threshingDurationTotal = g_currentMission.missionStats.threshingDurationTotal + dt/(1000*60);
			g_currentMission.missionStats.threshingDurationSession= g_currentMission.missionStats.threshingDurationSession + dt/(1000*60);
		end;
	end;
	self.lastAreaBiggerZero = (self.lastArea > 0);
end;

function Z342:draw()	
end;

function Z342:onAttach(attacherVehicle)
	self.av = attacherVehicle;
	attacherVehicle.threshingScale = self.threshingScale;
end;

function Z342:onDetach()
	self.av.threshingScale = 1;
end;

function Z342:onLeave()
end;