--
--
-- @author:  	Manuel Leithner/Ptitminus73
-- @date:		25/03/10
-- @version:	v2.0
-- @history:	v1.0 - initial implementation
--				v2.0 - Converted to LS201
--				v2.1 - Adapted of Kuhn
--

Kuhn = {};

function Kuhn.prerequisitesPresent(specializations)
    return true;
end;

function Kuhn:load(xmlFile)

	self.attacherOptions = {};
	self.attacherOptions.frame = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoint#frame"));
	self.attacherOptions.upY = getXMLFloat(xmlFile, "vehicle.attacherJoint#upY");
	self.attacherOptions.downY = getXMLFloat(xmlFile, "vehicle.attacherJoint#downY");
	self.attacherOptions.pallet = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoint#pallet"));
	self.attacherOptions.scale = 1;
	
	self.powerShaft = {};		
	self.powerShaft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#index"));
	local x,y,z = getRotation(self.powerShaft.node);
	self.powerShaft.rot = {x,y,z};
	self.powerShaft.part = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#part"));
	x,y,z = getTranslation(self.powerShaft.part);
	self.powerShaft.trans = {x,y,z};
	self.powerShaft.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#fixPoint"));
	local ax, ay, az = getWorldTranslation(self.powerShaft.part);
	local bx, by, bz = getWorldTranslation(self.powerShaft.fixPoint);		
	self.powerShaft.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);	

	self.attacherVehiclePowerShaft = nil;
	self.doJointSearch = false;

end;

function Kuhn:delete()
end;

function Kuhn:readStream(streamId, connection)
end;

function Kuhn:writeStream(streamId, connection)
end;

function Kuhn:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Kuhn:keyEvent(unicode, sym, modifier, isDown)	
end;

function Kuhn:update(dt)
	if self:getIsActive() then
		if self.attachingFinished then
			local implement = self.attacherVehicle:getImplementByObject(self);
			if implement ~= nil then
				local joint = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
				self.attacherOptions.scale = joint.topArm.zScale;
				setJointFrame(joint.jointIndex, 0, self.attacherJoint.node);
				self.attachingFinished = false;			
			end;				
		end;
		
		if self.attacherVehicle ~= nil then
			local lx,ly,lz = localDirectionToWorld(self.attacherVehicle.rootNode, 0, 0, -1*self.attacherOptions.scale);
			local x, y, z = worldDirectionToLocal(getParent(self.attacherOptions.frame), lx,ly,lz);
			setDirection(self.attacherOptions.frame, x, y, z, 0, 1, 0);		
		end;	
		
		if self.attacherVehiclePowerShaft ~= nil then		
			local ax, ay, az = getWorldTranslation(self.powerShaft.node);
			local bx, by, bz = getWorldTranslation(self.attacherVehiclePowerShaft);
			local x, y, z = worldDirectionToLocal(getParent(self.powerShaft.node), bx-ax, by-ay, bz-az);
			setDirection(self.powerShaft.node, x, y, z, 0, -1, 0);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.powerShaft.part, 0, 0, distance-self.powerShaft.distance);		
		end;		
	end;
	
	if self.doJointSearch then
		for i=1, table.getn(self.attacherVehicle.attachedImplements) do
			if self.attacherVehicle.attachedImplements[i].object == self then			
				local index = self.attacherVehicle.attachedImplements[i].jointDescIndex;
				local joint = self.attacherVehicle.attacherJoints[index];	
				if joint.powerShaftAttacher ~= nil then
					self.attacherVehiclePowerShaft = joint.powerShaftAttacher;
					break;
				else
					local tempRootNode = createTransformGroup("tempRootNode");
					link(joint.jointTransform, tempRootNode);
					setTranslation(tempRootNode, -0.34472, 0.23851, 0);
					setRotation(tempRootNode, 0, Utils.degToRad(-90), 0);
					self.attacherVehiclePowerShaft = tempRootNode;
					break;
				end;
			end;
		end;
		self.doJointSearch = false;
	end;
end;

function Kuhn:updateTick(dt)	
	if self:getIsActive() then
		for _, part in pairs(self.movingParts) do
			part.isDirty = true;
		end;
	end
end;

function Kuhn:draw()
end;

function Kuhn:onAttach()
	local x,y,z = getTranslation(self.attacherOptions.frame);
	setTranslation(self.attacherOptions.frame, x, self.attacherOptions.downY, z);
	setTranslation(self.attacherJoint.node, x, self.attacherOptions.downY, z);
	setVisibility(self.attacherOptions.pallet, false);
	self.attachingFinished = true;
	self.doJointSearch = true;
end;

function Kuhn:onDetach()
	local x,y,z = getTranslation(self.attacherOptions.frame);
	setTranslation(self.attacherOptions.frame, x, self.attacherOptions.upY, z);
	setTranslation(self.attacherJoint.node, x, self.attacherOptions.upY, z);
	setRotation(self.attacherOptions.frame,0,0,0);
	setVisibility(self.attacherOptions.pallet, true);
	setTranslation(self.powerShaft.part, unpack(self.powerShaft.trans));
	setRotation(self.powerShaft.node, unpack(self.powerShaft.rot));
	self.attacherVehiclePowerShaft = nil;
end;