SetTraceurGaucheEvent = {};
SetTraceurGaucheEvent_mt = Class(SetTraceurGaucheEvent, Event);

InitEventClass(SetTraceurGaucheEvent, "SetTraceurGaucheEvent");

function SetTraceurGaucheEvent:emptyNew()
    local self = Event:new(SetTraceurGaucheEvent_mt);
    self.className="SetTraceurGaucheEvent";
    return self;
end;

function SetTraceurGaucheEvent:new(vehicle, traceurGauche)
    local self = SetTraceurGaucheEvent:emptyNew()
    self.vehicle = vehicle;
	self.traceurGauche = traceurGauche;
    return self;
end;

function SetTraceurGaucheEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.traceurGauche = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetTraceurGaucheEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.traceurGauche);
end;

function SetTraceurGaucheEvent:run(connection)   
	self.vehicle:setTraceurGauche(self.traceurGauche, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetTraceurGaucheEvent:new(vehicle, self.traceurGauche), nil, connection, self.vehicle);
    end;
end;

function SetTraceurGaucheEvent.sendEvent(vehicle, traceurGauche, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetTraceurGaucheEvent:new(vehicle, traceurGauche), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetTraceurGaucheEvent:new(vehicle, traceurGauche));
		end;
	end;
end;