-- by modelleicher
-- www.schwabenmodding.bplaced.net

newHydraulic = {};

function newHydraulic.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function newHydraulic:load(xmlFile)
	self.referenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoints.attacherJoint.topArm#referenceNode"));
end;
function newHydraulic:delete()
end;
function newHydraulic:mouseEvent(posX, posY, isDown, isUp, button)
end;
function newHydraulic:keyEvent(unicode, sym, modifier, isDown)
end;
function newHydraulic:updateTick(dt)
	
end;
function newHydraulic:update(dt)	
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			local px, py, pz = getWorldTranslation(self.attacherJoints[1].topArm.rotationNode);
			local vx, vy, vz = getWorldTranslation(self.topArmL.referenceNode );
			local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
			self.distance = distance;
		end;
	end;
	if self:getIsActive() then
		local px, py, pz = getWorldTranslation(self.attacherJoints[1].topArm.rotationNode);
		local vx, vy, vz = getWorldTranslation(self.topArmL.referenceNode );
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < self.distance then
			rotate(self.attacherJoints[1].bottomArm.rotationNode, 0.1*dt, 0,0);
		elseif distance > self.distance then
			rotate(self.attacherJoints[1].bottomArm.rotationNode, -0.1*dt, 0,0);
		end;
	end;
end;

function newHydraulic:draw()
end;

