-- by modelleicher
-- www.schwabenmodding.bplaced.net

SchlueterSuper1500Animations = {};

function SchlueterSuper1500Animations.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function SchlueterSuper1500Animations:load(xmlFile)
	-- Zapfwellenstummel / Powershaft rotation
	self.stummelIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.SchlueterAnimations#zapfwellenStummelIndex"));
	
	-- Tachozeiger / Speedometer animation
	self.tachoZeiger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.SchlueterAnimations.TachoZeiger#zeigerIndex"));
	self.tachoZeigerMultiplicator = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.SchlueterAnimations.TachoZeiger#multiplicator"), 10);
	self.tachoZeigerMaxRotation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.SchlueterAnimations.TachoZeiger#maxRotation"), 245);
	
	-- Temperaturzeiger / temperature Display animation
	self.temperaturZeiger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.SchlueterAnimations.TemperaturZeiger#zeigerIndex"));
	self.temperaturZeigerMaxRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.SchlueterAnimations.TemperaturZeiger#maxRotation"));
	self.tempCnt = 0;
	
	-- Kotflgel / Frontfenders ein und ausblenden /blend on off 
	self.kotfluegelLinks = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.SchlueterAnimations.Frontkotfluegel#indexLinks"));
	self.kotfluegelRechts = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.SchlueterAnimations.Frontkotfluegel#indexRechts"));
	self.lenkWinkelMin = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.SchlueterAnimations.Frontkotfluegel#lenkEinschlagMitKotfluegel"));
	self.lenkWinkelMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.SchlueterAnimations.Frontkotfluegel#lenkEinschlagOhneKotfluegel"));
	
	self.fenderState = true;
	self.changeFenders = SchlueterSuper1500Animations.changeFenders; 

	-- Zustzliche Blinkleuchten in den Armaturen bei angehngten Anhngern / additional lights for turninglights at the dashboard if trailers attached
	self.blinkerLeuchte1L = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.SchlueterAnimations.BlinkerLeuchten#leuchte1L"));
	self.blinkerLeuchte1R = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.SchlueterAnimations.BlinkerLeuchten#leuchte1R"));
	self.blinkerLeuchte2L = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.SchlueterAnimations.BlinkerLeuchten#leuchte2L"));
	self.blinkerLeuchte2R = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.SchlueterAnimations.BlinkerLeuchten#leuchte2R"));
	self.hasAttachedTrailers = 0;
	setVisibility(self.blinkerLeuchte1L, false);
	setVisibility(self.blinkerLeuchte2L, false);
	setVisibility(self.blinkerLeuchte1R, false);
	setVisibility(self.blinkerLeuchte2R, false);
	
	-- Tankleuchte leuchtet auf sobald im Tank zu wenig drin ist / warning light if fuel level low
	self.tankLeuchte = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.SchlueterAnimations.TankLeuchte#index"));
	self.tankMinWarnLevel = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.SchlueterAnimations.TankLeuchte#minWarnLevel"));
	setVisibility(self.tankLeuchte, false);
	
	-- Ladekontrollleuchte / Batterie load light
	self.ladeLeuchte = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.SchlueterAnimations.LadeKontrollLeuchte#index"));
	setVisibility(self.ladeLeuchte, false);
	self.ladeLeuchteOn = 0;
	self.ladeTimer = 50;
	
end;
function SchlueterSuper1500Animations:delete()
end;
function SchlueterSuper1500Animations:mouseEvent(posX, posY, isDown, isUp, button)
end;
function SchlueterSuper1500Animations:keyEvent(unicode, sym, modifier, isDown)
end;
-- Kotflgel und Lenkwinkel einstellen
function SchlueterSuper1500Animations:readStream(streamId, connection)  
     self:changeFenders(streamReadBool(streamId), true);  
end;
function SchlueterSuper1500Animations:writeStream(streamId, connection)  
    streamWriteBool(streamId, self.fenderState);  
end;
function SchlueterSuper1500Animations:changeFenders(state, noEventSend)
	setFenderStateEvent.sendEvent(self, state, noEventSend);
	self.fenderState = state;
	if self.fenderState then
		setVisibility(self.kotfluegelLinks, true);
		setVisibility(self.kotfluegelRechts, true);
		self.wheels[1].rotMax = Utils.degToRad(self.lenkWinkelMin);
		self.wheels[1].rotMin = Utils.degToRad(-self.lenkWinkelMin);
		self.wheels[2].rotMax = Utils.degToRad(self.lenkWinkelMin);
		self.wheels[2].rotMin = Utils.degToRad(-self.lenkWinkelMin);		
	else
		setVisibility(self.kotfluegelLinks, false);
		setVisibility(self.kotfluegelRechts, false);	
		self.wheels[1].rotMax = Utils.degToRad(self.lenkWinkelMax);
		self.wheels[1].rotMin = Utils.degToRad(-self.lenkWinkelMax);
		self.wheels[2].rotMax = Utils.degToRad(self.lenkWinkelMax);
		self.wheels[2].rotMin = Utils.degToRad(-self.lenkWinkelMax);		
	end;
end;
function SchlueterSuper1500Animations:updateTick(dt)
	-- Zustzliche Blinkleuchten in den Armaturen bei angehngten Anhngern / additional lights for turninglights at the dashboard if trailers attached
	if table.getn(self.attachedImplements) > 0 or self.hasAttachedTrailers > 0 then
		self.hasAttachedTrailers = 0;
		for i=1, table.getn(self.attachedImplements) do  
			if self.attachedImplements[i].object.lastFillDelta ~= nil then -- "catch" all trailers 
				self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
			elseif self.attachedImplements[i].object.isSprayerFilling ~= nil and self.attachedImplements[i].object.wheels[1] ~= nil then -- "catch" manure and dung spreader with wheels --> "trailers", too
				self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
			end;
			if table.getn(self.attachedImplements[i].object.attachedImplements) > 0 then -- maybe the trailer has also attached a trailer.. 
				for r=1, table.getn(self.attachedImplements[i].object.attachedImplements) do
					if self.attachedImplements[i].object.attachedImplements[r].object.lastFillDelta ~= nil then -- "catch" attached trailer at the trailer here
						self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
					end;
				end;
			end;
		end;
		if self.hasAttachedTrailers == 0 then
			setVisibility(self.blinkerLeuchte1L, false);
			setVisibility(self.blinkerLeuchte2L, false);
			setVisibility(self.blinkerLeuchte1R, false);
			setVisibility(self.blinkerLeuchte2R, false);
		elseif self.hasAttachedTrailers == 1 then
			setVisibility(self.blinkerLeuchte1L, true);
			setVisibility(self.blinkerLeuchte2L, false);
			setVisibility(self.blinkerLeuchte1R, true);
			setVisibility(self.blinkerLeuchte2R, false);			
		elseif self.hasAttachedTrailers == 2 then
			setVisibility(self.blinkerLeuchte1L, true);
			setVisibility(self.blinkerLeuchte2L, true);	
			setVisibility(self.blinkerLeuchte1R, true);
			setVisibility(self.blinkerLeuchte2R, true);			
		end;
	end;
	
end;
function SchlueterSuper1500Animations:update(dt)	
	-- Kotflgel / Frontfenders ein und ausblenden /blend on off 
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.KotfluegelOnOff) then
			self:changeFenders(not self.fenderState);
		end;
	end;
	if self:getIsActive() then
		if self.isMotorStarted then
			-- Ladekontrollleuchte / Batterie load light
			if self.ladeLeuchteOn == 1 then
				setVisibility(self.ladeLeuchte, true);
				if self.movingDirection ~= 0 then
					self.timerTrue = true;
				end;
				if self.timerTrue then
					self.ladeTimer = math.max(self.ladeTimer - 0.1, 0);
				end;
				if self.ladeTimer == 0 then
					setVisibility(self.ladeLeuchte, false);
					self.timerTrue = nil;
					self.ladeLeuchteOn = 0;
					self.ladeTimer = 50;
				end;
			end;
						
			-- Tankleuchte leuchtet auf sobald im Tank zu wenig drin ist / warning light if fuel level low
			local actualTankInhalt = 0;
			if self.fuelCapacity > 0 then
				actualTankInhalt = (self.fuelFillLevel / self.fuelCapacity + 0.0001) * 100;
			end;
			if actualTankInhalt < self.tankMinWarnLevel then
				setVisibility(self.tankLeuchte, true);
			else
				setVisibility(self.tankLeuchte, false);
			end;
		
			-- Zapfwellenstummel / Powershaft rotation
			rotate(self.stummelIndex, 0,0,0.001*dt);
			
			-- Tachozeiger / speedometer animation
			self.kmhMath = math.min(100, math.max(0, self.lastSpeed*self.speedDisplayScale*3600));
			local zeigerRotation = self.kmhMath * self.tachoZeigerMultiplicator;
			if zeigerRotation <= self.tachoZeigerMaxRotation then
				setRotation(self.tachoZeiger, 0, -Utils.degToRad(zeigerRotation), 0);
			else
				setRotation(self.tachoZeiger, 0, -Utils.degToRad(self.tachoZeigerMaxRotation), 0);	
			end;
			
			-- Temperaturanzeiger / temperature display animation und / and berechnung / calculation
			if self.tempCnt < 3000 then
				setRotation(self.temperaturZeiger, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt), 0);
				self.tempCnt = self.tempCnt + 0.5;
			elseif self.tempCnt > 3000 and self.tempCnt < 6000 then
				setRotation(self.temperaturZeiger, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt), 0);
				self.tempCnt = math.min(self.tempCnt + 0.2, 10000);			
			else
				setRotation(self.temperaturZeiger, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt), 0);
				self.tempCnt = math.min(self.tempCnt + 0.05, 10000);
			end;
		end;
	else
		self.tempCnt = math.max(self.tempCnt - 0.08, 0);
	end;
end;
function SchlueterSuper1500Animations:draw()
	g_currentMission:addHelpButtonText(g_i18n:getText("TOGGLE_FENDERS"), InputBinding.KotfluegelOnOff);
end;
function SchlueterSuper1500Animations:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local state = Utils.getNoNil(getXMLBool(xmlFile, key.."#fenderState"));
		self:changeFenders(state);
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function SchlueterSuper1500Animations:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'fenderState="'..tostring(self.fenderState)..'"';
	local nodes = nil;
	return attributes,nodes;
end;

function SchlueterSuper1500Animations:onEnter()
	self.ladeLeuchteOn = 1;
end;
function SchlueterSuper1500Animations:onLeave()
	self.ladeLeuchteOn = 0;
end;


setFenderStateEvent = {};
setFenderStateEvent_mt = Class(setFenderStateEvent, Event);
InitEventClass(setFenderStateEvent, "setFenderStateEvent");

function setFenderStateEvent:emptyNew()  
    local self = Event:new(setFenderStateEvent_mt );
    self.className="setFenderStateEvent";
    return self;
end;
function setFenderStateEvent:new(vehicle, state) 
    self.vehicle = vehicle;
    self.state = state;
    return self;
end;
function setFenderStateEvent:readStream(streamId, connection)  
    local id = streamReadInt32(streamId); 
    self.state = streamReadBool(streamId); 
    self.vehicle = networkGetObject(id); 
    self:run(connection);  
end;
function setFenderStateEvent:writeStream(streamId, connection)   
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
    streamWriteBool(streamId, self.state );   
end;
function setFenderStateEvent:run(connection) 
    self.vehicle:changeFenders(self.state, true);
	if not connection:getIsServer() then  
		g_server:broadcastEvent(setFenderStateEvent:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;
function setFenderStateEvent.sendEvent(vehicle, state, noEventSend)  
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then   
			g_server:broadcastEvent(setFenderStateEvent:new(vehicle, state), nil, nil, vehicle);
		else 
			g_client:getServerConnection():sendEvent(setFenderStateEvent:new(vehicle, state));
		end;
	end;
end;