accensioneStatsEvent = {};
accensioneStatsEvent_mt = Class(accensioneStatsEvent, Event);

InitEventClass(accensioneStatsEvent, "accensioneStatsEvent");

function accensioneStatsEvent:emptyNew()
    local self = Event:new(accensioneStatsEvent_mt);
    self.className="accensioneStatsEvent";
    return self;
end;

function accensioneStatsEvent:new(vehicle)
    local self = accensioneStatsEvent:emptyNew()
    self.vehicle = vehicle;
    return self;
end;

function accensioneStatsEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
	self.vehicle.fuelConsumption = streamReadFloat32(streamId);
	self.vehicle.distanceDriven = streamReadFloat32(streamId);
	self.vehicle.fuelUsed = streamReadFloat32(streamId);
	self.vehicle.runningTime = streamReadFloat32(streamId);
	if not connection:getIsServer() then
		g_server:broadcastEvent(accensioneStatsEvent:new(self.vehicle), nil, connection, self.vehicle);
	end;
end;

function accensioneStatsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteFloat32(streamId, self.vehicle.fuelConsumption);
	streamWriteFloat32(streamId, self.vehicle.distanceDriven);
	streamWriteFloat32(streamId, self.vehicle.fuelUsed);
	streamWriteFloat32(streamId, self.vehicle.runningTime);
end;

function accensioneStatsEvent.sendEvent(vehicle, isTransport)
	if g_server ~= nil then
		g_server:broadcastEvent(accensioneStatsEvent:new(vehicle), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(accensioneStatsEvent:new(vehicle));
	end;
end;

