

Marker = {};

function Marker.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations); 
end;

function Marker:load(xmlFile)	
	
	local MarkPrXNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.MarkPr#index"));
    if MarkPrXNode ~= nil then
        self.MarkPr = {};
        self.MarkPr.node = MarkPrXNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.MarkPr#minRot"));
        self.MarkPr.minRot = {};
        self.MarkPr.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.MarkPr.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.MarkPr.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.MarkPr#maxRot"));
        self.MarkPr.maxRot = {};
        self.MarkPr.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.MarkPr.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.MarkPr.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.MarkPr.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.MarkPr#rotTime"), 2)*1000;
        self.MarkPr.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.MarkPr#touchRotLimit"), 5));
    end;
	
	local MarkLevXNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.MarkLev#index"));
    if MarkLevXNode ~= nil then
        self.MarkLev = {};
        self.MarkLev.node = MarkLevXNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.MarkLev#minRot"));
        self.MarkLev.minRot = {};
        self.MarkLev.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.MarkLev.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.MarkLev.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.MarkLev#maxRot"));
        self.MarkLev.maxRot = {};
        self.MarkLev.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.MarkLev.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.MarkLev.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.MarkLev.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.MarkLev#rotTime"), 2)*1000;
        self.MarkLev.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.MarkLev#touchRotLimit"), 5));
    end;	
	
	self.FrameLev = false;	
	self.FramePr = false;	

end;

function Marker:delete()

end;

function Marker:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Marker:keyEvent(unicode, sym, modifier, isDown)
end;

function Marker:update(dt)

			
    if self.attacherVehicle then

		if self.isActive then
		
			if InputBinding.hasEvent(InputBinding.TRANSPORT_MARKPR) then
				self.FramePr = not self.FramePr;				
			end;		
		
			if InputBinding.hasEvent(InputBinding.TRANSPORT_MARKLEV) then
				self.FrameLev = not self.FrameLev;				
			end;
			
			if  self.FramePr then
				self.MarkPrMax = true;
				self.MarkPrMin = false;	
				setJointRotationLimit(self.componentJoints[4].jointIndex, 2, true, math.rad(-5), math.rad(5));			
				else
				self.MarkPrMax = false;
				self.MarkPrMin = true;			
				setJointRotationLimit(self.componentJoints[4].jointIndex, 2, true, math.rad(-10), math.rad(10));				
			end;			
			if  self.FrameLev then
				self.MarkLevMax = true;
				self.MarkLevMin = false;	
				setJointRotationLimit(self.componentJoints[5].jointIndex, 2, true, math.rad(-5), math.rad(5));				
				else
				self.MarkLevMax = false;
				self.MarkLevMin = true;				
				setJointRotationLimit(self.componentJoints[5].jointIndex, 2, true, math.rad(-10), math.rad(10));					
			end;
						
			setJointFrame(self.componentJoints[4].jointIndex, 1,self.componentJoints[4].jointNode);	
			setJointFrame(self.componentJoints[5].jointIndex, 1,self.componentJoints[5].jointNode);			
			
			local doRotate = self.MarkPrMax or self.MarkPrMin
			if self.MarkPr ~= nil and doRotate then
				local x, y, z = getRotation(self.componentJoints[4].jointNode);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.MarkPr.maxRot, self.MarkPr.minRot, 3, self.MarkPr.rotTime, dt, not self.MarkPrMax);
				setRotation(self.componentJoints[4].jointNode,unpack(newRot));
			end;
			local doRotate = self.MarkLevMax or self.MarkLevMin
			if self.MarkLev ~= nil and doRotate then
				local x, y, z = getRotation(self.componentJoints[5].jointNode);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.MarkLev.maxRot, self.MarkLev.minRot, 3, self.MarkLev.rotTime, dt, not self.MarkLevMax);
				setRotation(self.componentJoints[5].jointNode,unpack(newRot));
			end;		
					
		end;
	end;	
end;

function Marker:draw()
	if self.FrameLev then
		g_currentMission:addHelpButtonText(g_i18n:getText("MarkerleftOff"), InputBinding.TRANSPORT_MARKLEV);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("MarkerleftOn"), InputBinding.TRANSPORT_MARKLEV);
	end;
	if self.FramePr then
		g_currentMission:addHelpButtonText(g_i18n:getText("MarkerrightOff"), InputBinding.TRANSPORT_MARKPR);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("MarkerrightOn"), InputBinding.TRANSPORT_MARKPR);
	end;	
end;

function Marker:onDetach()

end;

function Marker:onAttach()
end; 
function Marker:onLeave()

end;

function Marker:onActivate()
end;

function Marker:onDeactivate()

end;

function Marker:CarrierWorkingTime(diffTime)

end; 


