STSgelberBulle = {};
function STSgelberBulle.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;
function STSgelberBulle:load(xmlFile)

	self.changeOil = SpecializationUtil.callSpecializationsFunction("changeOil");
	self.setNewLimit = SpecializationUtil.callSpecializationsFunction("setNewLimit");
	self.setblends1Visibility = SpecializationUtil.callSpecializationsFunction("setblends1Visibility");
	self.setblends2Visibility = SpecializationUtil.callSpecializationsFunction("setblends2Visibility");

	self.oilChange = {};
	self.oilChange.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.oilChange#oilChangeCheckString"), "OilChange");
	self.oilChange.oilInRange = nil;

	self.oilLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dashboardOil#index"));

	self.shouldChangeOil = false;
	self.nextOilChange = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.oilChange#firstOilChange"), 3600)
	self.oilChangeInterval = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.oilChange#interval"), 3600)

	self.checkOilOverlay = Overlay:new("hudcheckOilOverlay", Utils.getFilename("Textur/CheckEngineOil.png", self.baseDirectory), 0.925, 0.55, 0.03125, 0.05);
	
    self.blends1 = {};
    local i = 0;
    while true do
    local key = string.format("vehicle.mirrors.mirror(%d)", i);
    if not hasXMLProperty(xmlFile, key) then
        break;
    end;
    local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
    if node ~= nil then
        setVisibility(node, false);
        table.insert(self.blends1, {node=node});
    end;
    i = i + 1;
    end;
    self.blends1Active = false;
	
    self.blends2 = {};
    local i = 0;
    while true do
    local key = string.format("vehicle.chains.chain(%d)", i);
    if not hasXMLProperty(xmlFile, key) then
        break;
    end;
    local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
    if node ~= nil then
        setVisibility(node, false);
        table.insert(self.blends2, {node=node});
    end;
    i = i + 1;
    end;
	self.blends2Active = false;
	for i,v in ipairs(self.specializations) do
		if v == Attachable then
			table.remove(self.specializations,i);
			break;
		end;
	end;	

	self.drivingHydraulicCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.drivingHydraulic#count"), 0);	
	if self.drivingHydraulicCount == 0 then
    end;
	
	self.drivingHydraulic = {};	
	for i=1, self.drivingHydraulicCount do
		local hydraulicName = string.format("vehicle.drivingHydraulic.drivingHydraulic%d", i);
		
		self.drivingHydraulic[i] = {};		
		self.drivingHydraulic[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#hydraulic"));
		self.drivingHydraulic[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#hydraulicPunch"));
		self.drivingHydraulic[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#hydraulicPunchFixPoint"));
		self.drivingHydraulic[i].fenderFixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fenderFixPoint"));
		local ax, ay, az = getWorldTranslation(self.drivingHydraulic[i].punch);
		local bx, by, bz = getWorldTranslation(self.drivingHydraulic[i].translationPunch);		
		self.drivingHydraulic[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);	
	end;

	self.Odometer = {};

	self.Odometer.Trip = 0;
	self.Odometer.Reading = 0;

	self.Odometer.posX = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.odometer#posX"), 0.7543);
	self.Odometer.posY = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.odometer#posY"), 0.2140);
	self.Odometer.HUD = Overlay:new("OdometerOverlay", Utils.getFilename("Textur/odometer_hud.png", self.baseDirectory), self.Odometer.posX, self.Odometer.posY, 0.2371, 0.039525);

	self.Odometer.Divisor = 20; -- Game units to tenths of a mile ratio, currently set to best guess

	self.setNewLimit = SpecializationUtil.callSpecializationsFunction("setNewLimit");

	self.ESLimiter = {};
	self.ESLimiter.maxRPM = {};
	self.ESLimiter.orgMaxRPM = {};
	self.ESLimiter.percentage = {};
		
	for k,_ in pairs(self.motor.maxRpm) do	
		local percentage = string.format("%d",(self.motor.maxRpm[k] * 100 / self.motor.maxRpm[3]));
		self.ESLimiter.percentage[k+1] = tonumber(percentage);
		self.ESLimiter.maxRPM[k+1] = self.motor.maxRpm[3];
		self.ESLimiter.orgMaxRPM[k+1] = self.motor.maxRpm[k];
	end;
	-- set limits for reverse
	self.ESLimiter.maxRPM[1] = self.ESLimiter.maxRPM[2];
	self.ESLimiter.percentage[1] = self.ESLimiter.percentage[2];	
	self.ESLimiter.default = self.motor.maxRpm[3];
	
	self.isLimiterActive = false;
	self.ESLimiter.isButtonPressed = false;
	self.doReset = false;
	
	self.ESLimiter.xPos = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.ESLimiter#posX"), 0.7543);
	self.ESLimiter.yPos = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.ESLimiter#posY"), 0.1715);
	self.ESLimiter.hudBarWidth = 0.205;
	self.ESLimiter.overlay = Overlay:new("hudESLOverlay", Utils.getFilename("Textur/ESLimiter_hud.png", self.baseDirectory), self.ESLimiter.xPos, self.ESLimiter.yPos, 0.2371, 0.039525);
	self.ESLimiter.overlayBg = Overlay:new("hudESLBackground", Utils.getFilename("Textur/ESLimiter_bg.png", self.baseDirectory), self.ESLimiter.xPos, self.ESLimiter.yPos, 0.2371, 0.039525);
	self.ESLimiter.overlayBar = Overlay:new("hudESLbar", Utils.getFilename("Textur/ESLimiter_bar.png", self.baseDirectory), self.ESLimiter.xPos + 0.123, self.ESLimiter.yPos + 0.0085714, 0.205, 0.02190);
	self.ESLimiter.lock = Overlay:new("hudESLlock", Utils.getFilename("$dataS/menu/locked_icon.png", self.baseDirectory), self.ESLimiter.xPos + 0.12581, self.ESLimiter.yPos + 0.0095, 0.015, 0.02);	

	self.addOperatingTime = SpecializationUtil.callSpecializationsFunction("addOperatingTime");
	self.operatingTime = 0;	
	self.ohX = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.operatingHours#posX"), 0.7543);
	self.ohY = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.operatingHours#posY"), 0.1715);
	self.yOffset = 0.0077;
	self.ohOverlay = Overlay:new("hudOHOverlay", Utils.getFilename("Textur/OperatingHours_hud.png", self.baseDirectory), self.ohX, self.ohY, 0.11855, 0.039525);	

	self.exhaustingSystem = {};	
	self.exhaustingSystem.cap = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dynamicExhaustingSystem#cap"));
	self.exhaustingSystem.maxRot = Utils.degToRad(Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.dynamicExhaustingSystem#maxRot"),0));
	self.exhaustingSystem.maxRpm = self.motor:getMaxRpm();
	
	local startSequence = AnimCurve:new(linearInterpolator4);
	local i=0;
	while true do
		local path = string.format("vehicle.dynamicExhaustingSystem.startSequence.key(%d)", i);
		local timeStamp = getXMLFloat(xmlFile, path .. "#time");
		if timeStamp == nil then
			break;
		end;
		local r,g,b,alpha = Utils.getVectorFromString(getXMLString(xmlFile, path .. "#value"));
		startSequence:addKeyframe({x=r, y=g, z=b, w=alpha, time=timeStamp})		
		i = i + 1;
	end;
	self.exhaustingSystem.minAlpha = math.min(math.abs(Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.dynamicExhaustingSystem#minAlpha"),0)),1);
	self.exhaustingSystem.maxAlpha = math.min(math.abs(Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.dynamicExhaustingSystem#maxAlpha"),1)),1);
	local x1,y1,z1,w1 = startSequence:get(1.0);
	self.exhaustingSystem.startSequence = startSequence;
	self.exhaustingSystem.lastValue = {x=x1,y=y1,z=z1,w=w1};
	self.exhaustingSystem.param = getXMLString(xmlFile, "vehicle.dynamicExhaustingSystem#param");
	self.exhaustingSystem.offset = 0;
	self.exhaustingSystem.deltaTime = 0;
	
	self.frontHydraulic = {};
	self.frontHydraulic.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontHydraulic#hydraulic"));
	self.frontHydraulic.punch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontHydraulic#hydraulicPunch"));
	self.frontHydraulic.translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontHydraulic#hydraulicPunchFixPoint"));
	self.frontHydraulic.armFixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontHydraulic#armFixPoint"));
	local ax, ay, az = getWorldTranslation(self.frontHydraulic.punch);
    local bx, by, bz = getWorldTranslation(self.frontHydraulic.translationPunch);
    self.frontHydraulic.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);	
	self.frontHydraulic.topArmPart2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontHydraulic#part2"));

	self.backHydraulic = {};
	self.backHydraulic.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#hydraulic"));
	self.backHydraulic.punch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#hydraulicPunch"));
	self.backHydraulic.translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#hydraulicPunchFixPoint"));
	self.backHydraulic.rootArmFixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#rootArmFixPoint"));
	self.backHydraulic.rootArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#rootArm"));
	self.backHydraulic.rootArmPart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#rootArmPart"));
	self.backHydraulic.armFixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#armFixPoint"));
	self.backHydraulic.rootArmPartFixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#rootArmPartFixPoint"));
	local ax, ay, az = getWorldTranslation(self.backHydraulic.punch);
    local bx, by, bz = getWorldTranslation(self.backHydraulic.translationPunch);
    self.backHydraulic.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	ax, ay, az = getWorldTranslation(self.backHydraulic.rootArmPart);
    bx, by, bz = getWorldTranslation(self.backHydraulic.rootArmPartFixPoint);
    self.backHydraulic.rootArmDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);

    self.bunkerSiloCompactingScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.bunkerSiloCompacter#compactingScale"), 1);
    self.bunkerSiloCompactingRefNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.bunkerSiloCompacter#refNode"));

	local i=0;
    while true do
        local baseName = string.format("vehicle.attacherJoints.attacherJoint(%d)", i);
        local index = getXMLString(xmlFile, baseName.. "#index");
        if index == nil then
            break;
        end;		
		local joint = self.attacherJoints[i+1];
		local shaftAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#shaft"));
		if shaftAttacher ~= nil then
			joint.powerShaftAttacher = shaftAttacher;
		end;
		
		i = i + 1;
	end;
    
	local attacherJointCount = i;
	i = 0;
    while true do
        local baseName = string.format("vehicle.trailerAttacherJoints.trailerAttacherJoint(%d)", i);
        local index = getXMLString(xmlFile, baseName.. "#index");
        if index == nil then
            break;
        end;
		
		local joint = self.attacherJoints[attacherJointCount + 1 + i];
		local shaftAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#shaft"));
		if shaftAttacher ~= nil then
			joint.powerShaftAttacher = shaftAttacher;
		end;
        i = i+1;
    end;
    
	g_currentMission.hudAttachmentOverlay:setPosition(g_currentMission.hudAttachmentOverlay.x, 0.28);
	g_currentMission.hudTipperOverlay:setPosition(g_currentMission.hudTipperOverlay.x, 0.28);
	g_currentMission.hudFuelOverlay:setPosition(g_currentMission.hudFuelOverlay.x, 0.28);
    for fruitName, fruitType in pairs(FruitUtil.fruitTypes) do
        if fruitType.hudFruitOverlayFilename ~= nil then
			if g_currentMission.fruitOverlays[fruitType.index] ~= nil then
				g_currentMission.fruitOverlays[fruitType.index]:setPosition(g_currentMission.fruitOverlays[fruitType.index].x, 0.38);
			end;
        end;
    end;
		 
    self.allradState = STSgelberBulle.allradState;

    self.AllradV2Active = true;
	 
	self.wellenCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Allradwellen.Wellen#count"), 0);	 
	self.Wellen = {}
	if self.wellenCount ~= 0 and self.wellenCount ~= nil then
	    for i=1, self.wellenCount do
	        local Welle = string.format("vehicle.Allradwellen.Welle%d", i)
		    self.Wellen[i] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, Welle .. "#index"));
	    end;
	end;
	self.hudAllradPosX = 0.65;
    self.hudAllradWidth = 0.08;
    self.hudAllradPosY = 0.13;
    self.hudAllradHeight = 0.08;
	self.infoPanelAllradONPath = Utils.getFilename("Textur/AllradON.png", self.baseDirectory);
	self.hudAllradONOverlay = Overlay:new("hudAllradOverlayON", self.infoPanelAllradONPath, self.hudAllradPosX, self.hudAllradPosY, self.hudAllradWidth, self.hudAllradHeight);
	self.infoPanelAllradOFFPath = Utils.getFilename("Textur/AllradOFF.png", self.baseDirectory);
	self.hudAllradOFFOverlay = Overlay:new("hudAllradOverlayOFF", self.infoPanelAllradOFFPath, self.hudAllradPosX, self.hudAllradPosY, self.hudAllradWidth, self.hudAllradHeight);

	self.wheelParticleSystems = {};
    local psFile = getXMLString(xmlFile, "vehicle.wheelParticleSystems#file");
    if psFile ~= nil then
        local i=0;
        while true do
            local baseName = string.format("vehicle.wheelParticleSystems.wheelParticleSystem(%d)", i);
            local node = getXMLString(xmlFile, baseName.. "#node");
            if node == nil then
                break;
            end;
            node = Utils.indexToObject(self.components, node);
			self.wheelParticleSystems.node = node;
            if node ~= nil then
                local wheelParticleSystem = {};
                wheelParticleSystem.particleSystems = {};
                Utils.loadParticleSystem(xmlFile, wheelParticleSystem.particleSystems, "vehicle.wheelParticleSystems", node, false, nil, self.baseDirectory);
                table.insert(self.wheelParticleSystems, wheelParticleSystem);
            end;
            i = i+1;
        end;
    end;

	self.showhudAllrad = true;
	self.showHelp = false;	
	self.isSelectable = true;	
end;
function STSgelberBulle:delete()

    if self.hudAllradONOverlay ~= nil or self.hudAllradOFFOverlay ~= nil then
		self.hudAllradONOverlay:delete();
		self.hudAllradOFFOverlay:delete();		
	end;
	for i=1, table.getn(self.wheelParticleSystems) do
		Utils.deleteParticleSystem(self.wheelParticleSystems[i].particleSystems);
    end;
end;
function STSgelberBulle:readStream(streamId, connection)
	self.isLoading = true;
	local visibility = streamReadBool(streamId);
	self:setblends1Visibility(visibility, true);
	self:setblends2Visibility(visibility, true);
	self:addOperatingTime(streamReadFloat32(streamId), true);
	self.Odometer.Trip = streamReadFloat32(streamId);
	self.Odometer.Reading = streamReadFloat32(streamId); 
    self:allradState(streamReadBool(streamId), true); 
    self.shouldChangeOil = streamReadBool(streamId);
    self.nextOilChange = streamReadInt32(streamId);
	for level,_ in pairs(self.ESLimiter.percentage) do
		local percentage = streamReadInt16(streamId)/10;
		self:setNewLimit(level, percentage, true);
	end;
end;
function STSgelberBulle:writeStream(streamId, connection)
	streamWriteFloat32(streamId, self.operatingTime);
	streamWriteFloat32(streamId, self.Odometer.Trip);
	streamWriteFloat32(streamId, self.Odometer.Reading); 
    streamWriteBool(streamId, self.AllradV2Active); 
    streamWriteBool(streamId, self.shouldChangeOil);
    streamWriteInt32(streamId, self.nextOilChange);
	streamWriteBool(streamId, self.blends1Active);
	streamWriteBool(streamId, self.blends2Active);
	for _,percentage in pairs(self.ESLimiter.percentage) do
		streamWriteInt16(streamId, percentage*10);
	end;
end;
function STSgelberBulle:mouseEvent(posX, posY, isDown, isUp, button)
end;
function STSgelberBulle:keyEvent(unicode, sym, modifier, isDown)
end;
function STSgelberBulle:allradState(state, noEventSend) 
    AllradStateEvent.sendEvent(self, state, noEventSend);	
    self.AllradV2Active = state;
end;
function STSgelberBulle:update(dt)	

	if g_currentMission.environment ~= nil and g_currentMission.environment.dayNightCycle and
              (g_currentMission.environment.dayTime > (20.5*1000*60*60) or g_currentMission.environment.dayTime < (5.5*1000*60*60)) and
              not self.lightsActive and self.isHired and not self.steeringEnabled then
		self.lightsActive = true;
	end;

	if not self.isHired and self.lightsActive and not self.isEntered or not g_currentMission.environment.dayNightCycle then
		self.lightsActive = false;
	end;


    for k, light in pairs(self.lights) do
        setVisibility(light, self.lightsActive);
    end; 
	
	if self:getIsActiveForInput(true) then
	
        if InputBinding.hasEvent(InputBinding.mirrorSTSGB) then
              self:setblends1Visibility(not self.blends1Active);
        end;
        if InputBinding.hasEvent(InputBinding.kettenSTSGB) then
              self:setblends2Visibility(not self.blends2Active);
        end;
		if InputBinding.hasEvent(InputBinding.SHOW_HELP_STSGB) then
			self.showHelp = not self.showHelp;
		end;
		if InputBinding.hasEvent(InputBinding.ALLRADSTSGB) then
		   	self.AllradV2Active = not self.AllradV2Active;
		end;
		
		if self.exhaustingSystem.cap ~= nil then
			local angle = math.rad(math.random(-20,5)) + self.exhaustingSystem.maxRot * self.motor.lastMotorRpm / self.exhaustingSystem.maxRpm;	
			angle = math.max(math.min(angle, 0), self.exhaustingSystem.maxRot);		
			setRotation(self.exhaustingSystem.cap, 0,0,angle);
		end;
		
		if self.time <= self.playMotorSoundTime then
			local time = (self.exhaustingSystem.deltaTime - (self.playMotorSoundTime - self.time)) / self.exhaustingSystem.deltaTime;
			local x1,y1,z1,w1 = self.exhaustingSystem.startSequence:get(time);
			local values = self.exhaustingSystem.lastValue;
			if math.abs(values.x - x1) > 0.01 or math.abs(values.y - y1) > 0.01 or math.abs(values.z - z1) > 0.01 or math.abs(values.w - w1) > 0.01 then
				setShaderParameter(self.exhaustParticleSystems[1].shape, self.exhaustingSystem.param, x1, y1, z1, w1, false);
				self.exhaustingSystem.lastValue = {x=x1, y=y1, z=z1, w=w1};
			end;
		else
			local alpha = ((self.exhaustingSystem.maxAlpha-self.exhaustingSystem.minAlpha) * self.motor.lastMotorRpm / self.exhaustingSystem.maxRpm)+self.exhaustingSystem.minAlpha;
			if math.abs(self.exhaustingSystem.lastValue.w - alpha) > 0.01 then
				local values = self.exhaustingSystem.lastValue;
				setShaderParameter(self.exhaustParticleSystems[1].shape, self.exhaustingSystem.param, values.x, values.y, values.z, alpha, false);
				self.exhaustingSystem.lastValue.w = alpha;
			end;
		end;
		if self.frontHydraulic ~= nil then
			local ax, ay, az = getWorldTranslation(self.frontHydraulic.node);
			local bx, by, bz = getWorldTranslation(self.frontHydraulic.armFixPoint);
			local x, y, z = worldDirectionToLocal(getParent(self.frontHydraulic.node), bx-ax, by-ay, bz-az);
			setDirection(self.frontHydraulic.node, x, y, z, 0, 1, 0);
			if self.frontHydraulic.punch ~= nil then
				local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
				setTranslation(self.frontHydraulic.punch, 0, 0, distance-self.frontHydraulic.punchDistance);
			end;
		end;
		
		if self.backHydraulic ~= nil then
			local x, y, z = getRotation(getParent(getParent(self.backHydraulic.armFixPoint)));
			setRotation(self.backHydraulic.rootArm, x, y, z);	

			local ax, ay, az = getWorldTranslation(self.backHydraulic.rootArmPart);
			local bx, by, bz = getWorldTranslation(self.backHydraulic.armFixPoint);
			x, y, z = worldDirectionToLocal(getParent(self.backHydraulic.rootArmPart), bx-ax, by-ay, bz-az);
			setDirection(self.backHydraulic.rootArmPart, x, y, z, 0, 0, 1);	
						
			if self.backHydraulic.rootArmPart ~= nil then
				local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
				local xScale, yScale, zScale = getScale(self.backHydraulic.rootArmPart);
				local newScale = zScale * (distance / self.backHydraulic.rootArmDistance);
				setScale(self.backHydraulic.rootArmPart, 1, 1, newScale);
			end;		
		
			ax, ay, az = getWorldTranslation(self.backHydraulic.node);
			bx, by, bz = getWorldTranslation(self.backHydraulic.rootArmFixPoint);
			x, y, z = worldDirectionToLocal(getParent(self.backHydraulic.node), bx-ax, by-ay, bz-az);
			setDirection(self.backHydraulic.node, x, y, z, 0, 1, 1);
			if self.backHydraulic.punch ~= nil then
				local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
				local x,y,z = getTranslation(self.backHydraulic.punch);
				setTranslation(self.backHydraulic.punch, x, y, (distance-self.backHydraulic.punchDistance));
			end;			
		end;	
	end;

	for i=1, table.getn(self.drivingHydraulic) do
		local ax, ay, az = getWorldTranslation(self.drivingHydraulic[i].node);
		local bx, by, bz = getWorldTranslation(self.drivingHydraulic[i].fenderFixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.drivingHydraulic[i].node), bx-ax, by-ay, bz-az);
		
		setDirection(self.drivingHydraulic[i].node, x, y, z, 0, 1, 0);
		if self.drivingHydraulic[i].punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.drivingHydraulic[i].punch, 0, 0, distance-self.drivingHydraulic[i].punchDistance);
		end;	
	end; 
		
	if self:getIsActive() then	
   		if self.AllradV2Active == true then
			self.showhudAllrad = true;		
			self.wheels[1].driveMode =2
		 	self.wheels[2].driveMode =2
		 	self.wheels[3].driveMode =2
		 	self.wheels[4].driveMode =2			
		else
			self.showhudAllrad = false;
		 	self.wheels[1].driveMode =0
			self.wheels[2].driveMode =0
			self.wheels[3].driveMode =2
			self.wheels[4].driveMode =2			
		end; 
	    if self.wellenCount ~= 0 and self.wellenCount ~= nil then
	        local getRx, getRy, getRz = getRotation(self.wheels[3].repr);
	        for i=1, self.wellenCount do
	            setRotation(self.Wellen[i], 0, 0, getRx);
	        end;
	    end;		

		local level = 0;
		if self.movingDirection < 0 then
			level = 1;
		else
			if self.motor.speedLevel > 0 then
				level = self.motor.speedLevel + 1;
			end;
		end;
		
        if self.isClient then
			for _,area in pairs(self.cuttingAreas) do
				if self:getIsAreaActive(area) then
					local x,y,z = getWorldTranslation(area.start);
					local x1,y1,z1 = getWorldTranslation(area.width);
					local x2,y2,z2 = getWorldTranslation(area.height);
					for index,fruit in pairs(g_currentMission.fruits) do
						local fruitDesc = FruitUtil.fruitIndexToDesc[index];
						if fruitDesc.needsSeeding then
							Utils.cutFruitArea(index, x, z, x1, z1, x2, z2);
							Utils.updateFruitCutShortArea(index, x, z, x1, z1, x2, z2, 0);
						end;
					end;
				end;
			end;
        end;
		
		if self:getIsActiveForInput(false) and level ~= 0 then
			local percentage = self.ESLimiter.percentage;
			if InputBinding.isPressed(InputBinding.ESLimiter_PLUS) and percentage[level] < 100 then					
				percentage[level] = percentage[level] + 0.25;
				self:setNewLimit(level, percentage[level], true);
				self.ESLimiter.isButtonPressed = true;
			elseif InputBinding.isPressed(InputBinding.ESLimiter_MINUS) and percentage[level] > 10 then
				percentage[level] = percentage[level] - 0.25;					
				self:setNewLimit(level, percentage[level], true);
				self.ESLimiter.isButtonPressed = true;
			else
				if self.ESLimiter.isButtonPressed then
					self:setNewLimit(level, percentage[level]);
					self.ESLimiter.isButtonPressed = false;
				end;	
			end;
		end;
		
		local oilChange = self.oilChange;
		local oilWarning = (self.nextOilChange * 1000) * 0.9;

		if oilChange.oilInRange ~= nil then
			if self:getIsActiveForInput() then
				if InputBinding.hasEvent(InputBinding.CHANGE_OIL) then
					if oilWarning < self.operatingTime and oilChange.oilInRange.oilCapacity >= 100 then
						oilChange.oilInRange:changeOil(self);
					end;
				end;
				if oilChange.oilInRange.oilCapacity == 0 then
					g_currentMission:addWarning(g_i18n:getText("Out_Of_Oil") .. "\n" .. g_i18n:getText("Buy_More_Oil"));
				end;
			end;
		end;

		if self.shouldChangeOil == false and self.operatingTime > (self.nextOilChange * 1000) then
			self.shouldChangeOil = true;
		end;
		if self.shouldChangeOil then
			self:setIgnition(0);
		end;

		if self.isMotorStarted then
			if oilWarning < self.operatingTime then
				setVisibility(self.oilLight, true);
			else
				setVisibility(self.oilLight, false);
			end;
		end;
		if self.ignitionMode == 0 and self.ignitionMode ~= nil then
			setVisibility(self.oilLight, false)
		end;
	end;	
	
	local dens = 0; local dens1; local dens2; local dens3;
	local x,y,z = getWorldTranslation(self.wheels[2].repr);
	local x1,y1,z1 = getWorldTranslation(self.wheels[1].repr);
	local x2,y2,z2 = getWorldTranslation(self.wheels[4].repr);
	local id = g_currentMission.terrainDetailId;
	local xx, zz, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(id, x, z, x1, z1, x2, z2);
	dens1 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.cultivatorChannel, 1);
	dens2 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.sowingChannel, 1);
	dens3 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.ploughChannel, 1);
	if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
		dens = dens1+dens2+dens3;
	end;
	if dens > 0 and self.lastSpeed*self.speedDisplayScale*3600 > 4 then
		for i=1, table.getn(self.wheelParticleSystems) do
			Utils.setEmittingState(self.wheelParticleSystems[i].particleSystems, self.wheels[i].hasGroundContact);
		end;
	else
		for i=1, table.getn(self.wheelParticleSystems) do
			Utils.setEmittingState(self.wheelParticleSystems[i].particleSystems, false);
		end;
	end;
	
end;
function STSgelberBulle:updateTick(dt)

    if self:getIsActive() or self.isHired then 
		self:addOperatingTime(dt);
		self.Odometer.Trip = self.Odometer.Trip + self.lastMovedDistance;
		self.Odometer.Reading = self.Odometer.Reading + self.lastMovedDistance;
	end;
	
end;
function STSgelberBulle:draw()

	local oilChange = self.oilChange;
	local oilWarning = (self.nextOilChange * 1000) * 0.9;

	if oilChange.oilInRange ~= nil then
		if oilWarning < self.operatingTime then
			g_currentMission:addHelpButtonText(g_i18n:getText("CHANGE_OIL"), InputBinding.CHANGE_OIL);

		end;
	end;

	if oilWarning < self.operatingTime then
		self.checkOilOverlay:render();
	end;

	if self.shouldChangeOil then
		g_currentMission:addWarning(g_i18n:getText("Oil_Change_Iminent") .. "\n" .. g_i18n:getText("Change_The_Oil"));
	end;
	
	local Trip = math.floor(self.Odometer.Trip / self.Odometer.Divisor);
	local Distance = math.floor(self.Odometer.Reading / self.Odometer.Divisor);

	self.Odometer.HUD:render();

	setTextAlignment(RenderText.ALIGN_RIGHT);
	setTextBold(true);
	setTextColor(1,1,1,1);

	renderText(self.Odometer.posX + 0.0770, self.Odometer.posY + 0.009800, 0.02, tostring(Trip));
	renderText(self.Odometer.posX + 0.2170, self.Odometer.posY + 0.009800, 0.02, tostring(Distance));

	setTextAlignment(RenderText.ALIGN_LEFT);
	setTextBold(false);

	local text = "Deaktiviert";
	local currentLevel = self.motor.speedLevel;
	local currentLevelText = 0;
	if self.movingDirection < 0 then
		currentLevel = 1;
		currentLevelText = "R";
	else
		if currentLevel ~= 0 then
			currentLevel = currentLevel + 1;
			currentLevelText = currentLevel - 1;
		end;
	end;
	local percentage = 0;
	if currentLevel ~= 0 then
		percentage = tonumber(string.format("%d", self.ESLimiter.percentage[currentLevel]));
		if percentage < 100 then
			percentage = " " .. percentage;
		end;
		text = g_i18n:getText("ESLimiter_level") .. currentLevelText .. ":" .. percentage .. "% ";	
	end;
	self.ESLimiter.overlayBg:render();
	
	self.ESLimiter.overlayBar.width = self.ESLimiter.hudBarWidth * math.min(1, percentage/195);	
    setOverlayUVs(self.ESLimiter.overlayBar.overlayId, 0, 0.05, 0, 1, math.min(1, percentage/195), 0.05, math.min(1, percentage/195), 1);
	self.ESLimiter.overlayBar:render();
	
	self.ESLimiter.overlay:render();
	setTextBold(true);
	setTextAlignment(RenderText.ALIGN_LEFT);
	setTextColor(0, 0, 0, 1);
    renderText(self.ESLimiter.xPos + 0.136, self.ESLimiter.yPos + 0.007, 0.02, text);	
	setTextColor(1, 1, 1, 1);
	renderText(self.ESLimiter.xPos + 0.136, self.ESLimiter.yPos + 0.010, 0.02, text);	


	local operatingHours = math.floor((self.operatingTime / 1000 / 60 / 60)*10) / 10;
	local hours = math.floor(operatingHours);
	local minutes = tostring(math.floor((operatingHours - hours)*10));
	
	self.ohOverlay:render();
	setTextAlignment(RenderText.ALIGN_RIGHT);
	setTextBold(true);	
	renderText(self.ohX+0.062, self.ohY+self.yOffset, 0.022, tostring(hours) .. ",");
	setTextColor(1,1,1,1);
	renderText(self.ohX+0.071, self.ohY+self.yOffset, 0.023, minutes);
	setTextColor(1,1,1,1);
	renderText(self.ohX+0.08, self.ohY+self.yOffset, 0.023, "h");
	setTextAlignment(RenderText.ALIGN_LEFT);
	
	if not self.showHelp then
		g_currentMission:addHelpButtonText(g_i18n:getText("ShowHelp1"), InputBinding.HUDINFO);
	 else
		renderText(0.757, 0.35, 0.018, "Numpad Enter:");
		renderText(0.865, 0.35, 0.018, "Motor starten/stopen");
		renderText(0.757, 0.365, 0.018, "Numpad 1:");
		renderText(0.865, 0.365, 0.018, "Blinker Links");
		renderText(0.757, 0.38, 0.018, "Numpad 2:");
		renderText(0.865, 0.38, 0.018, "Warnblinker");
		renderText(0.757, 0.395, 0.018, "Numpad 3:");
		renderText(0.865, 0.395, 0.018, "Blinker Rechts");
		renderText(0.757, 0.41, 0.018, "Numpad 4:");
		renderText(0.865, 0.41, 0.018, "Allrad an/aus");
		renderText(0.757, 0.425, 0.018, "Numpad 5:");
		renderText(0.865, 0.425, 0.018, "Arbeitslichtvorn");
		renderText(0.757, 0.44, 0.018, "Numpad 6:");
		renderText(0.865, 0.44, 0.018, "Arbeitslichthinten");
		renderText(0.757, 0.455, 0.018, "Numpad 8:");
		renderText(0.865, 0.455, 0.018, "Spiegel an/aus");
		renderText(0.757, 0.47, 0.018, "Numpad 9:");
		renderText(0.865, 0.47, 0.018, "Ketten an/aus");
		renderText(0.757, 0.485, 0.018, "F:");
		renderText(0.865, 0.485, 0.018, "Abblendlicht");
		renderText(0.757, 0.5, 0.018, "F halten:");
		renderText(0.865, 0.5, 0.018, "Fernlicht");
		renderText(0.757, 0.515, 0.018, "Pos1:");
		renderText(0.865, 0.515, 0.018, "Rundumleuchte");
		renderText(0.757, 0.53, 0.018, "0:");
		renderText(0.865, 0.53, 0.018, "Hupe");
		renderText(0.757, 0.545, 0.018, "Bild runter:");
		renderText(0.865, 0.545, 0.018, "RPM-");
		renderText(0.757, 0.56, 0.018, "Bild rauf:");
		renderText(0.865, 0.56, 0.018, "RPM+");
		renderText(0.757, 0.575, 0.018, "Spacetaste:");
		renderText(0.865, 0.575, 0.018, "Interactive Control");		
		renderText(0.757, 0.59, 0.018, "IC:");
		renderText(0.865, 0.59, 0.018, "Heckscheibe");
		renderText(0.757, 0.605, 0.018, "IC:");
		renderText(0.865, 0.605, 0.018, "Frontscheibe");
		renderText(0.757, 0.62, 0.018, "IC:");
		renderText(0.865, 0.62, 0.018, "Fahrertuer");

		g_currentMission:addHelpButtonText(g_i18n:getText("ShowHelp2"), InputBinding.HUDINFO);
	end;
    if self.showhudAllrad == true then
      	self.hudAllradONOverlay:render();
	else	
	    self.hudAllradOFFOverlay:render();
    end;
end;
function STSgelberBulle:setblends1Visibility(visibility, noEventSend)
    if visibility ~= self.blends1Active then
  
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(Setblends1Event:new(self, visibility), nil, nil, self);
            else
                g_client:getServerConnection():sendEvent(Setblends1Event:new(self, visibility));
            end;
        end;
  
        self.blends1Active = visibility;
  
        for _, blend1 in pairs(self.blends1) do
            setVisibility(blend1.node, visibility);
        end;
        for _,v in pairs(self.specializations) do
            if v.setblend1Visibility ~= nil then
                v.setblend1Visibility(self, visibility);
            end;
        end;
    end;
end;
function STSgelberBulle:setblends2Visibility(visibility, noEventSend)
    if visibility ~= self.blends2Active then
  
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(Setblends2Event:new(self, visibility), nil, nil, self);
            else
                g_client:getServerConnection():sendEvent(Setblends2Event:new(self, visibility));
            end;
        end;
  
        self.blends2Active = visibility;
  
        for _, blend2 in pairs(self.blends2) do
            setVisibility(blend2.node, visibility);
        end;
        for _,v in pairs(self.specializations) do
            if v.setblend2Visibility ~= nil then
                v.setblend2Visibility(self, visibility);
            end;
        end;
    end;
end;
function STSgelberBulle:changeOil(oilChange)
	if oilChange.oilPalletVehicle ~= nil then
		oilChange.oilCapacity = oilChange.oilCapacity - 100;
		self.shouldChangeOil = false;
		self.nextOilChange = self.nextOilChange + self.oilChangeInterval;
	end;
end;
function STSgelberBulle:startMotor()
	self.exhaustingSystem.deltaTime = self.playMotorSoundTime - self.time - self.exhaustingSystem.offset;
end;
function STSgelberBulle:onDetach()
	self.oldAttacherJoint.steeringAxleNode = self.oldSteeringAxleNode;
end;
function STSgelberBulle:onAttach(attacherJoint)
	self.oldAttacherJoint = attacherJoint;
	self.oldSteeringAxleNode = attacherVehicle.steeringAxleNode;
	attacherJoint.steeringAxleNode = self.components[1].node
end;
function STSgelberBulle:onLeave()

	self.showHelp = false;

	if self.exhaustingSystem.cap ~= nil then
		setRotation(self.exhaustingSystem.cap, 0,0,0);
	end;

end;
function STSgelberBulle:addOperatingTime(addTime)
	
	local time = math.max(Utils.getNoNil(addTime, 0), 0);	
	self.operatingTime = self.operatingTime + time;	
	
	if self.operatingTime > (99999.9 * 1000 * 60 * 60) then
		self.operatingTime = 0;
	end;
end;
function STSgelberBulle:setNewLimit(level, percentage, noEventSend)	
	ESLimiterEvent.sendEvent(self, level, percentage, noEventSend);	
	self.ESLimiter.percentage[level] = percentage;
end;
function STSgelberBulle:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    if not resetVehicles or resetVehicles then
		local valueInt = getXMLInt(xmlFile, key.."#nextOilChange");
		if valueInt ~= nil then
			self.nextOilChange = valueInt;
		end;
		local Distance = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#odometer"), self.Odometer.Reading);
		self.Odometer.Reading = Distance;
	    local operatingTime = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#operatingTime"), self.operatingTime) * 1000;
	    self:addOperatingTime(operatingTime);
	    local valueStr = getXMLString(xmlFile, key.."#limiterValues");		
	    if valueStr ~= nil then
		    local found = string.find(valueStr, ";");
		    local index = 1;
		    while found ~= nil do
		    	local value = string.sub(valueStr, 0, found-1);
		    	valueStr = string.sub(valueStr, found+1);
		    	found = string.find(valueStr, ";");
		    	self.ESLimiter.percentage[index] = tonumber(value);
		    	if found == nil then
		    		self.ESLimiter.percentage[index+1] = tonumber(valueStr);
		    	end;
		    	index = index + 1;	
			end;
		end;
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;
function STSgelberBulle:getSaveAttributesAndNodes(nodeIdent)
	local attributes = nil;
	local values = "";	
	for k,v in pairs(self.ESLimiter.percentage) do
		if k ~= 1 then
			values = values .. ";";
		end;
		values = values .. string.format("%d", v);
	end;
	
    local attributes = 'limiterValues="'.. values .. '" operatingTime="' .. tostring((self.operatingTime / 1000)) ..'" odometer="' .. tostring(self.Odometer.Reading) ..'" nextOilChange="'.. self.nextOilChange .. '"';
    return attributes, nil;
end;

AllradStateEvent = {};
AllradStateEvent_mt = Class(AllradStateEvent, Event);
InitEventClass(AllradStateEvent, "AllradStateEvent");
function AllradStateEvent:emptyNew() 
    local self = Event:new(AllradStateEvent_mt );
    self.className="AllradStateEvent";
    return self;
end;
function AllradStateEvent:new(vehicle, state) 
    self.vehicle = vehicle;
    self.state = state;
    return self;
end;
function AllradStateEvent:readStream(streamId, connection)  
    local id = streamReadInt32(streamId); 
    self.state = streamReadBool(streamId); 
    self.vehicle = networkGetObject(id); 
    self:run(connection);  
end;
function AllradStateEvent:writeStream(streamId, connection)   
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
    streamWriteBool(streamId, self.state );   
end;
function AllradStateEvent:run(connection)  
    self.vehicle:allradState(self.state, true);
	if not connection:getIsServer() then  
		g_server:broadcastEvent(AllradStateEvent:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;
function AllradStateEvent.sendEvent(vehicle, state, noEventSend)  
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then  
			g_server:broadcastEvent(AllradStateEvent:new(vehicle, state), nil, nil, vehicle);
		else 
			g_client:getServerConnection():sendEvent(AllradStateEvent:new(vehicle, state));
		end;
	end;
end;

ESLimiterEvent = {};
ESLimiterEvent_mt = Class(ESLimiterEvent, Event);
InitEventClass(ESLimiterEvent, "ESLimiterEvent");
function ESLimiterEvent:emptyNew()
    local self = Event:new(ESLimiterEvent_mt);
    self.className="ESLimiterEvent";
    return self;
end;
function ESLimiterEvent:new(vehicle, level, percentage)
    local self = ESLimiterEvent:emptyNew()
    self.vehicle = vehicle;
	self.level = level;
	self.percentage = percentage;
    return self;
end;
function ESLimiterEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.level = streamReadInt8(streamId);
	self.percentage = streamReadInt16(streamId)/10;
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;
function ESLimiterEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.level);
	streamWriteInt16(streamId, self.percentage*10);
end;
function ESLimiterEvent:run(connection)
	self.vehicle:setNewLimit(self.level, self.percentage, true);
end;
function ESLimiterEvent.sendEvent(vehicle, level, percentage, noEventSend)
	
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			-- no need to broadcast the event: only the server need the information
		else
			g_client:getServerConnection():sendEvent(ESLimiterEvent:new(vehicle, level, percentage));
		end;
	end;
end;

OilChangeEvent = {};
OilChangeEvent_mt = Class(OilChangeEvent, Event);
InitEventClass(OilChangeEvent, "OilChangeEvent");
function OilChangeEvent:emptyNew()
    local self = Event:new(OilChangeEvent_mt);
    self.className="OilChangeEvent";
    return self;
end;
function OilChangeEvent:new(vehicle, oilChangeVehicle)
    local self = OilChangeEvent:emptyNew()
    self.vehicle = vehicle;
	self.oilChangeVehicle = oilChangeVehicle;
    return self;
end;
function OilChangeEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	local attacherId = streamReadInt32(streamId);
	self.oilChangeVehicle = networkGetObject(attacherId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;
function OilChangeEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt32(streamId, networkGetObjectId(self.oilChangeVehicle));
end;
function OilChangeEvent:run(connection)
	self.vehicle:changeOil(self.oilChangeVehicle, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(OilChangeEvent:new(self.vehicle, self.oilChangeVehicle), nil, connection, self.object);
    end;
end;
function OilChangeEvent.sendEvent(vehicle, oilChangeVehicle, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(OilChangeEvent:new(vehicle, oilChangeVehicle), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(OilChangeEvent:new(vehicle, oilChangeVehicle));
		end;
	end;
end;

Setblends1Event = {};
Setblends1Event_mt = Class(Setblends1Event, Event);
InitEventClass(Setblends1Event, "Setblends1Event");
function Setblends1Event:emptyNew()
      local self = Event:new(Setblends1Event_mt);
      self.className="Setblends1Event";
      return self;
end;
function Setblends1Event:new(object, active)
      local self = Setblends1Event:emptyNew()
      self.active = active;
      self.object = object;
      return self;
end;
function Setblends1Event:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.active = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
function Setblends1Event:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.active);
end;
function Setblends1Event:run(connection)
      self.object:setblends1Visibility(self.active, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(Setblends1Event:new(self.object, self.active), nil, connection, self.object);
      end;
end;

Setblends2Event = {};
Setblends2Event_mt = Class(Setblends2Event, Event);
InitEventClass(Setblends2Event, "Setblends2Event");
function Setblends2Event:emptyNew()
      local self = Event:new(Setblends2Event_mt);
      self.className="Setblends2Event";
      return self;
end;
function Setblends2Event:new(object, active)
      local self = Setblends2Event:emptyNew()
      self.active = active;
      self.object = object;
      return self;
end;
function Setblends2Event:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.active = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
function Setblends2Event:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.active);
end;
function Setblends2Event:run(connection)
      self.object:setblends2Visibility(self.active, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(Setblends2Event:new(self.object, self.active), nil, connection, self.object);
      end;
end;