VisibleEvent = {};
VisibleEvent_mt = Class(VisibleEvent, Event);

InitEventClass(VisibleEvent, "VisibleEvent");

function VisibleEvent:emptyNew()  
    local self = Event:new(VisibleEvent_mt );
    self.className="VisibleEvent";
    return self;
end;

function VisibleEvent:new(vehicle, visible)
    self.vehicle = vehicle;
    self.visible = visible;
    return self;
end;

function VisibleEvent:readStream(streamId, connection)  
    local id = streamReadInt32(streamId); 
    self.visible = streamReadBool(streamId);
    self.vehicle = networkGetObject(id); 
    self:run(connection);  
end;

function VisibleEvent:writeStream(streamId, connection)   
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
    streamWriteBool(streamId, self.visible );  
end;

function VisibleEvent:run(connection)  
    self.vehicle:Visibility(self.visible, true); 
	if not connection:getIsServer() then 
		g_server:broadcastEvent(VisibleEvent:new(self.vehicle, self.visible), nil, connection, self.object);
	end;
end;

function VisibleEvent.sendEvent(vehicle, visible, noEventSend) 
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then   
			g_server:broadcastEvent(VisibleEvent:new(vehicle, visible), nil, nil, vehicle);
		else 
			g_client:getServerConnection():sendEvent(VisibleEvent:new(vehicle, visible));
		end;
	end;
end;