--
-- JF92Z10

-- Author  Sandro_ADM
-- MAD date  27.05.2011
--
-- > farming simulator 2011 < --

JF92Z10SOUND = {};

function JF92Z10SOUND.prerequisitesPresent(specializations)
	return true;
end;

function JF92Z10SOUND:load(xmlFile)

    self.startRotor = SpecializationUtil.callSpecializationsFunction("startRotor");

    local ligarotor = getXMLString(xmlFile, "vehicle.ligarotor#file");
    if ligarotor ~= nil and ligarotor ~= "" then
        ligarotor = Utils.getFilename(ligarotor, self.baseDirectory); 
        self.ligarotor = createSample("ligarotor");
        loadSample(self.ligarotor, ligarotor, false);
        self.ligarotorPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.ligarotor#pitchOffset"), 1);
        self.ligarotorPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.ligarotor#pitchScale"), 0);
        self.ligarotorPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.ligarotor#pitchMax"), 2.0);
    end;

    local activesound = getXMLString(xmlFile, "vehicle.activesound#file");
    if activesound ~= nil and activesound ~= "" then
        activesound = Utils.getFilename(activesound, self.baseDirectory); 
        self.activesound = createSample("activesound");
        loadSample(self.activesound, activesound, false);
        self.activesoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.activesound#pitchOffset"), 1);
        self.activesoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.activesound#pitchScale"), 0);
        self.activesoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.activesound#pitchMax"), 2.0);
    end;

    local desligarotor = getXMLString(xmlFile, "vehicle.desligarotor#file");
    if desligarotor ~= nil and desligarotor ~= "" then
        desligarotor = Utils.getFilename(desligarotor, self.baseDirectory); 
        self.desligarotor = createSample("desligarotor");
        loadSample(self.desligarotor, desligarotor, false);
        self.desligarotorPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.desligarotor#pitchOffset"), 1);
        self.desligarotorPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.desligarotor#pitchScale"), 0);
        self.desligarotorPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.desligarotor#pitchMax"), 2.0);
    end;

	local rotorapanhando = getXMLString(xmlFile, "vehicle.rotorapanhando#file");
    if rotorapanhando ~= nil and rotorapanhando ~= "" then
	  rotorapanhando = Utils.getFilename(rotorapanhando, self.baseDirectory);
        self.rotorapanhando = createSample("rotorapanhando");
		loadSample(self.rotorapanhando, rotorapanhando, false);
		self.rotorapanhandoPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.rotorapanhando#pitchOffset"), 1);
    end;

    self.cardan = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cardan#index"));

end;

function JF92Z10SOUND:delete()
   
end;

function JF92Z10SOUND:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JF92Z10SOUND:keyEvent(unicode, sym, modifier, isDown)
end;

function JF92Z10SOUND:update(dt)


	



	
        if self:getIsActive() then

		if self.isTurnedOn and self.cardan ~= nil then
		rotate(self.cardan, -dt*-1.8, 0, 0);
		end;

		if Input.isKeyPressed(Input.KEY_x) then
                        if self.isTurnedOn and self.cardan ~= nil then
			self:startRotor();
                        self.activeRunning = true;
                        else
			stopSample(self.activesound);
 			playSample(self.desligarotor, 1, 1, 0);
			self.ligarotorRunning = false;
			end;
		end;

        if self.ligarotorRunning then
            if self.activeRunning then
                if self:getIsActiveForSound() then
                    if self.activesound ~= nil and self.activeRunningTime <= self.time then
                        playSample(self.activesound, 0, 1, 0);
                        self.activeRunning = false;
                    end;
                end;
            end;
        end;
	end;


end;

function JF92Z10SOUND:startRotor()
            if not self.ligarotorRunning then
                self.ligarotorRunning = true;
                local activesoundOffset = 0;
                if self.ligarotor ~= nil and self:getIsActiveForSound() then
                    setSamplePitch(self.ligarotor, self.ligarotorPitchOffset);
                    playSample(self.ligarotor, 1, 1, 0);
                    activesoundOffset = getSampleDuration(self.ligarotor);
                end;
                self.activeRunning = true;
                self.activeRunningTime = self.time+activesoundOffset;
            end;
end;


function JF92Z10SOUND:draw()
end;

function JF92Z10SOUND:onDetach()
end;

function JF92Z10SOUND:onLeave()
end;

function JF92Z10SOUND:delete()
    stopSample(self.activesound);
end;

function JF92Z10SOUND:LowRotor()
	playSample(self.rotorapanhando, 1, 1, 0);
end;
