--
-- bolko, kobajn ziemniaczany
-- by Lipa 
-- LS2011: Burner
--


bolko = {};

function bolko.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function bolko:load(xmlFile)
	self.currentFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
    self.wasToFast = false;
	self.isTurnedOn = false;
	self.fillScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillScale#value"), 1);
	self.beben = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.beben#index"));
	self.obrecz = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.obrecz#index"));
	self.talez = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.talez#index"));
	self.wom = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wom#index"));
	
	self.liscie = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.liscie.liscie(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.liscie, namei, nodei, false, nil, self.baseDirectory)		
		Utils.setEmittingState(self.liscie,false)
		self.particleSystemdisableTime = 0;
		i = i +1;		
    end;
	self.kurz = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.kurz.kurz(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.kurz, namei, nodei, false, nil, self.baseDirectory)		
		Utils.setEmittingState(self.kurz,false)
		self.particleSystemdisableTime = 0;
		i = i +1;		
    end;
end;


function bolko:update(dt)
	if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
            self.isTurnedOn = not self.isTurnedOn;
        end;
    end;
	self.wasToFast = false;
	if self:getIsActive() then
		if self.isTurnedOn and self.fillLevel < self.capacity then
				rotate(self.beben, dt*0.015, 0, 0 );
				rotate(self.obrecz, 0, 0, dt*(-0.001) );
				rotate(self.talez, dt*0.01, 0, 0 );
				rotate(self.wom, 0, 0, dt*20.0 );
            local toFast = self:doCheckSpeedLimit() and self.attacherVehicle.lastSpeed*3600 > 20;
            if not toFast then				
				local area =0;
                for k, cuttingArea in pairs(self.cuttingAreas) do
                    local x,y,z = getWorldTranslation(cuttingArea.start);
                    local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                    local x2,y2,z2 = getWorldTranslation(cuttingArea.height);

                    for fillType,v in pairs(self.fillTypes) do
                        if fillType ~= Fillable.FILLTYPE_UNKNOWN then
							if self.currentFillType == fillType or self.currentFillType == Fillable.FILLTYPE_UNKNOWN then
								local fruitType = FruitUtil.fillTypeToFruitType[fillType];
								Utils.updateFruitCutShortArea(fruitType, x, z, x1, z1, x2, z2, 1);
								local area = Utils.cutFruitArea(fruitType, x, z, x1, z1, x2, z2, 0)
								area = area + Utils.cutFruitArea(fruitType, x, z, x1, z1, x2, z2, 0);
								if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 and area > 0 then
									self.particleSystemdisableTime = self.time + 40;
									Utils.setEmittingState(self.liscie, true)	 
								end;
								if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 and area > 0 then
									self.particleSystemdisableTime = self.time + 40;
									Utils.setEmittingState(self.kurz, true)	 
								end;
								if area > 0 then
									self.currentFruitType = fruitType;
									local pixelToQm = 2048 / 4096 * 2048 / 4096  / g_currentMission.maxFruitValue; -- 4096px are mapped to 2048m
									local literPerQm = FruitUtil.fruitIndexToDesc[fruitType].literPerSqm * (0.50 * (3 - g_currentMission.missionStats.difficulty));
									local qm = area*pixelToQm;
									local deltaLevel = qm*literPerQm * self.fillScale;
									self:setFillLevel(self.fillLevel+deltaLevel, fillType);
								end;
							end;
                        end;
                    end;
                end;							
            end;
            self.wasToFast = toFast;
		else
			self.isTurnedOn = false;
		end; ---if self:getIsActive() then
    end;
	if self.time > self.particleSystemdisableTime then
		Utils.setEmittingState(self.liscie, false);
    end;
	if self.time > self.particleSystemdisableTime then
		Utils.setEmittingState(self.kurz, false);
    end;
end;

function bolko:mouseEvent(posX, posY, isDown, isUp, button)
end;

function bolko:keyEvent(unicode, sym, modifier, isDown)
end;

function bolko:draw()
	if self.isTurnedOn then
        g_currentMission:addExtraPrintText("Tipka/Taste B: Ukljuci berac/Turn off harvester");
    else
        g_currentMission:addExtraPrintText("Tipka/Taste B: Ukljuci berac/Turn off harvester");
    end;
	
	if self.attacherVehicle.lastSpeed*3600 > 21 and self.isTurnedOn then
		g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "1", InputBinding.getKeyNamesOfDigitalAction(InputBinding.SPEED_LEVEL1)), 0.07+0.022, 0.019+0.029);
	end;
end;

function bolko:onAttach()
end; 	

function bolko:onDetach()
	self.isTurnedOn = false;
end;

function bolko:onDeactivate()
    self.isTurnedOn = false;
end;

function bolko:delete()
end;

function bolko:onLeave()
end;