-- MapDoorTrigger
-- Script for MapDoorTrigger
--
-- @ Autor  Tobias F. (John Deere 6930)
-- @ Last Edit  11/06/2011

MapDoorTrigger = {};
MapDoorTrigger.doorTriggers = {};
MapDoorTrigger.saveTable = {};

-- saveSelectedGame Wrapper
local CareerScreenSaveSelectedGame = CareerScreen.saveSelectedGame;
CareerScreen.saveSelectedGame = function(self)
	CareerScreenSaveSelectedGame(self); 
	MapDoorTrigger:saveDoorTriggerStates();
end;

function MapDoorTrigger:loadMap(name)
	local dir = getUserProfileAppPath() .. "savegame"..g_currentMission.missionInfo.savegameIndex;
	createFolder(dir);
	self.mapDoorTriggers_xml = dir .. "/mapDoorTriggers.xml";
	if g_currentMission.missionInfo.isValid then
		self.firstTimeRun = true;
	else
		os.remove(self.mapDoorTriggers_xml);
		self.firstTimeRun = false;
	end;
	self.oldPlayerCount = 0;
end;

function MapDoorTrigger:deleteMap()
end;

function MapDoorTrigger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MapDoorTrigger:keyEvent(unicode, sym, modifier, isDown)
end;

function MapDoorTrigger:update(dt)
	if g_server ~= nil and self.firstTimeRun then
		self:loadDoorTriggerStates();
		self.firstTimeRun = false;
	end;
	if g_server ~= nil then
		local playerCount = 0;
		for _,_ in pairs(g_currentMission.players) do
			playerCount = playerCount + 1;
		end;
		if playerCount ~= self.oldPlayerCount then
			self.oldPlayerCount = playerCount;
			for _,doorTrigger in pairs(self.doorTriggers) do
				g_server:broadcastEvent(SetDoorStateEvent:new(doorTrigger, doorTrigger.doorIsOpened), nil, nil, nil);
			end;
		end;
	end;
end;

function MapDoorTrigger:draw()
end;

function MapDoorTrigger:addDoorTrigger(doorTrigger)
	table.insert(self.doorTriggers, doorTrigger)
end;

function MapDoorTrigger:saveDoorTriggerStates()
	local existDir = io.open (self.mapDoorTriggers_xml, "w");	
	if existDir == nil then
		createXMLFile("createDoorTrigger", self.mapDoorTriggers_xml, "saveDoorTrigger");
	end;
    local xmlFile = io.open (self.mapDoorTriggers_xml, "w");
    if xmlFile ~= nil then
        xmlFile:write('<?xml version="1.0" encoding="utf-8" standalone="no" ?>\n<doorTriggers>\n');
		for _,doorTrigger in pairs(self.doorTriggers) do
			xmlFile:write('    <doorTrigger savingName="'..doorTrigger.savingName..'" trackTime="'..doorTrigger.trackTime..'"  />\n');
		end;
        xmlFile:write("</doorTriggers>");
        xmlFile:close();
    end;	
end;

function MapDoorTrigger:loadDoorTriggerStates()
	local existDir = io.open (self.mapDoorTriggers_xml, "r");
	if existDir ~= nil then
		local xmlFile = loadXMLFile("TempConfig", self.mapDoorTriggers_xml);
		local i = 0;
		while true do
			local key = string.format("doorTriggers.doorTrigger(%d)", i);
			local savingName = getXMLString(xmlFile, key.."#savingName");
			local trackTime = getXMLFloat(xmlFile, key.."#trackTime");
			if (savingName or trackTime) == nil then
				break;
			end;
			local entry = {};
			entry.savingName = savingName;
			entry.trackTime = trackTime;
			self.saveTable[i] = entry;
			i = i + 1;
		end;
		delete(xmlFile);
	else
		print("Warning: ", self.mapDoorTriggers_xml, " can not be found, Door Trigger States not loaded.");
	end;
	for _, doorTrigger in pairs(self.doorTriggers) do
		for _,save in pairs(self.saveTable) do
			if doorTrigger.savingName == save.savingName then
				if save.trackTime > 0 then
					doorTrigger.doorIsOpened = true;
				else
					doorTrigger.doorIsOpened = false;
				end;
				doorTrigger.trackTime = save.trackTime;
			end;
		end;
	end;
end;
addModEventListener(MapDoorTrigger);

-- DoorTrigger
-- Script for DoorTrigger
--
-- @ Autor  Tobias F. (John Deere 6930)
-- @ Last Edit  11/06/2011

function onCreate(self, id)
	local instance = DoorTrigger:new(g_server ~= nil, g_client ~= nil);
	local index = g_currentMission:addOnCreateLoadedObject(instance);
	instance:load(id);
	instance:register(true);
end;

DoorTrigger = {};

local DoorTrigger_mt = Class(DoorTrigger, Object);

function DoorTrigger:new(isServer, isClient)
	local self = Object:new(isServer, isClient, DoorTrigger_mt);
	self.className = "DoorTrigger";
	return self;
end;

function DoorTrigger:load(name)
	self.triggerId = name;
	addTrigger(name, "triggerCallback", self);
	self.isEnabled = true;
	for i=0, getNumOfChildren(name)-1 do
		local child = getChildAt(name, i);
		setCollisionMask(child, 0);
	end;
	self.assignRigidType = true;
	self.assignRigidTypeTimeOut = g_currentMission.time+4000;
	self.count = 0;
	local inputKey = getUserAttribute(name, "inputKey");--string
	self.inputKey = InputBinding[inputKey];
	self.posText = getUserAttribute(name, "posText");--string
	self.negText =  getUserAttribute(name, "negText");--string
	self.savingName =  getUserAttribute(name, "savingName");--string			
	self.trackTime = 0;				
	self.lastTrackTime = 0;		
	self.doorIsOpened = false;
	local rootNodeName = getUserAttribute(name, "rootNodeName");--string
	if rootNodeName ~= nil then
		local rootNode = getChild(name, rootNodeName)
		self.animCharSet = 0;
		if rootNode ~= nil then	
			self.animCharSet = getAnimCharacterSet(rootNode);
			if self.animCharSet ~= 0 then					
				local clipSource = getUserAttribute(name, "animationClip");--string
				self.clip = getAnimClipIndex(self.animCharSet, clipSource);
				if self.clip ~= nil then
					if self.clip >= 0 then
						assignAnimTrackClip(self.animCharSet, 0, self.clip);
						setAnimTrackLoopState(self.animCharSet, 0, false);
						self.speedScale = Utils.getNoNil(getUserAttribute(name, "animSpeedScale"), 1.0);--float
						self.animDuration = getAnimClipDuration(self.animCharSet, self.clip);
						MapDoorTrigger:addDoorTrigger(self)
					end;
				end;
			end;
		end;
	end;
end;

function DoorTrigger:delete()
	removeTrigger(self.triggerId);
end;

function DoorTrigger:update()
	local activeSteeringInformations = false;
	if self.playerInDoorTrigger then
		activeSteeringInformations = true;
	else
		if self.vehicleInDoorTrigger ~= nil then
			if self.vehicleInDoorTrigger:getIsActive() then
				activeSteeringInformations = true;
			end;
		end;
	end;
	if activeSteeringInformations then
		if not self.doorIsOpened then
			g_currentMission:addHelpButtonText(g_i18n:getText(self.posText), self.inputKey);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText(self.negText), self.inputKey);
		end;				
		if InputBinding.hasEvent(self.inputKey) then
			self:setDoorState(not self.doorIsOpened);
		end;
	end;
	if self.assignRigidType and self.assignRigidTypeTimeOut <= g_currentMission.time then
		for i=0, getNumOfChildren(self.triggerId)-1 do
			local child = getChildAt(self.triggerId, i)
			setCollisionMask(child, 2102);
		end;
		self.assignRigidType = false;
	end;
end;

function DoorTrigger:updateTick()
	if self.trackTime < 1 then 
		self.trackTime = 0;
	end;
	if self.trackTime > self.animDuration then
		self.trackTime = self.animDuration;
	end;
	if self.doorIsOpened then
		if self.trackTime < self.animDuration then
			self.trackTime = self.trackTime +10*self.speedScale;
		end;
	else
		if self.trackTime > 0 then
			self.trackTime = self.trackTime -10*self.speedScale;
		end;
	end;	
	if self.lastTrackTime ~= self.trackTime then
		enableAnimTrack(self.animCharSet, self.clip);
		setAnimTrackTime(self.animCharSet, self.clip, self.trackTime, true);
		disableAnimTrack(self.animCharSet, self.clip);
		self.lastTrackTime = self.trackTime;
	end;
end;

function DoorTrigger:setDoorState(state, noEventSend)
	SetDoorStateEvent.sendEvent(self, state, noEventSend);
	self.doorIsOpened = state;
end;

function DoorTrigger:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if self.isEnabled then
		if (onEnter or onLeave) then
			local vehicle = g_currentMission.nodeToVehicle[otherShapeId];
			if vehicle ~= nil then
				self.playerInDoorTrigger = false;
				if onLeave then
					if self.vehicleInDoorTrigger == vehicle then
						self.vehicleInDoorTrigger = nil;
					end;
				else
					if vehicle ~= nil then
						self.vehicleInDoorTrigger = vehicle;
					end;
				end;
			else
				if g_currentMission.controlPlayer and g_currentMission.player ~= nil then
					if otherId == g_currentMission.player.rootNode then
						if onEnter then
							self.playerInDoorTrigger = true;
						else
							self.playerInDoorTrigger = false;
						end;
					end;
				else
					self.playerInDoorTrigger = false;
				end;
			end;
		end;
	else
		self.playerInDoorTrigger = false;
		self.vehicleInDoorTrigger = nil;
	end;
end;