--
-- PlayerJoinFix
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date:		01/08/11
-- @version:	v1.0
-- @history:	v1.0 - initial implementation
--

local modName = g_currentModName;
local Server_sendObjects_old = Server.sendObjects;

function Server:sendObjects(connection, x,y,z, viewDistanceCoeff)
    connection:sendEvent(PlayerJoinFixEvent:new());

    Server_sendObjects_old(self, connection, x,y,z, viewDistanceCoeff);
end;


PlayerJoinFixEvent = {};
PlayerJoinFixEvent_mt = Class(PlayerJoinFixEvent, Event);

InitEventClass(PlayerJoinFixEvent, "PlayerJoinFixEvent");

function PlayerJoinFixEvent:emptyNew()
    local self = Event:new(PlayerJoinFixEvent_mt);
    self.className = modName..".PlayerJoinFixEvent";
    return self;
end;

function PlayerJoinFixEvent:new()
    local self = PlayerJoinFixEvent:emptyNew()
    return self;
end;

function PlayerJoinFixEvent:readStream(streamId, connection)
	local tablesToSynch = {};
	for k,trigger in pairs(g_currentMission.tipTriggers) do
		if trigger:isa(ExtendedTipTrigger) then	
			table.insert(tablesToSynch, trigger);
		end;
	end;
	
    if connection:getIsServer() then
		local triggerNum = streamReadInt16(streamId);
		if triggerNum > 0 then
			for i=1, triggerNum do
				local transX = streamReadFloat32(streamId);
				local transY = streamReadFloat32(streamId);
				local transZ = streamReadFloat32(streamId);
				local offset = streamReadFloat32(streamId);
				local rotX = streamReadFloat32(streamId);
				local rotY = streamReadFloat32(streamId);
				local rotZ = streamReadFloat32(streamId);
				local fillLevel = streamReadFloat32(streamId);
				local fillType = streamReadUIntN(streamId, Fillable.sendNumBits);
				local serverId = streamReadInt32(streamId);			
				local fruit = Fillable.fillTypeIntToName[fillType];	
				local trigger = g_currentMission.alternativeTipTrigger:createTrigger({transX, transY, transZ, offset}, {rotX, rotY, rotZ},  fruit, fillLevel);
				g_client:finishRegisterObject(trigger, serverId);
			end;
		end;
		connection:sendEvent(PlayerJoinFixEvent:new(tablesToSynch));
	else
		local numObjects = table.getn(tablesToSynch);
        for i=1, numObjects do
            local object = tablesToSynch[i];
            g_server:finishRegisterObject(connection, object);
        end;
    end;
end;

function PlayerJoinFixEvent:writeStream(streamId, connection)
    if not connection:getIsServer() then
		count = 0;
		for _,trigger in pairs(g_currentMission.tipTriggers) do
			if trigger.isExtendedTrigger then
				count = count + 1;
			end;
		end;
		streamWriteInt16(streamId, count);
		for _,trigger in pairs(g_currentMission.tipTriggers) do
			if trigger.isExtendedTrigger then
				local transform = getParent(trigger.triggerId);
				local transX, transY, transZ = getWorldTranslation(transform);
				streamWriteFloat32(streamId, transX);
				streamWriteFloat32(streamId, transY);
				streamWriteFloat32(streamId, transZ);
				local _,offset,_ = getTranslation(getChildAt(trigger.triggerId, 0));
				streamWriteFloat32(streamId, offset);
				local rotX, rotY, rotZ = getWorldRotation(transform);
				streamWriteFloat32(streamId, rotX);
				streamWriteFloat32(streamId, rotY);
				streamWriteFloat32(streamId, rotZ);			
				streamWriteFloat32(streamId, trigger.fillLevel);			
				streamWriteUIntN(streamId, trigger.currentFillType, Fillable.sendNumBits);
				streamWriteInt32(streamId, trigger.id);
			end;
		end;
    end;
end;

function PlayerJoinFixEvent:run(connection)
    print("PlayerJoinFixEvent Run function should never be called");
end;