--
-- SugarbeetTipTrigger
-- Specialization for SugarbeetTipTrigger
--
-- JB Modding
-- @author  Benjamin "Bayn" Biot
-- @date:		02/09/11
-- @version:	v1.0
-- @history:	v1.0 - initial implementation
-- @Based on "ExtendedTipTrigger" script by Manuel Leithner - SFM Modding.

-- local copy of directory
local modName = g_currentModName;
local modDir = g_currentModDirectory;

SugarbeetTipTrigger = {}; 
SugarbeetTipTrigger_mt = Class(SugarbeetTipTrigger, ExtendedTipTrigger);
InitObjectClass(SugarbeetTipTrigger, modName .. ".SugarbeetTipTrigger");

function SugarbeetTipTrigger:new(isServer, isClient, customMt)
    local mt = customMt;
    if mt == nil then
        mt = SugarbeetTipTrigger_mt;
    end;

    local self = ExtendedTipTrigger:new(isServer, isClient, mt);
    return self;
end;

function SugarbeetTipTrigger:load(id, trigger, fruitType)
	SugarbeetTipTrigger:superClass().load(self, id, trigger, fruitType);
end;

function SugarbeetTipTrigger:readStream(streamId, connection)
	SugarbeetTipTrigger:superClass().readStream(self, streamId, connection);	
end;

function SugarbeetTipTrigger:writeStream(streamId, connection)
	SugarbeetTipTrigger:superClass().writeStream(self, streamId, connection);
end;

function SugarbeetTipTrigger:readUpdateStream(streamId, timestamp, connection)
	SugarbeetTipTrigger:superClass().readUpdateStream(self, streamId, timestamp, connection);
end;

function SugarbeetTipTrigger:writeUpdateStream(streamId, connection, dirtyMask)
	SugarbeetTipTrigger:superClass().writeUpdateStream(self, streamId, connection, dirtyMask);
end;

function SugarbeetTipTrigger:isValidForLoad(node)
	--SugarbeetTipTrigger:superClass().isValidForLoad(self, node);
	local ax,ay,az = getWorldTranslation(node);
	local bx,by,bz = getWorldTranslation(self.movingId);
	local distance = Utils.vector2Length(bx-ax, bz-az);	
	local thresholdRadius = 3;
	local thresholdHeight = 0.1;
	
	if distance < 1 + thresholdRadius * (self.fillLevel / self.capacity) and ay < thresholdHeight + by then
		return true;
	end;
	return false;
end;

function SugarbeetTipTrigger:update(dt)
	--SugarbeetTipTrigger:superClass().update(self, dt);
	if self.shovelInRange ~= nil and self.isRemovalAllowed then
		if self.shovelInRange.fillTypes ~= nil and self.shovelInRange.setFillLevel ~= nil and self.shovelInRange.fillLevel ~= nil and not (self.shovelInRange.fallOut == nil or self.shovelInRange.fallOut) then
			if self.shovelInRange:allowFillType(self.currentFillType, true) then
				if self.shovelInRange.fillLevel < self.shovelInRange.capacity then
					if self:isValidForLoad(self.shovelInRange.tipReferencePoint) then
						local deltaFillLevel = dt*3;
						if self.shovelInRange.isSugarbeetCleanerLoader then
							deltaFillLevel =  self.shovelInRange.unloadingCapacity*dt/500;
						end;
						deltaFillLevel = math.min(deltaFillLevel, self.shovelInRange.capacity - self.shovelInRange.fillLevel);
						self.shovelInRange:setFillLevel(self.shovelInRange.fillLevel + deltaFillLevel, self.currentFillType);
						self:updateMoving(-deltaFillLevel);
					end;
				end;
			end;
		end;
	end;	
	if self.currentShovel ~= nil and self.currentFillType == Fillable.FILLTYPE_MANURE then
        local shovel = self.currentShovel;
        if not shovel.manureIsFilled and not shovel:getIsManureEmptying() then	
			local node = shovel.rootNode;
			if shovel.shovelTipReferenceNode ~= nil then
				node = shovel.shovelTipReferenceNode;
			end;
			if self:isValidForLoad(node) then
				local delta = math.max(math.min(shovel.manureCapacity, self.fillLevel), 0);
				if delta > 0 then
					shovel:setManureIsFilled(true);
					self:updateMoving(-delta);
				end;
			end;		
        end;
    end;	
end;

function SugarbeetTipTrigger:delete()
	SugarbeetTipTrigger:superClass().delete(self);
end;

function SugarbeetTipTrigger:draw()
end;

function SugarbeetTipTrigger:updateMoving(delta)	
	SugarbeetTipTrigger:superClass().updateMoving(self, delta);
end;

function SugarbeetTipTrigger:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	SugarbeetTipTrigger:superClass().triggerCallback(self, triggerId, otherId, onEnter, onLeave, onStay, otherShapeId);
end;

function SugarbeetTipTrigger:onLoad(xmlFile, key)
	SugarbeetTipTrigger:superClass().onLoad(self, xmlFile, key);
end;

function SugarbeetTipTrigger:onSave()
	SugarbeetTipTrigger:superClass().onSave(self);
end;