--
-- WeighingCounter
-- Specialization for counting loaded sugarbeet
--
-- @author:  	Burner
-- @date:		06.03.2012
-- 
-----------------------------
--
-- specialization based on:
--
-- ThreshingCounter
-- Specialization for counting threshed hectars
--
-- @author:  	Manuel Leithner
-- @date:		15/11/11
-- @version:	v1.0
-- @history:	v1.0 - initial implementation
--

WeighingCounter = {};

function WeighingCounter.prerequisitesPresent(specializations)
    return true;
end;

function WeighingCounter:load(xmlFile)
	self.resetWeighingCounter = SpecializationUtil.callSpecializationsFunction("resetWeighingCounter");
	self.doResetWeighingCounter = false;

	self.sessionWeight = 0;	
	self.totalWeight = 0;
	self.wcX = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.WeighingCounter#posX"), 0.7543);
	self.wcY = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.WeighingCounter#posY"), 0.213);
	self.yOffset = 0.0085;
	self.wc = Overlay:new("hudwc", Utils.getFilename("Textures/WeighingCounter_hud.png", self.baseDirectory), self.wcX, self.wcY, 0.2371, 0.039525);	
end;

function WeighingCounter:delete()
end;

function WeighingCounter:readStream(streamId, connection)
	local session = streamReadFloat32(streamId);
	local total = streamReadFloat32(streamId);	
	self.sessionWeight = session;
	self.totalWeight = total;
	self:resetWeighingCounter(streamReadBool(streamId), true);
end;

function WeighingCounter:writeStream(streamId, connection)	
	streamWriteFloat32(streamId, self.sessionWeight);
	streamWriteFloat32(streamId, self.totalWeight);
	streamWriteBool(streamId, self.doResetWeighingCounter);
end;

function WeighingCounter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function WeighingCounter:keyEvent(unicode, sym, modifier, isDown)
end;

function WeighingCounter:update(dt)
	self.sessionWeight = self.sessionWeight + (self.fillDelta/1000);
	self.totalWeight = self.totalWeight + (self.fillDelta/1000);
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.EuroMaus_ResetWeighingCounter) then
			self:resetWeighingCounter(true);
		end;
	end;
	if self.doResetWeighingCounter then
		self.sessionWeight = 0;
		self.doResetWeighingCounter = false;
	end;
end;

function WeighingCounter:updateTick(dt)

	
	--[[
	if self.isServer and self.isWeighing then	
		local lastArea = 0;
		for cutter,implement in pairs(self.attachedCutters) do
			lastArea = lastArea + Utils.getNoNil(cutter.lastRealArea, 0);
		end;
		
		local pixelToSqm = g_currentMission:getFruitPixelsToSqm();
		local sqm = lastArea*pixelToSqm;
		local ha = sqm/10000;		
		self.lastAreaSent = self.lastAreaSent + ha;	
	

		
		if self.lastAreaSent > 0.02 then
			g_server:broadcastEvent(WeighingCounterEvent:new(self, self.lastAreaSent));
			self.lastAreaSent = 0;
		end;
	end;
	]]
end;

function WeighingCounter:draw()
	
	local counterSession = math.floor(self.sessionWeight*100) / 100;
	local counterTotal = math.floor(self.totalWeight*10) / 10;
	local fullSession = math.floor(counterSession);
	local fullTotal = math.floor(counterTotal);
	local deciSession = math.floor((counterSession - fullSession)*100);
	if deciSession < 10 then
		deciSession = "0" .. deciSession;
	end;
	local deciTotal = math.floor((counterTotal - fullTotal)*10);
	
	self.wc:render();
	setTextAlignment(RenderText.ALIGN_RIGHT);
	setTextBold(true);	
	setTextColor(0, 0, 0, 1);
    renderText(self.wcX+0.08, self.wcY+self.yOffset - 0.003, 0.022, tostring(fullTotal) .. ",");
	renderText(self.wcX+0.071+0.2371/2, self.wcY+self.yOffset - 0.003, 0.022, tostring(fullSession) .. ",");
	setTextColor(1,1,1,1);
	renderText(self.wcX+0.08, self.wcY+self.yOffset, 0.022, tostring(fullTotal) .. ",");
	renderText(self.wcX+0.071+0.2371/2, self.wcY+self.yOffset, 0.022, tostring(fullSession) .. ",");
	setTextColor(0, 0, 0, 1);
    renderText(self.wcX+0.089, self.wcY+self.yOffset - 0.003, 0.023, tostring(deciTotal));
	renderText(self.wcX+0.089 + 0.2371/2, self.wcY+self.yOffset - 0.003, 0.023, tostring(deciSession));
	setTextColor(0.95,0,0,1);
	renderText(self.wcX+0.089, self.wcY+self.yOffset, 0.023, tostring(deciTotal));
	renderText(self.wcX+0.089 + 0.2371/2, self.wcY+self.yOffset, 0.023, tostring(deciSession));
	setTextColor(0, 0, 0, 1);
    renderText(self.wcX+0.101, self.wcY+self.yOffset - 0.003, 0.023, "t");
	renderText(self.wcX+0.101+0.2371/2, self.wcY+self.yOffset - 0.003, 0.023, "t");
	setTextColor(1,1,1,1);
	renderText(self.wcX+0.101, self.wcY+self.yOffset, 0.023, "t");
	renderText(self.wcX+0.101+0.2371/2, self.wcY+self.yOffset, 0.023, "t");
	setTextAlignment(RenderText.ALIGN_LEFT);
end;

function WeighingCounter:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
	if not resetVehicles then
		local totalWeight = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#totalWeight"), self.totalWeight);
		local sessionWeight = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#resetableWeight"), self.sessionWeight);
		self.totalWeight = totalWeight;
		self.sessionWeight = sessionWeight;
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function WeighingCounter:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'totalWeight="' .. tostring(self.totalWeight) ..'" resetableWeight="' .. tostring(self.sessionWeight) ..'"';
	return attributes, nil;
end;

function WeighingCounter:resetWeighingCounter(doResetCounter,noEventSend)
	ResetWeighingCounterEvent.sendEvent(self, doResetCounter, noEventSend);
	self.doResetWeighingCounter = doResetCounter;	
end;

--[[
WeighingCounterEvent = {};
WeighingCounterEvent_mt = Class(WeighingCounterEvent, Event);

InitEventClass(WeighingCounterEvent, "WeighingCounterEvent");

function WeighingCounterEvent:emptyNew()
    local self = Event:new(WeighingCounterEvent_mt);
    self.className="WeighingCounterEvent";
    return self;
end;

function WeighingCounterEvent:new(vehicle, lastArea)
    local self = WeighingCounterEvent:emptyNew()
    self.vehicle = vehicle;
	self.lastArea = lastArea;
    return self;
end;

function WeighingCounterEvent:readStream(streamId, connection)
	local vehicle = networkGetObject(streamReadInt32(streamId));
	local newHectars = streamReadFloat32(streamId);
	vehicle.sessionHectars = vehicle.sessionHectars + newHectars;
	vehicle.totalWeight = vehicle.totalWeight + newHectars;
end;

function WeighingCounterEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteFloat32(streamId, self.lastArea);
end;

function WeighingCounterEvent:run(connection)
end;
]]

-- Reset counter event --
ResetWeighingCounterEvent = {};
ResetWeighingCounterEvent_mt = Class(ResetWeighingCounterEvent, Event);

InitEventClass(ResetWeighingCounterEvent, "ResetWeighingCounterEvent");

function ResetWeighingCounterEvent:emptyNew()
    local self = Event:new(ResetWeighingCounterEvent_mt);
    self.className="ResetWeighingCounterEvent";
    return self;
end;

function ResetWeighingCounterEvent:new(vehicle, resetCounter)
    local self = ResetWeighingCounterEvent:emptyNew()
    self.vehicle = vehicle;
	self.resetCounter = resetCounter;
    return self;
end;

function ResetWeighingCounterEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.resetCounter = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function ResetWeighingCounterEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.resetCounter);
end;

function ResetWeighingCounterEvent:run(connection)   
	self.vehicle:resetWeighingCounter(self.resetCounter, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(ResetWeighingCounterEvent:new(self.vehicle, self.resetCounter), nil, connection, self.vehicle);
    end;
end;

function ResetWeighingCounterEvent.sendEvent(vehicle, resetCounter, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ResetWeighingCounterEvent:new(vehicle, resetCounter), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ResetWeighingCounterEvent:new(vehicle, resetCounter));
		end;
	end;
end;