--
-- BGABunker
--
-- M@D Author:  Heady
-- M@D date: 06.01.2011
--
-- > Copyright (C) Heady - www.planet-ls.de < --
--

print("  Map: MapBGABunker v1.0 loaded");

if BaseMission.modMapShovelTrigger == nil then
	BaseMission.modMapShovelTrigger = {};
	print("  Register Variable: BaseMission.modMapShovelTrigger");
end;

ModEvent = {};

ModEvent.bunkers = {};

function ModEvent:loadMap(name)

	local dir = getUserProfileAppPath() .. "savegame"..g_currentMission.missionInfo.savegameIndex;
	createFolder(dir);
	self.saveXMLFile = dir .. "/bgaBunker.xml";

	if g_currentMission.missionStats.fuelUsageTotal == 0 then
		os.remove(self.saveXMLFile);
		self.firstTimeRun = false;
	else
		--MapBGABunker:loadFromXML();
		self.firstTimeRun = true;
	end;
	
end;

function ModEvent:deleteMap()
	
	ModEvent.bunkers = {};

end;

function ModEvent:delete()
end;

function ModEvent:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ModEvent:keyEvent(unicode, sym, modifier, isDown)
end;

function ModEvent:update(dt)

	if g_server ~= nil then

		if self.firstTimeRun then
			ModEvent:loadFromXML();
			self.firstTimeRun = false;
		end;
		
	end;

	--[[for i=1, table.getn(ModEvent.silos) do
		ModEvent.silos[i]:update(dt);
	end;]]

end;

function ModEvent:draw()

	for i=1, table.getn(ModEvent.bunkers) do
		ModEvent.bunkers[i]:draw();
	end;
	
end;

local CareerScreenSaveSelectedGame = CareerScreen.saveSelectedGame;
CareerScreen.saveSelectedGame = function(self)
	CareerScreenSaveSelectedGame(self); 
	ModEvent:saveToXML();
end;

function ModEvent:saveToXML()		
	
	local existDir = io.open (self.saveXMLFile, "w");	
	if existDir == nil then
		createXMLFile("createbunker", self.saveXMLFile, "savebunker");
	end;

    local xmlFile = io.open (self.saveXMLFile, "w");
    if xmlFile ~= nil then
        xmlFile:write('<?xml version="1.0" encoding="utf-8" standalone="no" ?>\n<bgaBunkers>\n');

		for i=1, table.getn(ModEvent.bunkers) do
			local bunker = ModEvent.bunkers[i];
			xmlFile:write('    <bunker bunkerFillLevel="'..bunker.fillLevel..'" manureFillLevel="'..bunker.manure.fillLevel..'" money="'..bunker.money..'" yesterDayMoney="'..bunker.yesterDayMoney..'" />\n');
		end;		
		
        xmlFile:write("</bgaBunkers>");

        xmlFile:close();
    end;	
	
end;

function ModEvent:loadFromXML()
	
	local existDir = io.open (self.saveXMLFile, "r");
	if existDir ~= nil then
		local xmlFile = loadXMLFile("TempConfig", self.saveXMLFile);
		
		local i = 0;
		while true do
			local key = string.format("bgaBunkers.bunker(%d)", i);
			local fillLevel = getXMLFloat(xmlFile, key.."#bunkerFillLevel");
			if fillLevel ~= nil then
				local bunker = ModEvent.bunkers[i+1];
				
				bunker.fillLevel = fillLevel;
				bunker.manure.fillLevel = getXMLFloat(xmlFile, key.."#manureFillLevel");
				bunker.money = getXMLFloat(xmlFile, key.."#money");
				bunker.yesterDayMoney = getXMLFloat(xmlFile, key.."#yesterDayMoney");
			else
				break;
			end;
			
			i = i +1;
		end;
		
		delete(xmlFile);
		print("BGA Bunker saves loaded");
	else
		print("Warning: ", self.saveXMLFile, " can not be found, BGA Bunker saves not loaded.")
	end;
	
end;

addModEventListener(ModEvent);



function onCreate(self, id)
	--print("created MapBGABunker, id: ", id);
	local instance = MapBGABunker:new(g_server ~= nil, g_client ~= nil);
	local index = g_currentMission:addOnCreateLoadedObject(instance);
	instance:load(id);
	instance:register(true); -- add update routine, 
	table.insert(ModEvent.bunkers, instance);
end;

MapBGABunker = {};

local MapBGABunker_mt = Class(MapBGABunker, Object);

function MapBGABunker:new(isServer, isClient)

	local self = Object:new(isServer, isClient, MapBGABunker_mt);
	self.className = "MapBGABunker";

	return self;
end;

function MapBGABunker:load(id)

	addTrigger(id, "bunkerCallback", self);
	
	self.moveMaxY = getUserAttribute(id, "moveMaxY");
	self.moveMinY = getUserAttribute(id, "moveMinY");
	self.capacity = getUserAttribute(id, "capacity");
	self.electricityPrice = getUserAttribute(id, "electricityPrice");
	self.power = getUserAttribute(id, "power");
	self.siloPlane = Utils.indexToObject(getParent(id), getUserAttribute(id, "movingIndex"));
	
	self.allowFillTypes = {};
	local types = Utils.splitString(" ", getUserAttribute(id, "fruitTypes"));
	for k,v in pairs(types) do
		if FruitUtil.fruitTypes[v] ~= nil then
			self.allowFillTypes[FruitUtil.fruitTypeToFillType[FruitUtil.fruitTypes[v].index]] = true;
		end;
	end;
	
	self.emptyNode = id;

	self.fillLevel = 0;
	self.money = 0;
	self.yesterDayMoney = 0;

	
	table.insert(g_currentMission.modMapShovelTrigger, self);

	
	self.manure = {};
	local manureTrigger = Utils.indexToObject(getParent(id), getUserAttribute(id, "manureTriggerIndex"));
	self.manure.moveMaxY = getUserAttribute(manureTrigger, "moveMaxY");
	self.manure.moveMinY = getUserAttribute(manureTrigger, "moveMinY");
	self.manure.capacity = getUserAttribute(manureTrigger, "capacity");
	self.manure.manurePlane = Utils.indexToObject(getParent(manureTrigger), getUserAttribute(manureTrigger, "movingIndex"));	
	self.manure.fillSpeed = getUserAttribute(manureTrigger, "fillSpeed");
	local fillType = getUserAttribute(manureTrigger, "fillType");	
	self.manure.fillType = Fillable.fillTypeNameToInt[fillType]	
	
	addTrigger(manureTrigger, "manureTriggerCallback", self);

	self.manure.trailerInTrigger = nil;	
	self.manure.fillLevel = 0;
	
	self.manure.fill = false;
	
	self.serverUpdate = false;

end;

function MapBGABunker:delete()
end;

function MapBGABunker:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MapBGABunker:keyEvent(unicode, sym, modifier, isDown)
end;

function MapBGABunker:update(dt)

	if g_server ~= nil then
	

		if self.fillLevel > 0 and self.manure.fillLevel < self.manure.capacity then
			local LPerKWPerHour = 2.29; --20t/1kw/365/24 #rounded
			local level = self.power * (LPerKWPerHour*(dt*g_currentMission.environment.timeScale)/(1000*60*60));
			self.fillLevel = self.fillLevel - level;
			self.manure.fillLevel = self.manure.fillLevel + level;
			--self.money = self.money + (self.electricityPrice*self.power)*((dt*g_currentMission.environment.timeScale)/(1000*60*60)); -- 1h=1000*60*60
			self.money = self.money + (self.electricityPrice*self.power)*((dt*6)/(1000*60*60)); -- 1h=1000*60*60 -- 16 = timescale
			
			self:setFillLevel(self.fillLevel, nil);
			--g_server:broadcastEvent(MPUpate:new(self));
			self.serverUpdate = true;
		end;
		
		if g_currentMission.environment.dayTime == 0 then
			--g_currentMission.missionStats.money = g_currentMission.missionStats.money + self.money;
			g_currentMission:addSharedMoney(self.money);
			self.yesterDayMoney = self.money;
			self.money = 0;
		end;

		if self.fillLevel > self.capacity+1000 then
			self.fillLevel = self.capacity+1000;
		end;
		if self.fillLevel < 0 then
			self.fillLevel = 0;
		end;
		
	end;
	
		
	if self.manure.fillLevel > 0 then
		local m = (self.manure.moveMaxY - self.manure.moveMinY) / self.manure.capacity;
		local xPos, yPos, zPos = getTranslation(self.manure.manurePlane);
		setTranslation(self.manure.manurePlane, xPos, m*self.manure.fillLevel + self.manure.moveMinY, zPos);		
	end;	

	local manureFill = self.manure.fill;
	if self.manure.trailerInTrigger ~= nil and self.manure.fillLevel > 0 then	
		if g_currentMission.controlledVehicle ~= nil then
			if self.manure.trailerInTrigger.attacherVehicle == g_currentMission.controlledVehicle then
			
				if InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT)  then
					self.manure.fill = not self.manure.fill; 
				end; 
				
			end;
		end;
			
		local trailer = self.manure.trailerInTrigger;
		if trailer.fillLevel < trailer.capacity then
			if g_server ~= nil then
			
				if self.manure.trailerInTrigger.isShovel ~= nil or self.manure.trailerInTrigger.getFromSilo ~= nil then
					local deltaFillLevel = dt*self.manure.fillSpeed;
					trailer:setFillLevel(trailer.fillLevel+deltaFillLevel, self.manure.fillType);
					self.manure.fillLevel = self.manure.fillLevel - deltaFillLevel;
					
					self.serverUpdate = true;
				else
					if self.manure.fill then							
						local deltaFillLevel = dt*self.manure.fillSpeed;
						trailer:setFillLevel(trailer.fillLevel+deltaFillLevel, self.manure.fillType);
						self.manure.fillLevel = self.manure.fillLevel - deltaFillLevel;
						
						self.serverUpdate = true;
					end;
				end;
				
			end;
		else
			self.manure.fill = false;
		end;
	else
		self.manure.fill = false;
	end;
	
	if manureFill ~= self.manure.fill then
		self:updateSendEvent();
	end;
	
	if g_server ~= nil then
		if self.serverUpdate then
			g_server:broadcastEvent(MPUpate:new(self));
			self.serverUpdate = false;
		end;		
	end;	
	
	
end;

function MapBGABunker:draw()

	if self.manure.trailerInTrigger ~= nil and self.manure.fillLevel > 0 then
		if self.manure.trailerInTrigger.fillLevel < self.manure.trailerInTrigger.capacity and self.manure.trailerInTrigger.isShovel == nil and self.manure.trailerInTrigger.getFromSilo == nil then
			if g_currentMission.controlledVehicle ~= nil then
				if self.manure.trailerInTrigger.attacherVehicle == g_currentMission.controlledVehicle then
					if self.manure.fill then
						g_currentMission:addExtraPrintText(g_i18n:getText("BGAMANURE_1").." "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.ACTIVATE_OBJECT)); 
					else
						g_currentMission:addExtraPrintText(g_i18n:getText("BGAMANURE_2").." "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.ACTIVATE_OBJECT)); 
					end;
				end;
			end;
		end;
	end;

end;

function MapBGABunker:setFillLevel(fillLevel, fillType)

	self.fillLevel = fillLevel;
	
	local m = (self.moveMaxY - self.moveMinY) / self.capacity;
	local xPos, yPos, zPos = getTranslation(self.siloPlane);
	setTranslation(self.siloPlane, xPos, m*self.fillLevel + self.moveMinY, zPos);

end;

function MapBGABunker:allowFillType(fillType, allowEmptying)
    local allowed = false;

    if self.allowFillTypes[fillType] then
        allowed = true;
    end;

    return allowed;
end;

function MapBGABunker:bunkerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	
	if onEnter then
        if otherId ~= 0 then
            local object = g_currentMission:getNodeObject(otherId);

            if object ~= nil then
                if object:isa(Bale) then

                    if g_currentMission:getIsServer() then
                        self.fillLevel = self.fillLevel + 3000;
                        object:delete();
                    end;
                --elseif not object:isa(Vehicle) then -- do not delete vehicles, but everything else
                    --if g_currentMission:getIsServer() then
                        --object:delete();
                    --end;
                end;
            end;

        end;
    end;	
	
end;

function MapBGABunker:manureTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)

    if onEnter then
		if otherId ~= nil then		
			local trailer = g_currentMission.objectToTrailer[otherId];
			if trailer ~= nil then
				if trailer.fillTypes ~= nil and trailer.setFillLevel ~= nil and trailer.fillLevel ~= nil then
					if trailer.fillLevel < trailer.capacity and trailer:allowFillType(self.manure.fillType, true) then
						self.manure.trailerInTrigger = trailer;
					end;
				end;
			end;
		end;		
	elseif onLeave then
		if otherId ~= nil then		
			local trailer = g_currentMission.objectToTrailer[otherId];
			if trailer ~= nil then
				if self.manure.trailerInTrigger == trailer then
					self.manure.trailerInTrigger = nil;
				end;
			end;
		end;
	end;

end;

function MapBGABunker:updateSendEvent()	

	if g_server ~= nil then
		g_server:broadcastEvent(MPEvent:new(self));
	else
		g_client:getServerConnection():sendEvent(MPEvent:new(self));
	end

end;

--[[function MapBGABunker:updateSendUpdate()	

	if g_server ~= nil then
		g_server:broadcastEvent(MPUpate:new(self));
	else
		g_client:getServerConnection():sendEvent(MPUpate:new(self));
	end

end;]]

