--
-- Multiplayer Event Script
--
-- M@D Author:  Heady
-- M@D date: 22.11.2010
--
-- > Copyright (C) Heady - www.planet-ls.de < --
--

MPEvent = {};
MPEvent_mt = Class(MPEvent, Event);

InitEventClass(MPEvent, "MPEvent");

function MPEvent:emptyNew()
    local self = Event:new(MPEvent_mt);
    self.className="MPEvent";
    return self;
end;

function MPEvent:new(object)
    local self = MPEvent:emptyNew()
    self.object = object;
    return self;
end;

function MPEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId)
    self.object = networkGetObject(id);
    self.object.manure.fill = streamReadBool(streamId);

	if not connection:getIsServer() then
		g_server:broadcastEvent(MPEvent:new(self.object), nil, connection, self.object);
	end;
end;

function MPEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteBool(streamId, self.object.manure.fill);
end;


MPUpate = {};
MPUpate_mt = Class(MPUpate, Event);

InitEventClass(MPUpate, "MPUpate");

function MPUpate:emptyNew()
    local self = Event:new(MPUpate_mt);
    self.className="MPUpate";
    return self;
end;

function MPUpate:new(object)
    local self = MPUpate:emptyNew()
    self.object = object;
    return self;
end;

function MPUpate:readStream(streamId, connection)
    local id = streamReadInt32(streamId)
    self.object = networkGetObject(id);
    self.object.fillLevel = streamReadInt32(streamId)
    self.object.manure.fillLevel = streamReadInt32(streamId)
	
	self.object:setFillLevel(self.object.fillLevel, nil);

	if not connection:getIsServer() then
		g_server:broadcastEvent(MPUpate:new(self.object), nil, connection, self.object);
	end;
end;

function MPUpate:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteInt32(streamId, self.object.fillLevel);
	streamWriteInt32(streamId, self.object.manure.fillLevel);
end;
